/*
 * Decompiled with CFR 0.152.
 */
package javabot.knowledge;

import java.awt.Point;
import javabot.JNIBWAPI;
import javabot.JavaBot;
import javabot.knowledge.GlobalKnowledge;
import javabot.operators.Operators;

public class Strategy {
    public RaceType enemyRace = RaceType.Terran;
    public int idealNbDrones = 70;
    public int idealNbHydras = 33;
    public int idealNbQueens = 32;
    public int idealNbZerglings = 30;
    public int idealNbMutalisks = 0;
    public int idealNbGuardians = 5;
    public int idealNbDevourers = 4;
    public int idealPopHydras = 0;
    public int idealPopQueens = 0;
    public int idealPopZerglings = 0;
    public int idealPopMutalisks = 0;
    public int idealPopGuardians = 0;
    public int idealPopDevourers = 0;
    public int nbDronesTotal = 0;
    public int nbOverlordsTotal = 0;
    public int nbZerglingsTotal = 0;
    public int nbHydralisksTotal = 0;
    public int nbQueensTotal = 0;
    public int nbMutalisksTotal = 0;
    public int nbGuardiansTotal = 0;
    public int nbDevourersTotal = 0;
    public int mineralsPerMinute = 0;
    public int gasPerMinute = 0;
    public boolean needMoreGas = false;
    public boolean needMoreMinerals = false;
    public int nbHatcheryTotal = 0;
    public int nbPoolTotal = 0;
    public int nbExtractorTotal = 0;
    public int nbHydraTotal = 0;
    public int nbQueenNestTotal = 0;
    public int nbSpireTotal = 0;
    public int nbHiveTotal = 0;
    public int nbLairTotal = 0;
    public int nbGreatSpireTotal = 0;
    public int nbEvoChamberTotal = 0;
    int oldHatcheriesProduction = 0;
    int supplyUsed = 0;
    int supplyTotal = 0;
    int supplyFictive = 0;
    JNIBWAPI bwapi = JavaBot.bwapi;
    int iterDrones = Operators.iterDrones;
    int iterOverlords = Operators.iterOverlords;
    int iterZerglings = Operators.iterZerglings;
    int iterHydralisks = Operators.iterHydralisks;
    int iterQueens = Operators.iterQueens;
    int iterMutalisks = Operators.iterMutalisks;
    int iterGuardians = Operators.iterGuardians;
    int iterDevourers = Operators.iterDevourers;
    int iterHatchery = Operators.iterHatchery;
    int iterPool = Operators.iterPool;
    int iterExtractor = Operators.iterExtractor;
    int iterHydra = Operators.iterHydra;
    int iterLair = Operators.iterLair;
    int iterQueenNest = Operators.iterQueenNest;
    int iterSpire = Operators.iterSpire;
    int iterHive = Operators.iterHive;
    int iterGreatSpire = Operators.iterGreatSpire;
    int iterEvoChamber = Operators.iterEvolutionChamber;

    public void ratioGas() {
        this.needMoreGas = false;
        this.needMoreMinerals = false;
        if (JavaBot.knowledge.realMinerals < JavaBot.knowledge.realGas) {
            this.needMoreMinerals = true;
        } else if (this.nbHiveTotal == 0 && this.nbLairTotal == 0) {
            if ((double)this.mineralsPerMinute * 0.12 > (double)this.gasPerMinute) {
                this.needMoreGas = true;
            }
            if ((double)this.mineralsPerMinute * 0.27 < (double)this.gasPerMinute) {
                this.needMoreMinerals = true;
            }
        } else if (this.nbHiveTotal == 0) {
            if ((double)this.mineralsPerMinute * 0.2 > (double)this.gasPerMinute) {
                this.needMoreGas = true;
            }
            if ((double)this.mineralsPerMinute * 0.33 < (double)this.gasPerMinute) {
                this.needMoreMinerals = true;
            }
        } else {
            if ((double)this.mineralsPerMinute * 0.28 > (double)this.gasPerMinute) {
                this.needMoreGas = true;
            }
            if ((double)this.mineralsPerMinute * 0.41 < (double)this.gasPerMinute) {
                this.needMoreMinerals = true;
            }
        }
    }

    public void update(GlobalKnowledge knowledge) {
        this.nbDronesTotal = knowledge.currentUnits[this.iterDrones] + knowledge.warpingUnits[this.iterDrones];
        this.nbOverlordsTotal = knowledge.currentUnits[this.iterOverlords] + knowledge.warpingUnits[this.iterOverlords];
        this.nbZerglingsTotal = knowledge.currentUnits[this.iterZerglings] + 2 * knowledge.warpingUnits[this.iterZerglings];
        this.nbHydralisksTotal = knowledge.currentUnits[this.iterHydralisks] + knowledge.warpingUnits[this.iterHydralisks];
        this.nbQueensTotal = knowledge.currentUnits[this.iterQueens] + knowledge.warpingUnits[this.iterQueens];
        this.nbMutalisksTotal = knowledge.currentUnits[this.iterMutalisks] + knowledge.warpingUnits[this.iterMutalisks];
        this.nbGuardiansTotal = knowledge.currentUnits[this.iterGuardians] + knowledge.warpingUnits[this.iterGuardians];
        this.nbDevourersTotal = knowledge.currentUnits[this.iterDevourers] + knowledge.warpingUnits[this.iterDevourers];
        this.nbHatcheryTotal = knowledge.currentBuildings[this.iterHatchery] + knowledge.warpingBuildings[this.iterHatchery];
        this.nbPoolTotal = knowledge.currentBuildings[this.iterPool] + knowledge.warpingBuildings[this.iterPool];
        this.nbExtractorTotal = knowledge.currentBuildings[this.iterExtractor] + knowledge.warpingBuildings[this.iterExtractor];
        this.nbHydraTotal = knowledge.currentBuildings[this.iterHydra] + knowledge.warpingBuildings[this.iterHydra];
        this.nbQueenNestTotal = knowledge.currentBuildings[this.iterQueenNest] + knowledge.warpingBuildings[this.iterQueenNest];
        this.nbSpireTotal = knowledge.currentBuildings[this.iterSpire] + knowledge.warpingBuildings[this.iterSpire];
        this.nbHiveTotal = knowledge.currentBuildings[this.iterHive] + knowledge.warpingBuildings[this.iterHive];
        this.nbLairTotal = knowledge.currentBuildings[this.iterLair] + knowledge.warpingBuildings[this.iterLair];
        this.nbGreatSpireTotal = knowledge.currentBuildings[this.iterGreatSpire] + knowledge.warpingBuildings[this.iterGreatSpire];
        this.nbEvoChamberTotal = knowledge.currentBuildings[this.iterEvoChamber] + knowledge.warpingBuildings[this.iterEvoChamber];
        this.supplyUsed = knowledge.supplyUsed;
        this.supplyTotal = knowledge.supplyMax;
        this.supplyFictive = 1 * this.nbHatcheryTotal + 8 * this.nbOverlordsTotal;
        this.supplyFictive *= 2;
        this.createDronesAndOverlords(knowledge);
        this.techBuildings(knowledge);
        this.army(knowledge);
        this.expandAndMacro(knowledge);
    }

    public void createDronesAndOverlords(GlobalKnowledge knowledge) {
        if (this.nbPoolTotal > 0) {
            knowledge.requestedBuildings[this.iterPool] = 0;
            knowledge.requestedUnits[this.iterDrones] = this.nbDronesTotal < this.idealNbDrones && this.supplyUsed < this.supplyTotal - 1 ? 1 : 0;
            knowledge.requestedUnits[this.iterOverlords] = this.supplyFictive - this.supplyUsed <= this.supplyTotal / 4 ? 1 : 0;
        } else if (this.nbDronesTotal < 9) {
            if (this.supplyFictive <= this.supplyUsed) {
                knowledge.requestedUnits[this.iterDrones] = 0;
                knowledge.requestedUnits[this.iterOverlords] = 1;
            } else {
                knowledge.requestedUnits[this.iterDrones] = 1;
            }
        } else {
            knowledge.requestedUnits[this.iterDrones] = 0;
            if (this.nbPoolTotal == 0 && (this.nbHatcheryTotal >= 2 || JavaBot.currFrame >= 2500 || this.enemyRace == RaceType.Zerg)) {
                knowledge.requestedBuildings[this.iterPool] = 1;
            }
        }
        if (this.nbPoolTotal > 0) {
            knowledge.requestedBuildings[this.iterPool] = 0;
            knowledge.timerTryPool = 0;
        }
    }

    public void army(GlobalKnowledge knowledge) {
        if (this.supplyUsed > 9 && JavaBot.knowledge.requestedUnits[this.iterOverlords] == 0 && this.supplyUsed < this.supplyTotal - 1) {
            knowledge.requestedUnits[this.iterZerglings] = JavaBot.knowledge.currentBuildings[this.iterPool] >= 1 && this.nbZerglingsTotal < this.idealNbZerglings ? 1 : 0;
            knowledge.requestedUnits[this.iterHydralisks] = JavaBot.knowledge.currentBuildings[this.iterHydra] >= 1 && this.nbHydralisksTotal < this.idealNbHydras ? 1 : 0;
            knowledge.requestedUnits[this.iterQueens] = JavaBot.knowledge.currentBuildings[this.iterQueenNest] >= 1 && this.nbQueensTotal < this.idealNbQueens ? 1 : 0;
            knowledge.requestedUnits[this.iterMutalisks] = JavaBot.strategy.nbGreatSpireTotal >= 1 && this.nbGuardiansTotal + this.nbMutalisksTotal + this.nbDevourersTotal < this.idealNbGuardians + this.idealNbMutalisks + this.idealNbDevourers ? 1 : 0;
            knowledge.requestedUnits[this.iterGuardians] = JavaBot.knowledge.currentBuildings[this.iterGreatSpire] >= 1 && this.nbGuardiansTotal < this.idealNbGuardians ? 1 : 0;
            knowledge.requestedUnits[this.iterDevourers] = JavaBot.knowledge.currentBuildings[this.iterGreatSpire] >= 1 && this.nbDevourersTotal < this.idealNbDevourers ? 1 : 0;
        } else {
            knowledge.requestedUnits[this.iterZerglings] = 0;
            knowledge.requestedUnits[this.iterHydralisks] = 0;
            knowledge.requestedUnits[this.iterQueens] = 0;
            knowledge.requestedUnits[this.iterMutalisks] = 0;
        }
    }

    public void techBuildings(GlobalKnowledge knowledge) {
        knowledge.requestedBuildings[this.iterGreatSpire] = knowledge.currentBuildings[this.iterSpire] > 0 && knowledge.currentBuildings[this.iterHive] > 0 && this.nbGreatSpireTotal == 0 ? 1 : 0;
        knowledge.requestedBuildings[this.iterEvoChamber] = this.nbGreatSpireTotal > 0 && this.nbEvoChamberTotal == 0 ? 1 : 0;
    }

    public void expandAndMacro(GlobalKnowledge knowledge) {
        if (this.nbDronesTotal >= 8) {
            knowledge.requestedBuildings[this.iterHatchery] = knowledge.timerTryExpand == 0 ? 1 : 0;
            knowledge.requestMacro = knowledge.realMinerals >= 700 && knowledge.timerTryMacro == 0;
            if (knowledge.warpingBuildings[this.iterHatchery] > this.oldHatcheriesProduction) {
                if (knowledge.timerTryExpand > 0) {
                    JavaBot.knowledge.timerTryExpand = 200;
                    if (this.bwapi.getFrameCount() < 15000) {
                        JavaBot.knowledge.timerTryExpand = 600;
                    }
                    if (this.bwapi.getFrameCount() < 1000) {
                        JavaBot.knowledge.timerTryExpand = 1600;
                    }
                    if (this.bwapi.getFrameCount() < 3000) {
                        JavaBot.knowledge.timerTryExpand = 2100;
                    }
                }
                knowledge.timerTryMacro = 0;
            }
            this.oldHatcheriesProduction = knowledge.warpingBuildings[this.iterHatchery];
        }
    }

    public void adaptArmyComposition() {
        this.idealNbHydras = 34;
        this.idealNbQueens = 31;
        this.idealNbZerglings = 32;
        this.idealNbMutalisks = 5;
        this.idealNbGuardians = 6;
        this.idealNbDevourers = 3;
        this.idealNbDrones = 60;
        switch (this.enemyRace) {
            case Terran: {
                this.idealNbHydras = 26;
                this.idealNbQueens = 35;
                this.idealNbZerglings = 24;
                this.idealNbMutalisks = 4;
                this.idealNbGuardians = 8;
                this.idealNbDevourers = 4;
                this.idealNbDrones = 60;
                break;
            }
            case Zerg: {
                this.idealNbHydras = 19;
                this.idealNbQueens = 8;
                this.idealNbZerglings = 42;
                this.idealNbMutalisks = 24;
                this.idealNbGuardians = 3;
                this.idealNbDevourers = 15;
                this.idealNbDrones = 60;
                break;
            }
            case Protoss: {
                this.idealNbHydras = 27;
                this.idealNbQueens = 35;
                this.idealNbZerglings = 18;
                this.idealNbMutalisks = 12;
                this.idealNbGuardians = 3;
                this.idealNbDevourers = 2;
                this.idealNbDrones = 60;
            }
        }
    }

    public void build(GlobalKnowledge knowledge) {
    }

    public void tech(GlobalKnowledge knowledge) {
    }

    public boolean nothingToBuild() {
        return this.nbGreatSpireTotal > 0 && this.nbPoolTotal > 0 && this.nbQueenNestTotal > 0 && this.nbHydraTotal > 0 && this.nbHiveTotal > 0 && this.nbEvoChamberTotal > 0;
    }

    public boolean nothingToArmy() {
        return this.nbZerglingsTotal >= this.idealNbZerglings && this.nbHydralisksTotal >= this.idealNbHydras && this.nbQueensTotal >= this.idealNbQueens && this.nbGuardiansTotal >= this.idealNbGuardians && this.nbDevourersTotal >= this.idealNbDevourers;
    }

    public void debug() {
        int x = 320;
        int y = 5;
        this.bwapi.drawText(new Point(x, y), "Z = " + this.idealPopZerglings, true);
        this.bwapi.drawText(new Point(x, y += 10), "H = " + this.idealPopHydras, true);
        this.bwapi.drawText(new Point(x, y += 10), "Q = " + this.idealPopQueens, true);
        this.bwapi.drawText(new Point(x, y += 10), "M = " + this.idealPopMutalisks, true);
        this.bwapi.drawText(new Point(x, y += 10), "G = " + this.idealPopGuardians, true);
        this.bwapi.drawText(new Point(x, y += 10), "D = " + this.idealPopDevourers, true);
        this.bwapi.drawText(new Point(x, y += 12), "Total = " + (this.idealPopZerglings + this.idealPopHydras + this.idealPopQueens + this.idealPopMutalisks + this.idealPopGuardians + this.idealPopDevourers), true);
        this.bwapi.drawText(new Point(x, y += 13), "Reset = " + JavaBot.armyComposition.coefficient, true);
        this.bwapi.drawText(new Point(x, y += 11), "M/m = " + this.mineralsPerMinute + " " + this.needMoreMinerals, true);
        this.bwapi.drawText(new Point(x, y += 10), "G/m = " + this.gasPerMinute + " " + this.needMoreGas, true);
    }

    public static enum RaceType {
        Terran,
        Zerg,
        Protoss;

    }
}

