/*
 * Decompiled with CFR 0.152.
 */
package javabot.knowledge;

import javabot.JNIBWAPI;
import javabot.JavaBot;
import javabot.knowledge.Strategy;
import javabot.model.Player;

public class Repartition {
    public JNIBWAPI bwapi = JavaBot.bwapi;
    public Player self;
    public Strategy strategy = JavaBot.strategy;
    public int dronesMinerals = 0;
    public int expandMinerals = 300;
    public int unitsMinerals = 0;
    public int techMinerals = 0;
    public int unitsGas = 0;
    public int techGas = 0;

    public Repartition() {
        this.self = this.bwapi.getSelf();
    }

    public void update() {
        int sumStocksGas;
        int playerGas;
        int sumStocks;
        int playerminerals = this.self.getMinerals();
        if (playerminerals > (sumStocks = this.dronesMinerals + this.expandMinerals + this.unitsMinerals + this.techMinerals)) {
            this.repartition(playerminerals - sumStocks);
        }
        if (playerminerals < sumStocks) {
            if (Math.random() < 0.25 && this.techMinerals > 0) {
                --this.techMinerals;
            } else if (Math.random() < 0.4 && this.unitsMinerals > 0) {
                --this.unitsMinerals;
            } else if (Math.random() < 0.3 && this.expandMinerals > 0) {
                --this.expandMinerals;
            } else if (this.dronesMinerals > 0) {
                --this.dronesMinerals;
            }
        }
        if ((playerGas = this.self.getGas()) > (sumStocksGas = this.unitsGas + this.techGas)) {
            this.repartitionGas(playerGas - sumStocksGas);
        }
        if (playerGas < sumStocksGas) {
            if (Math.random() < 0.5 && this.unitsGas > 0) {
                --this.unitsGas;
            } else if (this.techGas > 0) {
                --this.techGas;
            }
        }
    }

    private void repartitionGas(int gas) {
        int additionnalTech;
        float totalCoef;
        float unitsCoef = 0.0f;
        float techCoef = 0.0f;
        techCoef = this.techGas >= 300 ? 0.0f : 4.0f;
        unitsCoef = this.strategy.nothingToArmy() || this.strategy.nbHydraTotal == 0 && this.strategy.nbQueenNestTotal == 0 && this.strategy.nbGreatSpireTotal == 0 ? 0.0f : 4.0f;
        int additionnalUnits = (int)(unitsCoef / (totalCoef = unitsCoef + techCoef) * (float)gas);
        int totalAdd = additionnalUnits + (additionnalTech = (int)(techCoef / totalCoef * (float)gas));
        if (totalAdd < gas) {
            additionnalTech += gas - totalAdd;
        }
        this.unitsGas += additionnalUnits;
        this.techGas += additionnalTech;
    }

    private void repartition(int minerals) {
        float dronesCoef = 0.0f;
        float expandCoef = 0.0f;
        float unitsCoef = 0.0f;
        float techCoef = 0.0f;
        if (this.dronesMinerals >= 100 || this.strategy.nbDronesTotal >= this.strategy.idealNbDrones) {
            dronesCoef = 0.0f;
        } else if (this.strategy.nbDronesTotal < 9) {
            dronesCoef = 8.0f;
        } else if ((double)this.strategy.nbDronesTotal < (double)this.strategy.idealNbDrones * 0.25) {
            dronesCoef = 7.0f;
        } else if ((double)this.strategy.nbDronesTotal < (double)this.strategy.idealNbDrones * 0.5) {
            dronesCoef = 5.0f;
        } else if ((double)this.strategy.nbDronesTotal < (double)this.strategy.idealNbDrones * 0.75) {
            dronesCoef = 3.0f;
        }
        expandCoef = this.strategy.nbDronesTotal < 9 || this.expandMinerals >= 300 ? 0.0f : (this.strategy.nbHatcheryTotal <= 2 ? 8.0f : (this.strategy.nbHatcheryTotal <= 6 ? 6.0f : (this.strategy.nbHatcheryTotal <= 10 ? 4.0f : 2.0f)));
        techCoef = this.strategy.nbDronesTotal < 9 || this.techMinerals >= 200 || this.strategy.nothingToBuild() ? 0.0f : 4.0f;
        unitsCoef = this.strategy.nothingToArmy() || this.strategy.nbPoolTotal == 0 && this.strategy.nbHydraTotal == 0 && this.strategy.nbQueenNestTotal == 0 && this.strategy.nbGreatSpireTotal == 0 ? 0.0f : ((double)(this.strategy.nbHydralisksTotal + this.strategy.nbZerglingsTotal) < (double)(this.strategy.idealNbZerglings + this.strategy.idealNbHydras) * 0.25 ? 3.0f : 2.0f);
        float totalCoef = dronesCoef + expandCoef + unitsCoef + techCoef;
        int additionnalDrones = (int)(dronesCoef / totalCoef * (float)minerals);
        int additionnalExpands = (int)(expandCoef / totalCoef * (float)minerals);
        int additionnalUnits = (int)(unitsCoef / totalCoef * (float)minerals);
        int additionnalTech = (int)(techCoef / totalCoef * (float)minerals);
        int totalAdd = additionnalDrones + additionnalExpands + additionnalUnits + additionnalTech;
        if (totalAdd < minerals) {
            if (JavaBot.strategy.nbPoolTotal > 0) {
                additionnalUnits += minerals - totalAdd;
            } else {
                additionnalTech += minerals - totalAdd;
            }
        }
        this.dronesMinerals += additionnalDrones;
        this.expandMinerals += additionnalExpands;
        this.unitsMinerals += additionnalUnits;
        this.techMinerals += additionnalTech;
    }

    public void reduceExpandMinerals(int amount) {
        this.expandMinerals -= amount;
        if (this.expandMinerals < 0) {
            this.expandMinerals = 0;
        }
    }

    public void reduceTechMinerals(int amount) {
        this.techMinerals -= amount;
        if (this.techMinerals < 0) {
            this.techMinerals = 0;
        }
    }

    public void reduceCreepMinerals(int amount) {
        this.unitsMinerals -= amount / 2;
        this.dronesMinerals -= amount / 2;
        if (this.unitsMinerals < 0) {
            this.unitsMinerals = 0;
        }
        if (this.dronesMinerals < 0) {
            this.dronesMinerals = 0;
        }
    }

    public void reduceSunkenMinerals(int amount) {
        this.unitsMinerals -= amount / 2;
        this.dronesMinerals -= amount / 2;
        if (this.unitsMinerals < 0) {
            this.unitsMinerals = 0;
        }
        if (this.dronesMinerals < 0) {
            this.dronesMinerals = 0;
        }
    }

    public int getTechMinerals() {
        return this.techMinerals;
    }

    public int getExpandMinerals() {
        return this.expandMinerals;
    }

    public int getUnitsMinerals() {
        return this.unitsMinerals;
    }

    public int getPoolMinerals() {
        return JavaBot.knowledge.realMinerals;
    }

    public int getExtractMinerals() {
        return JavaBot.knowledge.realMinerals;
    }

    public int getHydraDenMinerals() {
        return JavaBot.knowledge.realMinerals;
    }

    public int getQueenNestMinerals() {
        return JavaBot.knowledge.realMinerals;
    }

    public int getSpireMinerals() {
        return JavaBot.knowledge.realMinerals;
    }

    public int getEvoMinerals() {
        return JavaBot.knowledge.realMinerals;
    }

    public int getCreepMinerals() {
        return this.expandMinerals + this.techMinerals;
    }

    public void debug() {
        this.bwapi.drawText(220, 35, "dr", true);
        this.bwapi.drawText(220, 45, "ex", true);
        this.bwapi.drawText(220, 55, "un", true);
        this.bwapi.drawText(220, 65, "tc", true);
        this.bwapi.drawText(220, 75, "total", true);
        this.bwapi.drawText(239, 35, "" + this.dronesMinerals, true);
        this.bwapi.drawText(239, 45, "" + this.expandMinerals, true);
        this.bwapi.drawText(239, 55, "" + this.unitsMinerals, true);
        this.bwapi.drawText(239, 65, "" + this.techMinerals, true);
        this.bwapi.drawText(249, 75, "" + (this.dronesMinerals + this.expandMinerals + this.unitsMinerals + this.techMinerals), true);
        this.bwapi.drawText(269, 55, "" + this.unitsGas, true);
        this.bwapi.drawText(269, 65, "" + this.techGas, true);
    }

    public void reduceCombatUnits(int amount, int gas) {
        this.unitsMinerals -= amount;
        if (this.unitsMinerals < 0) {
            this.unitsMinerals = 0;
        }
        this.unitsGas -= gas;
        if (this.unitsGas < 0) {
            this.unitsGas = 0;
        }
    }
}

