/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.unitgroups;

import bwapi.Color;
import bwapi.Game;
import bwapi.Player;
import bwapi.Position;
import bwapi.UnitType;
import com.tyr.BWTAProxy;
import com.tyr.DebugMessages;
import com.tyr.Settings;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.buildingplacement.DefensiveStructures;
import com.tyr.buildingplacement.SpaceManager;
import com.tyr.unitgroups.OutOfJob;
import com.tyr.unitgroups.UnitGroup;

public class StayAtHomeGroup
extends UnitGroup {
    public Position target = null;
    private DefensiveStructures defenses = null;
    public static boolean keepTanksSieged = false;
    private Position natural;
    public static boolean defendAtNatural;

    public StayAtHomeGroup(OutOfJob rejects) {
        super(rejects);
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        DebugMessages.addMessage("HomeGroup size: " + this.units.size());
        if (bot.defensiveStructures.size() > 0) {
            this.defenses = bot.defensiveStructures.get(0);
        }
        if (bot.defensiveStructures.size() > 1) {
            if (this.natural == null) {
                this.natural = SpaceManager.getNatural();
            }
            for (DefensiveStructures structures : bot.defensiveStructures) {
                if (!(structures.defendedPosition.getDistance(this.natural) < 100.0)) continue;
                this.defenses = structures;
                break;
            }
        }
        if (defendAtNatural && BWTAProxy.initialized) {
            if (this.natural == null) {
                this.natural = SpaceManager.getNatural();
            }
            this.target = SpaceManager.getDefensePos(this.natural);
        } else if (Settings.getRallyPoint() != null) {
            this.target = Settings.getRallyPoint();
        } else if (this.defenses != null && this.defenses.defences.size() > 0 && this.defenses.defences.get(0).getPosition() != null) {
            this.target = this.defenses.defences.get(0).getPosition();
        } else if (BWTAProxy.initialized && this.defenses != null) {
            this.target = this.defenses.getDefensePos();
        }
        if (this.target != null) {
            Tyr.drawCircle(this.target, Color.Green, 128);
            for (Agent agent : this.units) {
                if (agent.unit.getType() == UnitType.Terran_Siege_Tank_Tank_Mode) {
                    if (keepTanksSieged && agent.distanceSquared(this.target) <= 16384) {
                        agent.unit.siege();
                    } else {
                        agent.drawCircle(Color.Yellow, 4);
                    }
                } else if (agent.unit.getType() == UnitType.Terran_Siege_Tank_Siege_Mode) {
                    if (!keepTanksSieged || agent.distanceSquared(this.target) > 16384) {
                        agent.unit.unsiege();
                    }
                } else if (agent.unit.isIdle() && agent.distanceSquared(this.target) > 16384) {
                    agent.unit.move(this.target);
                }
                agent.drawCircle(Color.Grey);
            }
        }
    }

    @Override
    public void add(Agent agent) {
        if (this.target != null) {
            agent.unit.move(this.target);
        }
        super.add(agent);
    }

    public Agent pop(UnitType type) {
        int i = this.units.size() - 1;
        while (i >= 0) {
            Agent agent = (Agent)this.units.get(i);
            if (agent.unit.getType() == type) {
                this.units.remove(i);
                return agent;
            }
            --i;
        }
        return null;
    }

    public void addTanks(UnitGroup tanks, int amount) {
        int i = this.units.size() - 1;
        while (i >= 0 && amount > 0) {
            Agent agent = (Agent)this.units.get(i);
            if (agent.unit.getType() == UnitType.Terran_Siege_Tank_Siege_Mode || agent.unit.getType() == UnitType.Terran_Siege_Tank_Tank_Mode) {
                tanks.add(agent);
                this.units.remove(i);
                --amount;
            }
            --i;
        }
    }

    @Override
    public int takeAgent(Agent agent) {
        if (agent.unit.getType() == UnitType.Terran_Medic || agent.unit.getType() == UnitType.Terran_Science_Vessel || agent.unit.getType() == UnitType.Terran_Dropship) {
            return 1;
        }
        if (agent.unit.getType().canAttack() && !agent.unit.getType().isWorker() && !agent.unit.getType().isBuilding() && agent.unit.isCompleted() && agent.unit.getType() != UnitType.Terran_Vulture_Spider_Mine) {
            return 1;
        }
        return -1;
    }

    public Position getTarget() {
        return this.target;
    }
}

