/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.unitgroups;

import bwapi.Game;
import bwapi.Player;
import bwapi.TechType;
import bwapi.Unit;
import bwapi.UnitType;
import bwapi.UpgradeType;
import com.tyr.Settings;
import com.tyr.Tyr;
import com.tyr.UnitTracker;
import com.tyr.agents.Agent;
import com.tyr.unitgroups.OutOfJob;
import com.tyr.unitgroups.ScoutGroup;
import com.tyr.unitgroups.UnitGroup;
import java.util.List;

public class ProductionStructures
extends UnitGroup {
    public ProductionStructures(OutOfJob rejects) {
        super(rejects);
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        for (Agent myUnit : this.units) {
            if (bot.build.overrideStructureOrder(game, self, bot, myUnit)) continue;
            if (myUnit.unit.getType() == UnitType.Terran_Engineering_Bay && !myUnit.unit.isUpgrading()) {
                if (bot.getAvailableMinerals() >= UpgradeType.Terran_Infantry_Weapons.mineralPrice() && bot.getAvailableGas() >= UpgradeType.Terran_Infantry_Weapons.gasPrice()) {
                    myUnit.unit.upgrade(UpgradeType.Terran_Infantry_Weapons);
                }
                if (bot.getAvailableMinerals() >= UpgradeType.Terran_Infantry_Armor.mineralPrice() && bot.getAvailableGas() >= UpgradeType.Terran_Infantry_Armor.gasPrice()) {
                    myUnit.unit.upgrade(UpgradeType.Terran_Infantry_Armor);
                }
            }
            if (myUnit.unit.getType() == UnitType.Terran_Machine_Shop && !myUnit.unit.isResearching() && bot.getAvailableMinerals() >= 150 && bot.getAvailableGas() >= 150) {
                myUnit.unit.research(TechType.Tank_Siege_Mode);
            }
            if (myUnit.unit.getType() == UnitType.Terran_Factory && !myUnit.unit.isTraining()) {
                if (myUnit.unit.getAddon() == null && bot.getAvailableMinerals() >= 50 && bot.getAvailableGas() >= 50) {
                    myUnit.unit.buildAddon(UnitType.Terran_Machine_Shop);
                    UnitTracker.addAddOn(UnitType.Terran_Machine_Shop);
                } else if (!myUnit.unit.isTraining() && bot.getAvailableMinerals() >= 150 && bot.getAvailableGas() >= 100 && (UnitTracker.count(UnitType.Terran_Siege_Tank_Tank_Mode) == 0 || self.hasResearched(TechType.Tank_Siege_Mode) || self.isResearching(TechType.Tank_Siege_Mode) || bot.getAvailableGas() >= 250)) {
                    myUnit.unit.train(UnitType.Terran_Siege_Tank_Tank_Mode);
                }
            }
            if (myUnit.unit.getType() == UnitType.Terran_Command_Center && !myUnit.unit.isTraining()) {
                if (UnitTracker.count(UnitType.Terran_Academy) == 1 && bot.getAvailableMinerals() >= 50 && bot.getAvailableGas() >= 50) {
                    myUnit.unit.buildAddon(UnitType.Terran_Comsat_Station);
                }
                if (bot.getAvailableMinerals() >= 50 && bot.workForce.units.size() + bot.builders.units.size() < Settings.getMaximumWorkers() && (self.supplyTotal() + UnitTracker.getSupplyConstructing() - self.supplyUsed() > UnitTracker.count(UnitType.Terran_Barracks) * 3 + UnitTracker.getCcCount() * 3 || bot.getAvailableMinerals() >= 150)) {
                    myUnit.unit.train(UnitType.Terran_SCV);
                }
            }
            if (!(myUnit.unit.getType() != UnitType.Terran_Barracks || bot.scout.opponentStrategy == ScoutGroup.cannons && bot.getAvailableMinerals() < 300 || myUnit.unit.isTraining() || bot.getAvailableMinerals() < 50 || self.supplyTotal() + UnitTracker.getSupplyConstructing() - self.supplyUsed() <= UnitTracker.count(UnitType.Terran_Barracks) * 3 + UnitTracker.getCcCount() * 3 && bot.getAvailableMinerals() < 150)) {
                myUnit.unit.train(UnitType.Terran_Marine);
            }
            if (myUnit.unit.getType() == UnitType.Terran_Starport && !myUnit.unit.isTraining() && bot.getAvailableMinerals() >= 150 && bot.getAvailableGas() >= 100) {
                myUnit.unit.train(UnitType.Terran_Wraith);
            }
            if (myUnit.unit.getType() == UnitType.Zerg_Hatchery || myUnit.unit.getType() == UnitType.Zerg_Hive || myUnit.unit.getType() == UnitType.Zerg_Lair) {
                List<Unit> larvas = myUnit.unit.getLarva();
                for (Unit larva : larvas) {
                    if (self.supplyTotal() + UnitTracker.getSupplyConstructing() - self.supplyUsed() <= UnitTracker.getCcCount() * 3 && bot.getAvailableMinerals() >= 100 && self.supplyTotal() + UnitTracker.getSupplyConstructing() < 400) {
                        larva.train(UnitType.Zerg_Overlord);
                        System.out.println("Overlord in training.");
                        continue;
                    }
                    if (bot.getAvailableMinerals() >= 50 && bot.workForce.units.size() >= 12 && UnitTracker.count(UnitType.Zerg_Spawning_Pool) > 0) {
                        larva.train(UnitType.Zerg_Zergling);
                        System.out.println("Zerglings in training.");
                        continue;
                    }
                    if (bot.getAvailableMinerals() >= 50 && bot.workForce.units.size() < Settings.getMaximumWorkers()) {
                        larva.train(UnitType.Zerg_Drone);
                        System.out.println("Drone in training.");
                        continue;
                    }
                    System.out.println("Minerals: " + bot.getAvailableMinerals());
                    System.out.println("Supply: " + self.supplyUsed());
                }
            }
            if (myUnit.unit.getType() == UnitType.Protoss_Nexus && !myUnit.unit.isTraining() && bot.getAvailableMinerals() >= 50 && bot.workForce.units.size() < Settings.getMaximumWorkers()) {
                myUnit.unit.train(UnitType.Protoss_Probe);
            }
            if (myUnit.unit.getType() != UnitType.Protoss_Gateway || myUnit.unit.isTraining()) continue;
            if (UnitTracker.count(UnitType.Protoss_Cybernetics_Core) >= 1 && bot.getAvailableMinerals() >= 125 && bot.getAvailableGas() >= 50 && UnitTracker.count(UnitType.Protoss_Dragoon) <= UnitTracker.count(UnitType.Protoss_Zealot)) {
                myUnit.unit.train(UnitType.Protoss_Dragoon);
                continue;
            }
            if (bot.getAvailableMinerals() < 100 || UnitTracker.count(UnitType.Protoss_Dragoon) < UnitTracker.count(UnitType.Protoss_Zealot) && bot.getAvailableMinerals() < 150) continue;
            myUnit.unit.train(UnitType.Protoss_Zealot);
        }
    }

    @Override
    public int takeAgent(Agent agent) {
        if ((agent.unit.getType().canProduce() || agent.unit.getType() == UnitType.Terran_Engineering_Bay || agent.unit.getType() == UnitType.Terran_Machine_Shop || agent.unit.getType() == UnitType.Terran_Science_Facility || agent.unit.getType() == UnitType.Terran_Physics_Lab || agent.unit.getType() == UnitType.Terran_Armory || agent.unit.getType() == UnitType.Terran_Academy || agent.unit.getType() == UnitType.Terran_Control_Tower) && agent.unit.isCompleted()) {
            return 1;
        }
        return -1;
    }
}

