/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.unitgroups;

import bwapi.Color;
import bwapi.Game;
import bwapi.Player;
import bwapi.Position;
import bwapi.Unit;
import bwapi.UnitType;
import bwapi.WeaponType;
import com.tyr.DebugMessages;
import com.tyr.EnemyManager;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.agents.None;
import com.tyr.unitgroups.UnitGroup;
import java.util.ArrayList;
import java.util.List;

public class MarineHarassGroup
extends UnitGroup {
    private Position target;
    private boolean retreat = true;
    private Unit killEnemy;
    public static UnitType[] retreatTypes = new UnitType[]{UnitType.Terran_Bunker, UnitType.Protoss_Photon_Cannon, UnitType.Zerg_Sunken_Colony};

    public MarineHarassGroup(Position target) {
        super(Tyr.bot.hobos);
        this.target = target;
    }

    public MarineHarassGroup(Position target, boolean retreat) {
        super(Tyr.bot.hobos);
        this.target = target;
        this.retreat = false;
    }

    public void setTarget(Position target) {
        this.target = target;
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        boolean defended = false;
        if (!(this.killEnemy == null || this.killEnemy.getHitPoints() > 0 && this.killEnemy.getRemoveTimer() == 0 && this.killEnemy.exists() && this.killEnemy.getPlayer() != game.self())) {
            this.killEnemy = null;
        }
        if (this.killEnemy != null) {
            boolean inRange = false;
            if (this.target != null && this.killEnemy.getType().isWorker() && this.killEnemy.getDistance(this.target) <= 352) {
                inRange = true;
            } else {
                for (Agent agent : this.units) {
                    int range = 200;
                    if (agent.distanceSquared(this.killEnemy) > range * range) continue;
                    inRange = true;
                    break;
                }
            }
            if (!inRange) {
                this.killEnemy = null;
            }
        }
        double distanceSq = 2.147483647E9;
        int prio = 100;
        if (this.killEnemy == null || this.killEnemy.getType().isWorker() || this.killEnemy.getType().isBuilding() || this.killEnemy.getType() == UnitType.Zerg_Overlord) {
            for (Agent agent : this.units) {
                int rangeSq = 90000;
                agent.drawCircle(Color.Purple, 300);
                for (Unit unit : EnemyManager.getEnemyUnits()) {
                    UnitType[] unitTypeArray = retreatTypes;
                    int n = retreatTypes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        UnitType type = unitTypeArray[n2];
                        if (unit.getType() == type) {
                            defended = true;
                            break;
                        }
                        ++n2;
                    }
                    if (defended) break;
                    int newPrio = 100;
                    if (unit.getType() == UnitType.Protoss_Observer || unit.isMorphing() || unit.getType() == UnitType.Zerg_Larva) continue;
                    double dist = agent.distanceSquared(unit);
                    newPrio = unit.getType().isBuilding() ? (unit.getType().groundWeapon().maxRange() == 0 ? 10 : 8) : (unit.getType().isFlyer() && unit.getType().groundWeapon() == WeaponType.None ? 9 : (unit.getType().isWorker() ? 7 : (dist <= 40000.0 ? 6 : 101)));
                    if (newPrio > prio || dist > (double)rangeSq) continue;
                    Tyr.drawCircle(unit.getPosition(), Color.Purple);
                    if (newPrio >= prio && !(dist < distanceSq)) continue;
                    prio = newPrio;
                    distanceSq = dist;
                    this.killEnemy = unit;
                }
                if (!defended) {
                    continue;
                }
                break;
            }
        } else {
            DebugMessages.addMessage("Already have a target.");
        }
        if (defended) {
            for (Agent agent : this.units) {
                agent.order(new None(agent));
                this.rejects.add(agent);
            }
            this.units = new ArrayList();
            return;
        }
        if (this.killEnemy == null && this.target != null) {
            List<Unit> workerTargets = game.getUnitsInRadius(this.target, 352);
            for (Unit unit : workerTargets) {
                if (!unit.getType().isWorker() || !unit.getPlayer().isEnemy(self)) continue;
                for (Agent agent : this.units) {
                    double dist = agent.distanceSquared(unit);
                    if (!unit.getPlayer().isEnemy(self) || !(dist < distanceSq)) continue;
                    distanceSq = dist;
                    this.killEnemy = unit;
                }
            }
        }
        if (this.killEnemy != null) {
            for (Agent agent : this.units) {
                game.drawLineMap(agent.unit.getX(), agent.unit.getY(), this.killEnemy.getX(), this.killEnemy.getY(), Color.Red);
                if (agent.unit.getGroundWeaponCooldown() > 1 && this.retreat) {
                    agent.unit.move(Tyr.tileToPosition(self.getStartLocation()));
                    continue;
                }
                if (agent.unit.isStartingAttack() || agent.unit.isAttackFrame() || agent.unit.isAttacking() || !agent.unit.isIdle() && !agent.unit.isMoving()) continue;
                agent.attack(this.killEnemy);
            }
            return;
        }
        if (this.target != null) {
            for (Agent agent : this.units) {
                agent.unit.move(this.target);
                game.drawLineMap(agent.unit.getX(), agent.unit.getY(), this.target.getX(), this.target.getY(), Color.Blue);
            }
        }
    }

    @Override
    public void add(Agent agent) {
        super.add(agent);
        agent.order(new None(agent));
        agent.unit.stop();
    }

    public void clear() {
        int i = this.units.size() - 1;
        while (i >= 0) {
            this.rejects.add((Agent)this.units.get(i));
            this.units.remove(i);
            --i;
        }
    }
}

