/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.unitgroups;

import bwapi.Color;
import bwapi.Game;
import bwapi.Player;
import bwapi.Position;
import bwapi.Unit;
import bwapi.UnitType;
import bwapi.WeaponType;
import com.tyr.DebugMessages;
import com.tyr.EnemyManager;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.agents.None;
import com.tyr.unitgroups.UnitGroup;
import java.util.List;

public class HarassBaseGroup
extends UnitGroup {
    private Position target;
    private boolean retreat = true;
    private Unit killEnemy;

    public HarassBaseGroup(Position target) {
        super(Tyr.bot.hobos);
        this.target = target;
    }

    public HarassBaseGroup(Position target, boolean retreat) {
        super(Tyr.bot.hobos);
        this.target = target;
        this.retreat = false;
    }

    public void setTarget(Position target) {
        this.target = target;
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        double dist;
        if (!(this.killEnemy == null || this.killEnemy.getHitPoints() > 0 && this.killEnemy.getRemoveTimer() == 0 && this.killEnemy.exists() && this.killEnemy.getPlayer() != game.self())) {
            this.killEnemy = null;
        }
        if (this.killEnemy != null) {
            boolean inRange = false;
            if (this.target != null && this.killEnemy.getType().isWorker() && this.killEnemy.getDistance(this.target) <= 352) {
                inRange = true;
            } else {
                for (Agent agent : this.units) {
                    int range = 0;
                    if (this.killEnemy.getType().isFlyer() && agent.unit.getType().airWeapon() != WeaponType.None) {
                        range = agent.unit.getType().airWeapon().maxRange();
                    }
                    if (!this.killEnemy.getType().isFlyer() && agent.unit.getType().groundWeapon() != WeaponType.None) {
                        range = agent.unit.getType().groundWeapon().maxRange();
                    }
                    if (agent.distanceSquared(this.killEnemy) > range * range) continue;
                    inRange = true;
                    break;
                }
            }
            if (!inRange) {
                this.killEnemy = null;
            }
        }
        double distanceSq = 2.147483647E9;
        if (this.killEnemy == null || this.killEnemy.getType().isWorker()) {
            for (Agent agent : this.units) {
                int rangeSq = agent.unit.getType().groundWeapon().maxRange() * agent.unit.getType().groundWeapon().maxRange();
                agent.drawCircle(Color.Purple, agent.unit.getType().groundWeapon().maxRange());
                for (Unit unit : EnemyManager.getEnemyUnits()) {
                    if (unit.getType().isBuilding() && unit.getType().groundWeapon().maxRange() == 0 || unit.getType().isFlyer() && agent.unit.getType().airWeapon() == WeaponType.None || unit.getType() == UnitType.Protoss_Observer || (dist = (double)agent.distanceSquared(unit)) > (double)rangeSq) continue;
                    Tyr.drawCircle(unit.getPosition(), Color.Purple);
                    if (!(dist < distanceSq)) continue;
                    distanceSq = dist;
                    this.killEnemy = unit;
                }
            }
        } else {
            DebugMessages.addMessage("Already have a target.");
        }
        if (this.killEnemy == null && this.target != null) {
            List<Unit> workerTargets = game.getUnitsInRadius(this.target, 352);
            for (Unit unit : workerTargets) {
                if (!unit.getType().isWorker() || !unit.getPlayer().isEnemy(self)) continue;
                for (Agent agent : this.units) {
                    dist = agent.distanceSquared(unit);
                    if (!unit.getPlayer().isEnemy(self) || !(dist < distanceSq)) continue;
                    distanceSq = dist;
                    this.killEnemy = unit;
                }
            }
        }
        if (this.killEnemy != null) {
            for (Agent agent : this.units) {
                game.drawLineMap(agent.unit.getX(), agent.unit.getY(), this.killEnemy.getX(), this.killEnemy.getY(), Color.Red);
                if (agent.unit.getGroundWeaponCooldown() > 1 && this.retreat) {
                    agent.unit.move(Tyr.tileToPosition(self.getStartLocation()));
                    continue;
                }
                if (agent.unit.isStartingAttack() || agent.unit.isAttackFrame() || agent.unit.isAttacking()) continue;
                agent.unit.attack(this.killEnemy);
            }
            return;
        }
        if (this.target != null) {
            for (Agent agent : this.units) {
                agent.unit.move(this.target);
                game.drawLineMap(agent.unit.getX(), agent.unit.getY(), this.target.getX(), this.target.getY(), Color.Blue);
            }
        }
    }

    @Override
    public void add(Agent agent) {
        super.add(agent);
        agent.order(new None(agent));
        agent.unit.stop();
    }

    public void clear() {
        int i = this.units.size();
        while (i >= 0) {
            this.rejects.add((Agent)this.units.get(i));
            this.units.remove(i);
            --i;
        }
    }
}

