/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.unitgroups;

import bwapi.Game;
import bwapi.Player;
import bwapi.Unit;
import bwapi.UnitType;
import com.tyr.EnemyManager;
import com.tyr.EnemyPosition;
import com.tyr.Settings;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.unitgroups.OutOfJob;
import com.tyr.unitgroups.UnitGroup;
import java.util.ArrayList;

public class DefendingWorkers
extends UnitGroup {
    private boolean proxyCannon = false;

    public DefendingWorkers(OutOfJob rejects) {
        super(rejects);
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        Unit invader = EnemyManager.getManager().getInvader();
        int invaderCount = EnemyManager.getManager().getInvaderCount();
        boolean proxy = false;
        for (EnemyPosition building : EnemyManager.getManager().enemyBuildingMemory) {
            if (building.distanceSq(Tyr.tileToPosition(self.getStartLocation())) > Settings.getLargeInvasionDist() * Settings.getLargeInvasionDist()) continue;
            proxy = true;
            if (building.type != UnitType.Protoss_Photon_Cannon || !building.completed) continue;
            this.proxyCannon = true;
            break;
        }
        if (invader == null || invader.getDistance(self.getStartLocation().getX() * 32, self.getStartLocation().getY() * 32) >= 480.0 || this.proxyCannon) {
            for (Agent agent : this.units) {
                this.rejects.add(agent);
            }
            if (this.units.size() != 0) {
                this.units = new ArrayList();
            }
            return;
        }
        if (invader.getDistance(self.getStartLocation().getX() * 32, self.getStartLocation().getY() * 32) >= 480.0) {
            return;
        }
        int desiredDefenders = 0;
        int halfWorkers = (this.units.size() + bot.workForce.units.size()) / 2;
        desiredDefenders = invaderCount == 1 && !invader.getType().isFlyer() && !proxy ? (invader.getType().isWorker() ? Math.min(1, halfWorkers) : Math.min(3, halfWorkers)) : (invaderCount == 2 && !proxy ? Math.min(5, halfWorkers) : halfWorkers);
        while (this.units.size() < desiredDefenders) {
            this.units.add(bot.workForce.pop(invader.getPosition()));
        }
        while (this.units.size() > desiredDefenders) {
            this.rejects.add((Agent)this.units.get(this.units.size() - 1));
            this.units.remove(this.units.size() - 1);
        }
        for (Agent worker : this.units) {
            if (worker == null || worker.isDead() || worker.unit.getOrder() == null) continue;
            game.drawTextMap(worker.unit.getPosition().getX(), worker.unit.getPosition().getY(), worker.unit.getOrder().toString());
        }
        if (game.getFrameCount() % 100 == 0 && invader != null) {
            for (Agent worker : this.units) {
                if (worker == null) continue;
                if (invaderCount > 1) {
                    worker.unit.attack(invader.getPosition());
                    continue;
                }
                worker.unit.attack(invader);
            }
        }
    }
}

