/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.unitgroups;

import bwapi.Color;
import bwapi.Game;
import bwapi.Player;
import bwapi.Position;
import bwapi.TechType;
import bwapi.Unit;
import bwapi.UnitType;
import com.tyr.DebugMessages;
import com.tyr.EnemyManager;
import com.tyr.EnemyPosition;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.agents.Attack;
import com.tyr.agents.MedicAttack;
import com.tyr.agents.None;
import com.tyr.unitgroups.UnitGroup;
import java.util.ArrayList;

public class AttackGroup
extends UnitGroup {
    private Position target;
    private Unit killTarget;
    public static boolean fearLurkers;
    public static boolean offensiveMines;

    static {
        offensiveMines = false;
    }

    public AttackGroup(Position target) {
        super(Tyr.bot.hobos);
        this.target = target;
    }

    public void setTarget(Position target) {
        if (target == null) {
            DebugMessages.addMessage("AttackGroup.target is null!");
        }
        this.target = target;
    }

    public void setKillTarget(Unit killTarget) {
        this.killTarget = killTarget;
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        if (this.killTarget != null) {
            Tyr.drawCircle(this.killTarget.getPosition(), Color.Purple, 16);
        }
        Position medicTarget = this.target;
        for (Agent agent : this.units) {
            if (agent.unit.getGroundWeaponCooldown() <= 0) continue;
            medicTarget = agent.unit.getPosition();
            break;
        }
        ArrayList<Unit> enemyLurkers = new ArrayList<Unit>();
        if (fearLurkers) {
            for (Unit enemy : EnemyManager.getEnemyUnits()) {
                if (enemy.getType() != UnitType.Zerg_Lurker) continue;
                enemyLurkers.add(enemy);
            }
        }
        for (Agent agent : this.units) {
            if (agent.unit.getType() == UnitType.Terran_Marine) {
                for (Unit lurker : enemyLurkers) {
                    if (agent.distanceSquared(lurker) >= 90000) continue;
                    agent.unit.move(Tyr.tileToPosition(self.getStartLocation()));
                    agent.drawCircle(Color.Blue);
                }
                if (fearLurkers) {
                    for (EnemyPosition defensive : EnemyManager.getManager().enemyDefensiveStructures) {
                        if (agent.distanceSquared(defensive.pos) >= 90000) continue;
                        agent.unit.move(Tyr.tileToPosition(self.getStartLocation()));
                        agent.drawCircle(Color.Blue);
                    }
                }
            }
            if (agent.unit.getType() == UnitType.Terran_Vulture && self.hasResearched(TechType.Spider_Mines) && agent.unit.getSpiderMineCount() > 0 && game.getFrameCount() % 100 == 0 && offensiveMines) {
                boolean mined = false;
                for (Unit enemy : EnemyManager.getEnemyUnits()) {
                    if (enemy.getType().isFlyer() || enemy.getType().isWorker() || enemy.getType().isBuilding() || enemy.getType() == UnitType.Protoss_Zealot || agent.distanceSquared(enemy) > 90000) continue;
                    agent.unit.useTech(TechType.Spider_Mines, agent.unit.getPosition());
                    agent.drawCircle(Color.Red, 300);
                    agent.drawCircle(Color.Red, 6);
                    mined = true;
                    break;
                }
                if (mined) continue;
                agent.drawCircle(Color.Yellow, 300);
            } else if (agent.unit.getType() == UnitType.Terran_Vulture) {
                if (!self.hasResearched(TechType.Spider_Mines)) {
                    agent.drawCircle(Color.Green, 6);
                } else if (agent.unit.getSpiderMineCount() <= 0) {
                    agent.drawCircle(Color.Blue, 6);
                }
            }
            if (agent.unit.getType() == UnitType.Terran_Medic) {
                agent.order(new MedicAttack(agent, medicTarget));
                continue;
            }
            if (this.killTarget != null) {
                agent.order(new None(agent));
                if (agent.distanceSquared(this.killTarget) <= agent.unit.getType().groundWeapon().maxRange() * agent.unit.getType().groundWeapon().maxRange()) {
                    agent.attack(this.killTarget);
                    continue;
                }
                agent.unit.move(this.killTarget.getPosition());
                continue;
            }
            agent.order(new Attack(agent, this.target));
        }
    }

    @Override
    public void add(Agent agent) {
        super.add(agent);
        agent.order(new None(agent));
        agent.unit.stop();
    }

    public void clear() {
        int i = this.units.size() - 1;
        while (i >= 0) {
            ((Agent)this.units.get(i)).order(new None((Agent)this.units.get(i)));
            this.rejects.add((Agent)this.units.get(i));
            this.units.remove(i);
            --i;
        }
    }
}

