/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.tasks;

import bwapi.Color;
import bwapi.Game;
import bwapi.Player;
import bwapi.Position;
import bwapi.Unit;
import bwta.BaseLocation;
import com.tyr.DebugMessages;
import com.tyr.EnemyManager;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.buildingplacement.SpaceManager;
import com.tyr.tasks.Solution;
import com.tyr.tasks.Task;
import com.tyr.unitgroups.HarassBaseGroup;
import com.tyr.unitgroups.MineralWorkers;
import java.util.ArrayList;
import java.util.List;

public class VultureHarassSolution
extends Solution {
    private HarassBaseGroup harassGroup;
    private int currentPos;
    private int currentDir = 1;
    private int enemyExpandPos = -1;
    private Position target;

    public VultureHarassSolution(Task task) {
        super(task);
        this.determineTarget();
        this.harassGroup = new HarassBaseGroup(this.target);
    }

    public VultureHarassSolution(Task task, int startDir) {
        super(task);
        this.currentDir = startDir;
        this.determineTarget();
        this.harassGroup = new HarassBaseGroup(this.target);
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        if (this.determineTarget()) {
            this.harassGroup.setTarget(this.target);
        }
        this.harassGroup.cleanup();
        this.harassGroup.onFrame(game, self, bot);
    }

    public void add(Agent agent) {
        this.harassGroup.add(agent);
    }

    public int vultureCount() {
        return this.harassGroup.units.size();
    }

    private boolean determineTarget() {
        int i;
        boolean result = false;
        ArrayList<Position> orderedExpands = EnemyManager.getManager().getOrderedExpands();
        if (orderedExpands != null) {
            i = 0;
            while (i < orderedExpands.size()) {
                Position pos = orderedExpands.get(i);
                Tyr.drawCircle(pos, Color.Red, 32);
                Tyr.game.drawTextMap(pos.getX(), pos.getY(), String.valueOf(i));
                ++i;
            }
            if (this.target != null) {
                Tyr.drawCircle(this.target, Color.Red);
            }
        }
        if (this.target == null) {
            if (orderedExpands == null) {
                DebugMessages.addMessage("orderedExpands is null.");
                return false;
            }
            this.currentPos = EnemyManager.getManager().getSelfPos();
            if (this.currentPos != -1) {
                this.target = orderedExpands.get(this.currentPos);
                result = true;
            }
        }
        i = 0;
        while (i < 2 * orderedExpands.size()) {
            boolean isIsland = false;
            for (BaseLocation loc : Tyr.bot.expands) {
                if (!loc.isIsland() || !(loc.getDistance(this.target) <= 128.0)) continue;
                isIsland = true;
            }
            if (!isIsland && this.target != null && !Tyr.game.isVisible(Tyr.positionToTile(this.target))) break;
            boolean closeEnough = false;
            for (MineralWorkers base : Tyr.bot.workForce.mineralWorkers) {
                if (base.resourceDepot == null || base.resourceDepot.getDistance(this.target) >= 100) continue;
                closeEnough = true;
            }
            if (!isIsland && this.harassGroup != null && !closeEnough) {
                for (Agent agent : this.harassGroup.units) {
                    if (agent == null || agent.distanceSquared(this.target) >= 16384) continue;
                    closeEnough = true;
                }
            }
            if (!isIsland && !closeEnough) break;
            List<Unit> unitsInRange = Tyr.game.getUnitsInRadius(this.target, 320);
            for (Unit unit : unitsInRange) {
                if (!unit.getPlayer().isEnemy(Tyr.self) || !unit.getType().isWorker()) continue;
                DebugMessages.addMessage("Worker target found.");
                return result;
            }
            this.nextTarget();
            this.determineEnemyExpand();
            while (this.currentPos == this.enemyExpandPos) {
                this.nextTarget();
            }
            result = true;
            ++i;
        }
        return result;
    }

    private void determineEnemyExpand() {
        if (this.enemyExpandPos >= 0 || Tyr.bot.suspectedEnemy.size() > 1) {
            return;
        }
        ArrayList<Position> orderedExpands = EnemyManager.getManager().getOrderedExpands();
        if (orderedExpands == null) {
            return;
        }
        Position exit = SpaceManager.getExit(Tyr.bot.suspectedEnemy.get(0).getPosition());
        int closest = -1;
        int bestDist = Integer.MAX_VALUE;
        int i = 0;
        while (i < orderedExpands.size()) {
            int dist = (int)orderedExpands.get(i).getDistance(exit);
            if (dist < bestDist) {
                closest = i;
                bestDist = dist;
            }
            ++i;
        }
        this.enemyExpandPos = closest;
    }

    private void nextTarget() {
        ArrayList<Position> orderedExpands = EnemyManager.getManager().getOrderedExpands();
        if (orderedExpands == null) {
            return;
        }
        this.currentPos += this.currentDir;
        if (this.currentPos >= orderedExpands.size() || this.currentPos < 0) {
            this.currentDir *= -1;
            this.currentPos += 2 * this.currentDir;
        }
        this.target = orderedExpands.get(this.currentPos);
    }
}

