/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.tasks;

import bwapi.Game;
import bwapi.Player;
import com.tyr.DebugMessages;
import com.tyr.Tyr;
import com.tyr.tasks.AttackTask;
import com.tyr.tasks.BCTask;
import com.tyr.tasks.ClearMineralTask;
import com.tyr.tasks.DefendMainTask;
import com.tyr.tasks.ScanTask;
import com.tyr.tasks.Task;
import java.util.ArrayList;

public class TaskManager {
    public ArrayList<Task> potentialTasks = new ArrayList();
    private ScanTask scanTask;

    public TaskManager() {
        this.potentialTasks.add(new DefendMainTask(false));
        this.potentialTasks.add(new DefendMainTask(true));
        this.potentialTasks.add(new AttackTask());
        this.potentialTasks.add(new ClearMineralTask());
        this.potentialTasks.add(new BCTask());
        this.scanTask = new ScanTask();
    }

    public void onFrame(Game game, Player self, Tyr bot) {
        if (this.scanTask != null && this.scanTask.isRequired(game, self, bot)) {
            if (!this.scanTask.isBeingSolved()) {
                this.scanTask.findSolution(game, self, bot);
            }
            if (this.scanTask.isBeingSolved()) {
                this.scanTask.solve(game, self, bot);
                DebugMessages.addMessage("Scanning.");
                return;
            }
        }
        for (Task task : this.potentialTasks) {
            boolean isRequired = task.isRequired(game, self, bot);
            if (isRequired && !task.isBeingSolved()) {
                task.findSolution(game, self, bot);
            }
            if (!isRequired || !task.isBeingSolved()) continue;
            task.solve(game, self, bot);
        }
    }

    public void disableScanner() {
        this.scanTask = null;
    }
}

