/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.tasks;

import bwapi.Game;
import bwapi.Player;
import com.tyr.DebugMessages;
import com.tyr.EnemyManager;
import com.tyr.Scanner;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.agents.None;
import com.tyr.tasks.Solution;
import com.tyr.tasks.Task;
import com.tyr.unitgroups.OutOfJob;

public class ScanSolution
extends Solution {
    Scanner scanner;

    public ScanSolution(Task task) {
        super(task);
        this.scanner = Tyr.bot.scanner;
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        DebugMessages.addMessage("Looking for enemy buildings.");
        int i = bot.homeGroup.units.size() - 1;
        while (i >= 0) {
            Agent agent = (Agent)bot.homeGroup.units.get(i);
            this.add(agent);
            agent.order(new None(agent));
            agent.unit.stop();
            bot.homeGroup.remove(i);
            --i;
        }
    }

    public void add(Agent agent) {
        agent.order(new None(agent));
        agent.unit.stop();
        if (agent.unit.getType().isFlyer()) {
            this.scanner.addAir(agent);
        } else {
            this.scanner.addGround(agent);
        }
    }

    public boolean finishedScanning() {
        return EnemyManager.getManager().enemyBuildingMemory.size() > 0;
    }

    public void clear(OutOfJob rejects) {
        this.scanner.clear(rejects);
    }
}

