/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.tasks;

import bwapi.Game;
import bwapi.Player;
import bwapi.Position;
import com.tyr.EnemyManager;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.buildingplacement.SpaceManager;
import com.tyr.tasks.ExpandPushSolution;
import com.tyr.tasks.Task;
import java.util.ArrayList;

public class ExpandPushTask
extends Task {
    @Override
    public boolean isRequired(Game game, Player self, Tyr bot) {
        if (bot.defensiveStructures.size() >= 2) {
            if (this.solution != null) {
                ((ExpandPushSolution)this.solution).clear();
                this.solution = null;
            }
            return false;
        }
        return true;
    }

    @Override
    public void solve(Game game, Player self, Tyr bot) {
        if (game.getFrameCount() % 10 == 0) {
            ArrayList<Position> orderedExpands = EnemyManager.getManager().getOrderedExpands();
            Position target = null;
            if (orderedExpands == null) {
                return;
            }
            Position exit = SpaceManager.getMainExit();
            int down = (EnemyManager.getManager().getSelfPos() - 1 + orderedExpands.size()) % orderedExpands.size();
            int up = (EnemyManager.getManager().getSelfPos() + 1) % orderedExpands.size();
            target = orderedExpands.get(down).getDistance(exit) < orderedExpands.get(up).getDistance(exit) ? this.determineTarget(orderedExpands.get(down)) : this.determineTarget(orderedExpands.get(up));
            ((ExpandPushSolution)this.solution).setTarget(target);
        }
        int i = bot.homeGroup.units.size() - 1;
        while (i >= 0) {
            Agent agent = (Agent)bot.homeGroup.units.get(i);
            ((ExpandPushSolution)this.solution).add(agent);
            bot.homeGroup.units.remove(i);
            --i;
        }
        super.solve(game, self, bot);
    }

    private Position determineTarget(Position base) {
        return SpaceManager.getDefensePos(base);
    }

    @Override
    public void findSolution(Game game, Player self, Tyr bot) {
        ArrayList<Position> orderedExpands = EnemyManager.getManager().getOrderedExpands();
        Position target = null;
        if (orderedExpands == null) {
            return;
        }
        Position exit = SpaceManager.getMainExit();
        int down = (EnemyManager.getManager().getSelfPos() - 1 + orderedExpands.size()) % orderedExpands.size();
        int up = (EnemyManager.getManager().getSelfPos() + 1) % orderedExpands.size();
        target = orderedExpands.get(down).getDistance(exit) < orderedExpands.get(up).getDistance(exit) ? this.determineTarget(orderedExpands.get(down)) : this.determineTarget(orderedExpands.get(up));
        this.solution = new ExpandPushSolution(this, target);
        int i = bot.homeGroup.units.size() - 1;
        while (i >= 0) {
            Agent agent = (Agent)bot.homeGroup.units.get(i);
            ((ExpandPushSolution)this.solution).add(agent);
            bot.homeGroup.units.remove(i);
            --i;
        }
    }
}

