/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.tasks;

import bwapi.Game;
import bwapi.Player;
import bwapi.Unit;
import bwapi.UnitType;
import bwapi.WeaponType;
import com.tyr.DebugMessages;
import com.tyr.EnemyManager;
import com.tyr.Settings;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.tasks.SendTroopsSolution;
import com.tyr.tasks.Task;
import com.tyr.unitgroups.StayAtHomeGroup;

public class DefendMainTask
extends Task {
    private Unit invader;
    private boolean flyers;

    public DefendMainTask(boolean flyers) {
        this.flyers = flyers;
    }

    @Override
    public boolean isRequired(Game game, Player self, Tyr bot) {
        if (!Settings.getDefendMain()) {
            if (!this.flyers) {
                DebugMessages.addMessage("Not defending main!");
            }
            return false;
        }
        this.invader = this.flyers ? EnemyManager.getManager().getFlyingInvader() : EnemyManager.getManager().getInvader();
        if (this.invader == null && this.solution != null) {
            ((SendTroopsSolution)this.solution).done(bot.homeGroup);
            this.solution = null;
        }
        return this.invader != null;
    }

    @Override
    public void solve(Game game, Player self, Tyr bot) {
        int i = bot.homeGroup.units.size() - 1;
        while (i >= 0) {
            if (EnemyManager.getManager().getInvaderCount() == 1 && EnemyManager.getManager().getInvader() != null && EnemyManager.getManager().getInvader().getType().isWorker() && ((SendTroopsSolution)this.solution).getCount() >= 1) break;
            Agent agent = (Agent)bot.homeGroup.units.get(i);
            if ((!StayAtHomeGroup.keepTanksSieged || !agent.isTank()) && (agent.unit.getType() != UnitType.Terran_Battlecruiser && this.flyers && agent.unit.getType().airWeapon() != WeaponType.None || !this.flyers && agent.unit.getType().groundWeapon() != WeaponType.None)) {
                ((SendTroopsSolution)this.solution).add(agent);
                bot.homeGroup.units.remove(i);
            }
            --i;
        }
        ((SendTroopsSolution)this.solution).setTarget(this.invader.getPosition());
        super.solve(game, self, bot);
    }

    @Override
    public void findSolution(Game game, Player self, Tyr bot) {
        if (this.invader != null) {
            this.solution = new SendTroopsSolution(this, this.invader.getPosition());
        }
    }
}

