/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.tasks;

import bwapi.Color;
import bwapi.Game;
import bwapi.Player;
import bwapi.Position;
import bwapi.UnitType;
import bwta.BaseLocation;
import com.tyr.BWTAProxy;
import com.tyr.DebugMessages;
import com.tyr.EnemyManager;
import com.tyr.EnemyPosition;
import com.tyr.ScannerListener;
import com.tyr.Settings;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.tasks.ConstantPushSolution;
import com.tyr.tasks.Task;
import java.util.HashSet;
import java.util.Iterator;

public class ConstantPushTask
extends Task
implements ScannerListener {
    private Position target;
    private UnitType acceptedUnit = null;
    public static HashSet<UnitType> paused = new HashSet();
    public boolean stop = false;

    public ConstantPushTask() {
        Settings.addScannerListener(this);
    }

    public ConstantPushTask(UnitType acceptedUnit) {
        Settings.addScannerListener(this);
        this.acceptedUnit = acceptedUnit;
    }

    @Override
    public boolean isRequired(Game game, Player self, Tyr bot) {
        return !this.stop;
    }

    public void addToScanner() {
        if (this.solution != null) {
            ((ConstantPushSolution)this.solution).addToScanner();
        }
    }

    @Override
    public void solve(Game game, Player self, Tyr bot) {
        if (!BWTAProxy.initialized) {
            return;
        }
        boolean newTarget = this.acquireTarget(bot);
        if (newTarget) {
            ((ConstantPushSolution)this.solution).setTarget(this.target);
        }
        for (UnitType type : paused) {
            DebugMessages.addMessage("Push paused for: " + type.toString());
        }
        if (this.stop) {
            return;
        }
        int i = bot.homeGroup.units.size() - 1;
        while (i >= 0) {
            Agent agent = (Agent)bot.homeGroup.units.get(i);
            if (paused.contains(agent.unit.getType())) {
                agent.drawCircle(Color.White, 6);
            } else if (this.acceptedUnit == null || agent.unit.getType() == this.acceptedUnit) {
                ((ConstantPushSolution)this.solution).add(agent);
                bot.homeGroup.units.remove(i);
            }
            --i;
        }
        super.solve(game, self, bot);
    }

    @Override
    public void findSolution(Game game, Player self, Tyr bot) {
        if (BWTAProxy.initialized) {
            this.acquireTarget(bot);
        }
        this.solution = new ConstantPushSolution(this, this.target);
    }

    public boolean acquireTarget(Tyr bot) {
        if (this.target != null) {
            for (EnemyPosition p : EnemyManager.getManager().enemyBuildingMemory) {
                if (p.pos.getX() != this.target.getX() || p.pos.getY() != this.target.getY()) continue;
                return false;
            }
        }
        Position newTarget = null;
        Iterator<Object> iterator = EnemyManager.getManager().enemyBuildingMemory.iterator();
        if (iterator.hasNext()) {
            EnemyPosition p = iterator.next();
            newTarget = p.pos;
        }
        if (newTarget == null && (iterator = bot.suspectedEnemy.iterator()).hasNext()) {
            BaseLocation b = (BaseLocation)iterator.next();
            newTarget = b.getPosition();
        }
        if (newTarget == null) {
            return false;
        }
        if (this.target == null) {
            this.target = newTarget;
            return true;
        }
        if (this.target.getX() == newTarget.getX() && this.target.getY() == newTarget.getY()) {
            return false;
        }
        this.target = newTarget;
        return true;
    }

    @Override
    public void onScannerEliminating() {
        if (this.solution != null) {
            ((ConstantPushSolution)this.solution).clear();
        }
        this.solution = null;
    }

    public void stop() {
        this.stop = true;
        this.clear();
    }

    public void go() {
        this.stop = false;
    }

    public void clear() {
        ((ConstantPushSolution)this.solution).clear();
    }
}

