/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.tasks;

import bwapi.Color;
import bwapi.Game;
import bwapi.Order;
import bwapi.Player;
import bwapi.Position;
import bwapi.Unit;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.agents.None;
import com.tyr.tasks.Solution;
import com.tyr.tasks.Task;

public class ClearMineralSolution
extends Solution {
    private Position clearMineralPos;
    private Agent worker;
    public boolean finished;

    public ClearMineralSolution(Task task, Position pos) {
        super(task);
        this.clearMineralPos = pos;
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        if (this.worker != null && this.worker.isDead()) {
            this.worker = null;
        }
        if (this.worker == null || this.finished) {
            return;
        }
        this.worker.drawCircle(Color.White);
        game.drawTextMap(this.worker.unit.getX(), this.worker.unit.getY(), this.worker.unit.getOrder().toString());
        int distanceSq = this.worker.distanceSquared(this.clearMineralPos);
        Unit mineral = null;
        if (distanceSq <= 4096 && (mineral = this.getMineral()) == null) {
            this.finished = true;
            return;
        }
        if (this.worker.unit.isCarryingMinerals()) {
            if (this.worker.unit.getOrder().equals(Order.ReturnMinerals)) {
                this.worker.unit.returnCargo();
            }
            return;
        }
        if (distanceSq > 4096) {
            this.worker.unit.move(this.clearMineralPos);
            this.worker.drawCircle(Color.Red, 6);
            return;
        }
        this.worker.drawCircle(Color.Green, 6);
        if (this.worker.unit.isIdle() || this.worker.unit.getOrder() == Order.Move) {
            this.worker.unit.gather(mineral);
        }
    }

    private Unit getMineral() {
        for (Unit mineral : Tyr.game.neutral().getUnits()) {
            if (!mineral.getType().isMineralField() || mineral.getResources() > 0 || mineral.getDistance(this.clearMineralPos) > 48) continue;
            return mineral;
        }
        return null;
    }

    public void setWorker(Agent worker) {
        this.worker = worker;
    }

    public Agent pop() {
        Agent result = this.worker;
        this.worker = null;
        if (result != null) {
            result.order(new None(result));
        }
        return result;
    }

    public boolean workerNeeded() {
        return this.worker == null;
    }

    public Position getPosition() {
        return this.clearMineralPos;
    }
}

