/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.tasks;

import bwapi.Color;
import bwapi.Game;
import bwapi.Player;
import bwapi.Position;
import com.tyr.EnemyManager;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.tasks.Solution;
import com.tyr.tasks.Task;
import com.tyr.unitgroups.AttackGroup;

public class BoomerangSolution
extends Solution {
    private AttackGroup attackGroup;
    private Position boomerangTarget;
    private Position target;
    private boolean returning = false;
    private int returnFrame;

    public BoomerangSolution(Task task, Position boomerangTarget) {
        super(task);
        this.boomerangTarget = boomerangTarget;
        this.attackGroup = new AttackGroup(boomerangTarget);
        this.returnFrame = Tyr.game.getFrameCount() + 2000;
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        if (this.boomerangTarget != null) {
            Tyr.drawCircle(this.boomerangTarget, Color.Blue, 200);
        }
        if (!this.returning && Tyr.game.getFrameCount() >= this.returnFrame) {
            this.returning = true;
            this.target = bot.homeGroup.target;
            this.attackGroup.setTarget(this.target);
        }
        if (!this.returning) {
            this.returning = EnemyManager.getManager().getInvaderCount() > 0;
            for (Agent agent : this.attackGroup.units) {
                if (!this.returning) break;
                if (agent.distanceSquared(this.boomerangTarget) < 40000) continue;
                this.returning = false;
            }
            if (this.returning) {
                this.target = bot.homeGroup.target;
                this.attackGroup.setTarget(this.target);
            }
        } else {
            if (this.target == null || bot.homeGroup.target.getDistance(this.target) > 100.0) {
                this.target = bot.homeGroup.target;
                this.attackGroup.setTarget(this.target);
            }
            boolean done = true;
            for (Agent agent : this.attackGroup.units) {
                if (this.target == null || agent.distanceSquared(this.target) < 40000) continue;
                done = false;
                break;
            }
            if (done) {
                this.attackGroup.clear();
            }
        }
        this.attackGroup.cleanup();
        this.attackGroup.onFrame(game, self, bot);
    }

    public void add(Agent agent) {
        this.attackGroup.add(agent);
    }

    public int size() {
        return this.attackGroup.units.size();
    }
}

