/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.builds;

import bwapi.Color;
import bwapi.Game;
import bwapi.Player;
import bwapi.Position;
import bwapi.UnitType;
import com.tyr.Settings;
import com.tyr.Tyr;
import com.tyr.UnitTracker;
import com.tyr.agents.Agent;
import com.tyr.buildingplacement.SpaceManager;
import com.tyr.builds.BuildOrder;
import com.tyr.tasks.ConstantPushTask;

public class TAntiCannon
extends BuildOrder {
    public boolean cannonRushDetected = false;

    @Override
    public void initialize(Game game, Player self, Tyr bot) {
        Settings.setWorkersPerGas(2);
        Settings.setMaximumWorkers(15);
        bot.taskManager.potentialTasks.add(new ConstantPushTask(UnitType.Terran_Siege_Tank_Tank_Mode));
        bot.bunkers.disabled = true;
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        Tyr.drawCircle(new Position(self.getStartLocation().getX() * 32 + 64, self.getStartLocation().getY() * 32 + 32), Color.Yellow, 64);
        if (self.supplyTotal() + UnitTracker.getSupplyConstructing() - self.supplyUsed() <= UnitTracker.count(UnitType.Terran_Barracks) * 3 + UnitTracker.getCcCount() * 3 && bot.getAvailableMinerals() >= 100 && self.supplyTotal() + UnitTracker.getSupplyConstructing() < 400) {
            if (UnitTracker.count(UnitType.Terran_Supply_Depot) == 0 && bot.defensiveStructures.size() >= 1) {
                Position desiredPos = SpaceManager.getMainExit();
                if (desiredPos != null) {
                    Position baseDir = Tyr.tileToPosition(self.getStartLocation());
                    baseDir = new Position(baseDir.getX() - desiredPos.getX(), baseDir.getY() - desiredPos.getY());
                    double length = Math.sqrt(baseDir.getX() * baseDir.getX() + baseDir.getY() * baseDir.getY());
                    desiredPos = new Position((int)((double)desiredPos.getX() + (double)(baseDir.getX() * 200) / length), (int)((double)desiredPos.getY() + (double)(baseDir.getY() * 200) / length));
                    bot.spaceManager.build(UnitType.Terran_Supply_Depot, desiredPos);
                } else {
                    bot.spaceManager.build(UnitType.Terran_Supply_Depot);
                }
            } else {
                bot.spaceManager.build(UnitType.Terran_Supply_Depot);
            }
        }
        if (!(bot.getAvailableMinerals() < 100 || UnitTracker.count(UnitType.Terran_Barracks) != 0 && bot.getAvailableMinerals() < 150 || UnitTracker.count(UnitType.Terran_Refinery) < 1 || UnitTracker.count(UnitType.Terran_Barracks) >= 1 && this.cannonRushDetected || UnitTracker.count(UnitType.Terran_Barracks) >= 1 && bot.getAvailableMinerals() < 300 || UnitTracker.count(UnitType.Terran_Barracks) >= Math.min(UnitTracker.getCcCount() * 4, 10))) {
            bot.spaceManager.build(UnitType.Terran_Barracks);
        }
        if (bot.getAvailableMinerals() >= 150 && UnitTracker.count(UnitType.Terran_Barracks) < Math.min(UnitTracker.getCcCount() * 2, 10) && (bot.getAvailableMinerals() >= 200 || UnitTracker.count(UnitType.Terran_Barracks) < 1) && UnitTracker.count(UnitType.Terran_Siege_Tank_Siege_Mode) + UnitTracker.count(UnitType.Terran_Siege_Tank_Tank_Mode) >= 5) {
            bot.spaceManager.build(UnitType.Terran_Barracks);
        }
        if (bot.getAvailableMinerals() >= 200 && bot.getAvailableGas() >= 100 && UnitTracker.count(UnitType.Terran_Barracks) >= 1 && UnitTracker.count(UnitType.Terran_Factory) < 1) {
            bot.spaceManager.build(UnitType.Terran_Factory);
        }
        if (UnitTracker.getGeyserCount() > 0 && bot.getAvailableMinerals() >= 100 && UnitTracker.count(UnitType.Terran_Refinery) == 0 && UnitTracker.count(UnitType.Terran_Supply_Depot) > 0) {
            bot.spaceManager.build(UnitType.Terran_Refinery);
        }
    }

    @Override
    public boolean overrideStructureOrder(Game game, Player self, Tyr bot, Agent agent) {
        if (agent.unit.getType() == UnitType.Terran_Factory) {
            return UnitTracker.countTanks() >= 5;
        }
        return false;
    }
}

