/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.builds;

import bwapi.Game;
import bwapi.Player;
import bwapi.UnitType;
import bwapi.UpgradeType;
import com.tyr.DebugMessages;
import com.tyr.Settings;
import com.tyr.Tyr;
import com.tyr.UnitTracker;
import com.tyr.agents.Agent;
import com.tyr.builds.CompositeBuildOrder;
import com.tyr.builds.SupplyDepotPart;
import com.tyr.builds.WorkerScoutPart;

public class OneBaseWraith
extends CompositeBuildOrder {
    int dropshipCount = 0;

    @Override
    public void initialize(Game game, Player self, Tyr bot) {
        Settings.setRequiredSize(40);
        Settings.setMaximumSize(60);
        this.add(new SupplyDepotPart());
        this.add(new WorkerScoutPart(1600));
        super.initialize(game, self, bot);
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        super.onFrame(game, self, bot);
        DebugMessages.addMessage("Going Wraiths.");
        if (bot.getAvailableGas() >= 400) {
            Settings.setWorkersPerGas(UnitTracker.count(UnitType.Terran_Factory) >= 1 ? 2 : 1);
        } else if (bot.getAvailableGas() <= 300) {
            Settings.setWorkersPerGas(UnitTracker.count(UnitType.Terran_Factory) >= 1 ? 3 : 2);
        }
        if (bot.getAvailableMinerals() >= 150 && UnitTracker.count(UnitType.Terran_Barracks) < 1) {
            bot.spaceManager.build(UnitType.Terran_Barracks);
        }
        if (bot.getAvailableMinerals() >= 100 && UnitTracker.count(UnitType.Terran_Refinery) == 0 && UnitTracker.count(UnitType.Terran_Barracks) >= 1) {
            bot.spaceManager.build(UnitType.Terran_Refinery);
        }
        if (bot.getAvailableMinerals() >= 150 && UnitTracker.count(UnitType.Terran_Barracks) != 0 && UnitTracker.count(UnitType.Terran_Refinery) != 0 && UnitTracker.count(UnitType.Terran_Academy) == 0 && UnitTracker.count(UnitType.Terran_Engineering_Bay) > 0 && UnitTracker.count(UnitType.Terran_Wraith) >= 5) {
            bot.spaceManager.build(UnitType.Terran_Academy);
        }
        if (bot.getAvailableMinerals() >= 200 && bot.getAvailableGas() >= 100 && UnitTracker.count(UnitType.Terran_Barracks) >= 1 && UnitTracker.count(UnitType.Terran_Factory) < 1) {
            bot.spaceManager.build(UnitType.Terran_Factory);
        }
        if (bot.getAvailableMinerals() >= 150 && bot.getAvailableGas() >= 100 && UnitTracker.count(UnitType.Terran_Starport) < 2) {
            bot.spaceManager.build(UnitType.Terran_Starport);
        }
    }

    @Override
    public boolean overrideStructureOrder(Game game, Player self, Tyr bot, Agent agent) {
        if (super.overrideStructureOrder(game, self, bot, agent)) {
            return true;
        }
        if (agent.unit.getType() == UnitType.Terran_Factory) {
            return true;
        }
        if (agent.unit.getType() == UnitType.Terran_Barracks) {
            return true;
        }
        if (agent.unit.getType() == UnitType.Terran_Science_Facility) {
            if (!agent.unit.isResearching() && agent.unit.getAddon() == null && bot.getAvailableGas() >= 50 && bot.getAvailableMinerals() >= 50) {
                agent.unit.buildAddon(UnitType.Terran_Physics_Lab);
            }
        } else {
            if (agent.unit.getType() == UnitType.Terran_Engineering_Bay) {
                return true;
            }
            if (agent.unit.getType() == UnitType.Terran_Armory) {
                if (bot.getAvailableMinerals() >= UpgradeType.Terran_Ship_Weapons.mineralPrice() && bot.getAvailableGas() >= UpgradeType.Terran_Ship_Weapons.gasPrice()) {
                    agent.unit.upgrade(UpgradeType.Terran_Ship_Weapons);
                }
                if (bot.getAvailableMinerals() >= UpgradeType.Terran_Ship_Plating.mineralPrice() && bot.getAvailableGas() >= UpgradeType.Terran_Ship_Plating.gasPrice()) {
                    agent.unit.upgrade(UpgradeType.Terran_Ship_Plating);
                }
                return true;
            }
        }
        return false;
    }
}

