/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.builds;

import bwapi.Game;
import bwapi.Player;
import bwapi.Race;
import bwapi.Unit;
import bwapi.UnitType;
import com.tyr.DebugMessages;
import com.tyr.EnemyManager;
import com.tyr.Settings;
import com.tyr.StopWatch;
import com.tyr.Tyr;
import com.tyr.UnitTracker;
import com.tyr.agents.Agent;
import com.tyr.buildingplacement.DefensiveStructures;
import com.tyr.builds.Bio;
import com.tyr.builds.BuildOrder;
import com.tyr.builds.CompositeBuildOrder;
import com.tyr.builds.GenericPartFactory;
import com.tyr.builds.SupplyDepotPart;
import com.tyr.builds.TvPGeneric;
import com.tyr.builds.WorkerScoutPart;
import com.tyr.requirements.UnitRequirement;

public class DefensiveTerran
extends CompositeBuildOrder {
    private Race opponentRace = Race.Unknown;
    private BuildOrder counter;

    @Override
    public void initialize(Game game, Player self, Tyr bot) {
        Settings.setRequiredSize(20);
        Settings.setMaximumSize(40);
        Settings.setWorkersPerGas(1);
        this.add(new SupplyDepotPart());
        this.add(new WorkerScoutPart(1600));
        this.add(new GenericPartFactory(UnitType.Terran_Barracks).setCost(100, 0).create());
        this.add(new GenericPartFactory(UnitType.Terran_Engineering_Bay).setMax(2).add(new UnitRequirement(UnitType.Terran_Marine, 20)).add(new UnitRequirement(UnitType.Terran_Academy)).create());
        super.initialize(game, self, bot);
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        if (this.opponentRace == Race.Unknown) {
            if (game.enemy().getRace() == Race.Zerg) {
                this.opponentRace = Race.Zerg;
            } else if (game.enemy().getRace() == Race.Terran) {
                this.opponentRace = Race.Terran;
            } else if (game.enemy().getRace() == Race.Protoss) {
                this.opponentRace = Race.Protoss;
            }
            if (this.opponentRace == Race.Unknown) {
                for (Unit unit : EnemyManager.getEnemyUnits()) {
                    if (unit.getType().getRace() == Race.Zerg) {
                        this.opponentRace = Race.Zerg;
                    } else if (unit.getType().getRace() == Race.Terran) {
                        this.opponentRace = Race.Terran;
                    } else if (unit.getType().getRace() == Race.Protoss) {
                        this.opponentRace = Race.Protoss;
                    }
                    if (this.opponentRace != Race.Unknown) break;
                }
            }
            if (this.opponentRace == Race.Zerg) {
                this.counter = new Bio(Bio.DEFENSIVE);
            } else if (this.opponentRace == Race.Terran) {
                this.counter = new TvPGeneric();
            } else if (this.opponentRace == Race.Protoss) {
                this.counter = new TvPGeneric();
            }
            if (this.opponentRace != Race.Unknown) {
                this.counter.initialize(game, self, bot);
            }
        }
        if (this.opponentRace != Race.Unknown) {
            this.counter.onFrame(game, self, bot);
            return;
        }
        DebugMessages.addMessage("TvX build.");
        StopWatch watch = new StopWatch();
        watch.start();
        super.onFrame(game, self, bot);
        long time = watch.time();
        if (time > 55L) {
            DebugMessages.addMessage("TvX super time: " + time);
        }
        if (bot.getAvailableMinerals() >= 100 && UnitTracker.count(UnitType.Terran_Barracks) >= 1) {
            for (DefensiveStructures structures : bot.defensiveStructures) {
                int count = structures.getUnitCount(UnitType.Terran_Bunker);
                if (bot.defensiveStructures.size() > 1 && structures.defendedPosition.getDistance(Tyr.tileToPosition(self.getStartLocation())) <= 200.0 || count >= 1) continue;
                bot.spaceManager.buildDefensive(UnitType.Terran_Bunker, structures);
                break;
            }
        }
        if ((time = watch.time()) > 55L) {
            DebugMessages.addMessage("TvX bunker time: " + time);
        }
    }

    @Override
    public boolean overrideStructureOrder(Game game, Player self, Tyr bot, Agent agent) {
        if (this.opponentRace != Race.Unknown) {
            return this.counter.overrideStructureOrder(game, self, bot, agent);
        }
        if (super.overrideStructureOrder(game, self, bot, agent)) {
            return true;
        }
        if (agent.unit.getType() == UnitType.Terran_Barracks && UnitTracker.count(UnitType.Terran_Marine) < 4 * UnitTracker.count(UnitType.Terran_Bunker)) {
            return false;
        }
        return false;
    }
}

