/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.builds;

import bwapi.Game;
import bwapi.Player;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.builds.BuildOrder;
import java.util.ArrayList;

public abstract class CompositeBuildOrder
extends BuildOrder {
    private ArrayList<BuildOrder> parts = new ArrayList();
    boolean initialized = false;

    @Override
    public void initialize(Game game, Player self, Tyr bot) {
        for (BuildOrder part : this.parts) {
            part.initialize(game, self, bot);
        }
        this.initialized = true;
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        for (BuildOrder part : this.parts) {
            part.onFrame(game, self, bot);
        }
    }

    @Override
    public boolean overrideStructureOrder(Game game, Player self, Tyr bot, Agent agent) {
        for (BuildOrder part : this.parts) {
            if (!part.overrideStructureOrder(game, self, bot, agent)) continue;
            return true;
        }
        return false;
    }

    public void add(BuildOrder part) {
        this.parts.add(part);
        if (this.initialized) {
            part.initialize(Tyr.game, Tyr.game.self(), Tyr.bot);
        }
    }
}

