/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.builds;

import bwapi.Game;
import bwapi.Player;
import bwapi.Position;
import bwapi.Unit;
import bwapi.UnitType;
import bwta.BaseLocation;
import com.tyr.EnemyManager;
import com.tyr.EnemyPosition;
import com.tyr.Settings;
import com.tyr.Tyr;
import com.tyr.UnitTracker;
import com.tyr.agents.Agent;
import com.tyr.builds.BuildOrder;
import com.tyr.builds.MassTank;
import com.tyr.builds.TvP;
import com.tyr.tasks.ConstantPushTask;
import com.tyr.unitgroups.ScoutGroup;

public class BBS
extends BuildOrder {
    private boolean scoutRequested = false;
    private boolean cannonBuildDetected = false;
    private boolean zealotRushDetected = false;
    private MassTank massTank = new MassTank();
    private TvP tvp = new TvP();

    @Override
    public void initialize(Game game, Player self, Tyr bot) {
        Settings.setRallyPoint(new Position(game.mapWidth() * 16, game.mapHeight() * 16));
        bot.taskManager.potentialTasks.add(new ConstantPushTask(UnitType.Terran_Marine));
        this.massTank.initialize(game, self, bot);
        this.tvp.initialize(game, self, bot);
        Settings.setDefendMain(false);
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        if (UnitTracker.count(UnitType.Terran_Marine) > 0 && !this.scoutRequested) {
            this.scoutRequested = true;
            int i = 0;
            while (i < (bot.suspectedEnemy.size() >= 3 ? 2 : 1)) {
                bot.scout.requestWorkerScoutOnce();
                ++i;
            }
        }
        if (!this.zealotRushDetected) {
            if (EnemyManager.getManager().enemyDefensiveStructures.size() > 0) {
                this.cannonBuildDetected = true;
            }
            if (this.cannonBuildDetected) {
                if (UnitTracker.count(UnitType.Terran_Siege_Tank_Siege_Mode) + UnitTracker.count(UnitType.Terran_Siege_Tank_Tank_Mode) < 5) {
                    this.massTank.onFrame(game, self, bot);
                } else {
                    this.tvp.onFrame(game, self, bot);
                }
                return;
            }
        }
        if (!this.cannonBuildDetected) {
            int gatewayCount = 0;
            for (EnemyPosition enemy : EnemyManager.getManager().enemyBuildingMemory) {
                if (enemy.type != UnitType.Protoss_Gateway) continue;
                ++gatewayCount;
            }
            if (gatewayCount >= 2) {
                if (bot.scout.opponentStrategy == ScoutGroup.zealotPush) {
                    Settings.setRequiredSize(40);
                }
                Settings.setMaximumSize(60);
                this.zealotRushDetected = true;
            }
            if (!this.zealotRushDetected) {
                int zealots = 0;
                for (Unit enemy : EnemyManager.getEnemyUnits()) {
                    if (enemy.getType() != UnitType.Protoss_Zealot) continue;
                    ++zealots;
                }
                if (zealots >= 5) {
                    Settings.setRequiredSize(40);
                    Settings.setMaximumSize(60);
                    this.zealotRushDetected = true;
                }
            }
            if (this.zealotRushDetected) {
                if (UnitTracker.count(UnitType.Terran_Bunker) == 0 && UnitTracker.count(UnitType.Terran_Barracks) > 0) {
                    if (bot.getAvailableMinerals() >= 100 && bot.defensiveStructures.size() >= 0) {
                        bot.spaceManager.buildDefensive(UnitType.Terran_Bunker, bot.defensiveStructures.get(0));
                    }
                    return;
                }
                this.tvp.onFrame(game, self, bot);
                return;
            }
        }
        if (bot.suspectedEnemy.size() == 1 && bot.getAvailableMinerals() >= 100 && UnitTracker.count(UnitType.Terran_Marine) >= 8 && UnitTracker.count(UnitType.Terran_Bunker) < 1) {
            Position enemyPos = bot.suspectedEnemy.get(0).getPosition();
            Position expo = null;
            int distance = Integer.MAX_VALUE;
            for (BaseLocation loc : bot.expands) {
                int newDist = (int)enemyPos.getDistance(loc.getPosition());
                if (newDist >= distance) continue;
                distance = newDist;
                expo = loc.getPosition();
            }
            if (expo != null) {
                bot.spaceManager.build(UnitType.Terran_Bunker, expo);
            }
        }
        if (bot.getAvailableMinerals() >= 150 && UnitTracker.count(UnitType.Terran_Barracks) < 2) {
            int i = UnitTracker.count(UnitType.Terran_Barracks);
            while (i < 2) {
                bot.spaceManager.build(UnitType.Terran_Barracks, new Position(game.mapWidth() * 16, game.mapHeight() * 16 - 80 + 160 * i));
                ++i;
            }
        }
        if (bot.getAvailableMinerals() >= 100 && UnitTracker.count(UnitType.Terran_Barracks) == 2 && UnitTracker.count(UnitType.Terran_Supply_Depot) == 0) {
            bot.spaceManager.build(UnitType.Terran_Supply_Depot);
        }
        if (bot.getAvailableMinerals() >= 100 && UnitTracker.count(UnitType.Terran_Barracks) == 2 && UnitTracker.count(UnitType.Terran_Supply_Depot) > 0 && self.supplyTotal() + UnitTracker.getSupplyConstructing() - self.supplyUsed() <= 4 && self.supplyTotal() + UnitTracker.getSupplyConstructing() < 400) {
            bot.spaceManager.build(UnitType.Terran_Supply_Depot);
        }
    }

    @Override
    public boolean overrideStructureOrder(Game game, Player self, Tyr bot, Agent agent) {
        if (this.cannonBuildDetected) {
            if (agent.unit.getType() == UnitType.Terran_Barracks && UnitTracker.count(UnitType.Terran_Machine_Shop) == 0 && bot.getAvailableMinerals() <= 250) {
                return true;
            }
            return this.massTank.overrideStructureOrder(game, self, bot, agent);
        }
        if (this.zealotRushDetected) {
            if (UnitTracker.count(UnitType.Terran_Bunker) == 0) {
                return true;
            }
            return this.tvp.overrideStructureOrder(game, self, bot, agent);
        }
        if (agent.unit.getType() == UnitType.Terran_Command_Center) {
            if (!(UnitTracker.count(UnitType.Terran_Marine) != 0 && bot.getAvailableMinerals() < 250 || agent.unit.isTraining() || bot.getAvailableMinerals() < 50)) {
                if (UnitTracker.count(UnitType.Terran_SCV) < 8) {
                    agent.unit.train(UnitType.Terran_SCV);
                } else if (UnitTracker.count(UnitType.Terran_Barracks) >= 2 && UnitTracker.count(UnitType.Terran_SCV) < 9) {
                    agent.unit.train(UnitType.Terran_SCV);
                } else if (UnitTracker.count(UnitType.Terran_Supply_Depot) >= 1) {
                    agent.unit.train(UnitType.Terran_SCV);
                }
            }
            return true;
        }
        if (agent.unit.getType() == UnitType.Terran_Barracks) {
            if (!agent.unit.isTraining() && bot.getAvailableMinerals() >= 50) {
                agent.unit.train(UnitType.Terran_Marine);
            }
            return true;
        }
        return false;
    }
}

