/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.buildingplacement;

import bwapi.Color;
import bwapi.Game;
import bwapi.Player;
import bwapi.Position;
import bwapi.Race;
import bwapi.TilePosition;
import bwapi.Unit;
import bwapi.UnitType;
import bwta.BaseLocation;
import bwta.Chokepoint;
import bwta.Region;
import com.tyr.BWTAProxy;
import com.tyr.EnemyManager;
import com.tyr.EnemyPosition;
import com.tyr.Settings;
import com.tyr.Tyr;
import com.tyr.UnitTracker;
import com.tyr.agents.Agent;
import com.tyr.agents.BuildDefensive;
import com.tyr.buildingplacement.BuildCommand;
import com.tyr.buildingplacement.BuildSiteLocator;
import com.tyr.buildingplacement.DefaultBuildSite;
import com.tyr.buildingplacement.DefensiveStructures;
import com.tyr.buildingplacement.DepotBuildSite;
import com.tyr.unitgroups.MineralWorkers;
import java.util.ArrayList;
import java.util.List;

public class SpaceManager {
    public int[][] map;
    public int width;
    public int height;
    private static Position mainExit = null;
    static final boolean debug = false;
    public ArrayList<BuildSiteLocator> buildSiteLocators = new ArrayList();
    public DepotBuildSite depotBuildSite = null;

    public SpaceManager() {
        this.width = Tyr.game.mapWidth();
        this.height = Tyr.game.mapHeight();
        this.map = new int[this.width][this.height];
        int x = 0;
        while (x < this.width) {
            int y = 0;
            while (y < this.height) {
                if (Tyr.game.isBuildable(x, y)) {
                    this.map[x][y] = 1;
                }
                ++y;
            }
            ++x;
        }
        if (Tyr.self.getRace() == Race.Terran) {
            this.depotBuildSite = new DepotBuildSite();
            this.buildSiteLocators.add(this.depotBuildSite);
        }
        this.buildSiteLocators.add(new DefaultBuildSite());
    }

    public void onFrame(Game game, Player self, Tyr bot) {
        int x = 0;
        while (x < this.width) {
            int y = 0;
            while (y < this.height) {
                if (this.map[x][y] != 0 && this.map[x][y] != 3) {
                    this.map[x][y] = 1;
                }
                ++y;
            }
            ++x;
        }
        for (Unit neutralUnit : game.getNeutralUnits()) {
            this.reserveSpace(neutralUnit);
        }
        for (Unit myUnit : self.getUnits()) {
            if (!myUnit.getType().isBuilding() || myUnit.isLifted()) continue;
            this.reserveSpace(myUnit);
        }
        for (MineralWorkers base : bot.workForce.mineralWorkers) {
            if (base.turretSite == null) continue;
            TilePosition[] tilePositionArray = base.turretSite.turretPositions;
            int n = base.turretSite.turretPositions.length;
            int n2 = 0;
            while (n2 < n) {
                TilePosition pos = tilePositionArray[n2];
                if (pos != null) {
                    this.reserveSpace(pos, UnitType.Terran_Missile_Turret);
                    game.drawBoxMap(pos.getX() * 32, pos.getY() * 32, (pos.getX() + 2) * 32, (pos.getY() + 2) * 32, Color.Orange);
                }
                ++n2;
            }
        }
        for (BuildCommand com : bot.buildCommands) {
            this.reserveSpace(com);
        }
        if (bot.wallOff != null && bot.wallOff.placementFound) {
            for (BuildCommand com : bot.wallOff.buildPlan) {
                this.reserveSpace(com);
            }
            for (BuildCommand com : bot.wallOff.underConstruction) {
                this.reserveSpace(com);
            }
        }
        if (this.depotBuildSite != null) {
            this.depotBuildSite.onFrame();
        }
    }

    public void reserveSpace(Unit unit) {
        this.reserveSpace(unit.getTilePosition(), unit.getType());
    }

    public void reserveSpace(BuildCommand com) {
        this.reserveSpace(com.position, com.building);
    }

    public void reserveSpace(TilePosition pos, UnitType building) {
        int dy;
        int dx;
        if (building.canBuildAddon()) {
            dx = 0;
            while (dx < 2) {
                dy = 0;
                while (dy < 2) {
                    this.map[pos.getX() + building.tileWidth() + dx][pos.getY() + building.tileHeight() - 2 + dy] = 2;
                    ++dy;
                }
                ++dx;
            }
        }
        dx = 0;
        while (dx < building.tileWidth()) {
            dy = 0;
            while (dy < building.tileHeight()) {
                this.map[pos.getX() + dx][pos.getY() + dy] = building.isNeutral() ? 3 : 2;
                ++dy;
            }
            ++dx;
        }
    }

    public boolean canBuildHere(Unit builder, TilePosition pos, UnitType building) {
        int dy;
        if (pos.getX() < 0 || pos.getY() < 0 || pos.getX() + building.tileWidth() >= this.width || pos.getY() + building.tileHeight() >= this.height) {
            return false;
        }
        int dx = 0;
        while (dx < building.tileWidth()) {
            dy = 0;
            while (dy < building.tileHeight()) {
                if (this.map[pos.getX() + dx][pos.getY() + dy] != 1) {
                    return false;
                }
                ++dy;
            }
            ++dx;
        }
        if (building.canBuildAddon()) {
            if (pos.getX() + building.tileWidth() + 2 >= this.width) {
                return false;
            }
            dx = 0;
            while (dx < 2) {
                dy = 0;
                while (dy < 2) {
                    if (this.map[pos.getX() + building.tileWidth() + dx][pos.getY() + building.tileHeight() - 2 + dy] != 1) {
                        return false;
                    }
                    ++dy;
                }
                ++dx;
            }
        }
        if (!building.isResourceDepot()) {
            for (BaseLocation loc : Tyr.bot.expands) {
                TilePosition locpos = loc.getTilePosition();
                if (pos.getX() + building.tileWidth() <= locpos.getX() - 1 || pos.getX() > locpos.getX() + UnitType.Terran_Command_Center.tileWidth() + 3 || pos.getY() + building.tileHeight() <= locpos.getY() - 1 || pos.getY() > locpos.getY() + UnitType.Terran_Command_Center.tileHeight() + 1) continue;
                return false;
            }
        }
        return Tyr.game.canBuildHere(pos, building, builder, false);
    }

    public boolean isFree(TilePosition pos) {
        if (pos.getX() < 0 || pos.getY() < 0 || pos.getX() + 1 >= this.width || pos.getY() + 1 >= this.height) {
            return false;
        }
        return this.map[pos.getX()][pos.getY()] == 1;
    }

    public static boolean canBuildHere(Unit builder, int i, int j, UnitType building) {
        return SpaceManager.canBuildHere(builder, i, j, building, true);
    }

    public static boolean hasCreep(TilePosition p, UnitType building) {
        if (!building.requiresCreep()) {
            return true;
        }
        int i = p.getX();
        while (i <= p.getX() + building.tileWidth()) {
            int j = p.getY();
            while (j <= p.getY() + building.tileHeight()) {
                if (!Tyr.game.hasCreep(i, j)) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public static boolean freeOfUnits(TilePosition p, UnitType building, Unit builder) {
        for (Unit u : Tyr.game.getAllUnits()) {
            if (u.getID() == builder.getID() || (building == UnitType.Terran_Bunker || building == UnitType.Terran_Missile_Turret) && (u.getType() == UnitType.Terran_Bunker || u.getType() == UnitType.Terran_Missile_Turret || u.getType().isRefinery() || u.getType() == UnitType.Resource_Vespene_Geyser) || building == UnitType.Terran_Supply_Depot && (u.getType() == UnitType.Terran_Supply_Depot || u.getType() == UnitType.Terran_Armory || u.getType() == UnitType.Terran_Academy) || !(building == UnitType.Terran_Missile_Turret ? Math.abs(u.getTilePosition().getX() - p.getX()) < 2 && Math.abs(u.getTilePosition().getY() - p.getY()) < 2 : u.getTilePosition().getX() - p.getX() < building.tileWidth() + 1 && p.getX() - u.getTilePosition().getX() < u.getType().tileWidth() + 1 && u.getTilePosition().getY() - p.getY() < building.tileHeight() + 1 && p.getY() - u.getTilePosition().getY() < u.getType().tileHeight() + 1)) continue;
            return false;
        }
        return true;
    }

    public static boolean canBuildHere(Unit builder, int i, int j, UnitType building, boolean checkMap) {
        if (building.requiresPsi() && Tyr.self.completedUnitCount(UnitType.Protoss_Pylon) == 0) {
            return false;
        }
        if (checkMap && (!Tyr.bot.spaceManager.canBuildHere(builder, new TilePosition(i, j), building) || building.canBuildAddon() && !Tyr.bot.spaceManager.canBuildHere(builder, new TilePosition(i + 2, j), building))) {
            return false;
        }
        if (!SpaceManager.hasCreep(new TilePosition(i, j), building)) {
            return false;
        }
        if (BWTAProxy.initialized) {
            TilePosition tilePosition = new TilePosition(i, j);
            if (SpaceManager.getMainExit().getDistance(Tyr.tileToPosition(tilePosition)) <= 64.0) {
                return false;
            }
        }
        return SpaceManager.freeOfUnits(new TilePosition(i, j), building, builder);
    }

    public boolean build(UnitType building) {
        return this.build(building, null);
    }

    public boolean build(UnitType building, Position desiredPosition) {
        Agent worker = Tyr.bot.workForce.pop(desiredPosition == null ? Tyr.tileToPosition(Tyr.self.getStartLocation()) : desiredPosition);
        if (worker == null) {
            return false;
        }
        TilePosition buildTile = null;
        for (BuildSiteLocator locator : this.buildSiteLocators) {
            buildTile = locator.findPlacement(building, desiredPosition == null ? null : Tyr.positionToTile(desiredPosition), worker);
            if (buildTile != null) break;
        }
        if (buildTile == null) {
            Tyr.bot.workForce.add(worker);
            return false;
        }
        boolean closeMineralFound = false;
        if (building.isResourceDepot()) {
            List<Unit> inRange = Tyr.game.getUnitsInRadius(Tyr.tileToPosition(buildTile), 270);
            for (Unit mineral : inRange) {
                if (!mineral.getType().isMineralField()) continue;
                worker.unit.gather(mineral);
                closeMineralFound = true;
                break;
            }
        }
        Tyr.bot.builders.add(worker);
        BuildCommand com = null;
        com = this.placeBuilding(worker, building, buildTile);
        if (!closeMineralFound) {
            worker.unit.move(com.getCenter());
        }
        return true;
    }

    public boolean build(UnitType building, Position desiredPosition, BuildSiteLocator locator) {
        Agent worker = Tyr.bot.workForce.pop(desiredPosition == null ? Tyr.tileToPosition(Tyr.self.getStartLocation()) : desiredPosition);
        if (worker == null) {
            return false;
        }
        TilePosition buildTile = locator.findPlacement(building, desiredPosition == null ? null : Tyr.positionToTile(desiredPosition), worker);
        if (buildTile == null) {
            Tyr.bot.workForce.add(worker);
            return false;
        }
        boolean closeMineralFound = false;
        if (building.isResourceDepot()) {
            List<Unit> inRange = Tyr.game.getUnitsInRadius(Tyr.tileToPosition(buildTile), 270);
            for (Unit mineral : inRange) {
                if (!mineral.getType().isMineralField()) continue;
                worker.unit.gather(mineral);
                closeMineralFound = true;
                break;
            }
        }
        Tyr.bot.builders.add(worker);
        BuildCommand com = null;
        com = this.placeBuilding(worker, building, buildTile);
        if (!closeMineralFound) {
            worker.unit.move(com.getCenter());
        }
        return true;
    }

    public boolean buildExact(UnitType building, TilePosition pos) {
        Agent worker = Tyr.bot.workForce.pop(Tyr.tileToPosition(pos));
        if (worker == null) {
            return false;
        }
        if (SpaceManager.canBuildHere(worker.unit, pos.getX(), pos.getY(), building, false)) {
            this.placeBuilding(worker, building, pos);
            return true;
        }
        Tyr.bot.workForce.add(worker);
        return false;
    }

    public boolean buildDefensive(UnitType building, DefensiveStructures defensePos) {
        TilePosition newDefensePos;
        TilePosition target;
        Agent worker;
        Position pos = defensePos.getDefensePos();
        if (pos == null) {
            pos = Tyr.tileToPosition(Tyr.self.getStartLocation());
        }
        if ((worker = Tyr.bot.workForce.pop(pos)) == null) {
            return false;
        }
        TilePosition tilePosition = target = defensePos.getDefensePos() == null ? null : Tyr.positionToTile(defensePos.getDefensePos());
        if (target == null) {
            Tyr.bot.workForce.add(worker);
            return false;
        }
        if (Settings.getCloseDefense()) {
            TilePosition defendedTile = Tyr.positionToTile(defensePos.defendedPosition);
            target = new TilePosition((target.getX() + defendedTile.getX()) / 2, (target.getY() + defendedTile.getY()) / 2);
        }
        if ((newDefensePos = this.addDefensePos(worker.unit, building, defensePos)) != null) {
            this.placeBuilding(worker, building, newDefensePos);
            worker.order(new BuildDefensive(worker, defensePos));
            return true;
        }
        TilePosition buildTile = this.getBuildTile(worker.unit, building, target);
        if (buildTile == null) {
            Tyr.bot.workForce.add(worker);
            return false;
        }
        BuildCommand com = this.placeBuilding(worker, building, buildTile);
        worker.order(new BuildDefensive(worker, defensePos));
        worker.unit.move(com.getCenter());
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public TilePosition getBuildTile(Unit builder, UnitType buildingType, TilePosition aroundTile) {
        ret = null;
        maxDist = 3;
        stopDist = 40;
        if (buildingType.isRefinery()) {
            for (Unit n : Tyr.game.neutral().getUnits()) {
                if (n.getType() != UnitType.Resource_Vespene_Geyser) continue;
                alreadyConstructing = false;
                for (BuildCommand com : Tyr.bot.buildCommands) {
                    if (!com.building.isRefinery() || com.position.getX() != n.getTilePosition().getX() || com.position.getY() != n.getTilePosition().getY()) continue;
                    alreadyConstructing = true;
                    break;
                }
                if (alreadyConstructing) continue;
                hasBase = false;
                for (MineralWorkers base : Tyr.bot.workForce.mineralWorkers) {
                    if (base.gasWorkers == null || Math.abs(base.gasWorkers.geyser.getX() - n.getX()) > 10 || Math.abs(base.gasWorkers.geyser.getY() - n.getY()) > 10 || base.resourceDepot.isBeingConstructed()) continue;
                    hasBase = true;
                    break;
                }
                if (!hasBase) continue;
                return n.getTilePosition();
            }
        }
        if (buildingType.isResourceDepot()) {
            loc = null;
            for (BaseLocation b : Tyr.bot.expands) {
                if (!Tyr.game.canBuildHere(b.getTilePosition(), buildingType, builder, false)) continue;
                enemyBase = false;
                for (EnemyPosition p : EnemyManager.getManager().enemyBuildingMemory) {
                    v0 = enemyBase = b.getPosition().getDistance(p.pos.getX(), p.pos.getY()) < 256.0;
                    if (enemyBase) break;
                }
                if (enemyBase) continue;
                unitsInWay = false;
                for (BuildCommand cmd : Tyr.bot.buildCommands) {
                    if (!(cmd.position.getDistance(b.getTilePosition()) <= 1.0)) continue;
                    unitsInWay = true;
                    break;
                }
                if (unitsInWay) continue;
                if (BWTAProxy.initialized) {
                    if (loc != null && !(BWTAProxy.getGroundDistance(aroundTile, b.getTilePosition()) < BWTAProxy.getGroundDistance(aroundTile, loc.getTilePosition()))) continue;
                    loc = b;
                    continue;
                }
                if (loc != null && !(aroundTile.getDistance(b.getTilePosition()) < aroundTile.getDistance(loc.getTilePosition()))) continue;
                loc = b;
            }
            return loc == null ? null : loc.getTilePosition();
        }
        if (Tyr.game.isVisible(aroundTile)) ** GOTO lbl58
        return aroundTile;
lbl-1000:
        // 1 sources

        {
            i = aroundTile.getX() - maxDist;
            while (i <= aroundTile.getX() + maxDist) {
                if (buildingType != UnitType.Protoss_Pylon || i > 6 && i < Tyr.game.mapWidth() - 6) {
                    j = aroundTile.getY() - maxDist;
                    while (j <= aroundTile.getY() + maxDist) {
                        if ((buildingType != UnitType.Protoss_Pylon || j > 6 && j < Tyr.game.mapHeight() - 6) && SpaceManager.canBuildHere(builder, i, j, buildingType)) {
                            return new TilePosition(i, j);
                        }
                        ++j;
                    }
                }
                ++i;
            }
            maxDist += 2;
lbl58:
            // 2 sources

            ** while (maxDist < stopDist && ret == null)
        }
lbl59:
        // 1 sources

        return ret;
    }

    private BuildCommand placeBuilding(Agent worker, UnitType building, TilePosition buildTile) {
        BuildCommand com = new BuildCommand(worker, building, buildTile);
        Tyr.bot.buildCommands.add(com);
        this.reserveSpace(com);
        Tyr.bot.reservedMinerals += building.mineralPrice();
        Tyr.bot.reservedGas += building.gasPrice();
        return com;
    }

    public TilePosition addDefensePos(Unit builder, UnitType building, DefensiveStructures defenses) {
        for (Unit structure : defenses.defences) {
            int x1;
            TilePosition pos = structure.getTilePosition();
            int dx = 1 - building.tileWidth();
            while (dx < building.tileWidth()) {
                x1 = pos.getX() + dx;
                int y1 = pos.getY() - building.tileHeight();
                int y2 = pos.getY() + structure.getType().tileHeight();
                if (SpaceManager.canBuildHere(builder, x1, y1, building)) {
                    return new TilePosition(x1, y1);
                }
                if (SpaceManager.canBuildHere(builder, x1, y2, building)) {
                    return new TilePosition(x1, y2);
                }
                ++dx;
            }
            int dy = 1 - building.tileHeight();
            while (dy < building.tileHeight()) {
                x1 = pos.getX() - building.tileWidth();
                int x2 = pos.getX() + structure.getType().tileWidth();
                int y1 = pos.getY() + dy;
                if (SpaceManager.canBuildHere(builder, x1, y1, building)) {
                    return new TilePosition(x1, y1);
                }
                if (SpaceManager.canBuildHere(builder, x2, y1, building)) {
                    return new TilePosition(x2, y1);
                }
                ++dy;
            }
        }
        return null;
    }

    public static Position getMainExit() {
        if (!BWTAProxy.initialized) {
            return null;
        }
        if (mainExit != null) {
            return mainExit;
        }
        return SpaceManager.getExit(Tyr.tileToPosition(Tyr.self.getStartLocation()));
    }

    public static Position getExit(Position pos) {
        double distance;
        if (!BWTAProxy.initialized) {
            return null;
        }
        List<BaseLocation> startLocations = BWTAProxy.getStartLocations();
        int baseCount = startLocations.size();
        Region current = BWTAProxy.getRegion(pos);
        if (current == null) {
            return null;
        }
        Position target = null;
        double bestDistance = -1.0;
        List<Chokepoint> chokepoints = current.getChokepoints();
        if (chokepoints == null) {
            return null;
        }
        if (chokepoints.size() == 1) {
            mainExit = chokepoints.get(0).getCenter();
            return mainExit;
        }
        for (Chokepoint choke : chokepoints) {
            distance = SpaceManager.getClosestNeutralDistance(choke.getCenter());
            if (distance != -1.0 && distance < 128.0 && baseCount > 2) continue;
            distance = Math.min(choke.getX(), choke.getY());
            distance = Math.min(distance, (double)(Tyr.game.mapWidth() * 32 - choke.getX()));
            if ((distance = Math.min(distance, (double)(Tyr.game.mapHeight() * 32 - choke.getY()))) >= 1024.0 || target != null && !(distance > bestDistance)) continue;
            target = choke.getCenter();
            bestDistance = distance;
        }
        if (target == null) {
            for (Chokepoint choke : chokepoints) {
                distance = Math.min(choke.getX(), choke.getY());
                distance = Math.min(distance, (double)(Tyr.game.mapWidth() * 32 - choke.getX()));
                distance = Math.min(distance, (double)(Tyr.game.mapHeight() * 32 - choke.getY()));
                if (target != null && !(distance > bestDistance)) continue;
                target = choke.getCenter();
                bestDistance = distance;
            }
        }
        mainExit = target;
        return mainExit;
    }

    private static double getClosestNeutralDistance(Position pos) {
        double result = -1.0;
        for (EnemyPosition neutral : UnitTracker.getNeutralStructures()) {
            if (neutral.type == UnitType.Resource_Mineral_Field || neutral.type == UnitType.Resource_Mineral_Field_Type_2 || neutral.type == UnitType.Resource_Mineral_Field_Type_3 || neutral.type == UnitType.Resource_Vespene_Geyser) continue;
            double distance = pos.getDistance(neutral.pos);
            result = result == -1.0 ? distance : Math.min(result, distance);
        }
        return result;
    }

    public static BaseLocation getEnemyNatural() {
        Position exit = SpaceManager.getExit(Tyr.bot.suspectedEnemy.get(0).getPosition());
        int closestDist = Integer.MAX_VALUE;
        BaseLocation result = null;
        for (BaseLocation loc : Tyr.bot.expands) {
            int newDist = (int)loc.getDistance(exit);
            if (newDist >= closestDist) continue;
            closestDist = newDist;
            result = loc;
        }
        return result;
    }

    public static Position getNatural() {
        BaseLocation loc = null;
        for (BaseLocation b : Tyr.bot.expands) {
            if (b.isMineralOnly() || b.isIsland() || b.getDistance(Tyr.tileToPosition(Tyr.self.getStartLocation())) <= 100.0) continue;
            if (BWTAProxy.initialized) {
                if (loc != null && !(BWTAProxy.getGroundDistance(Tyr.self.getStartLocation(), b.getTilePosition()) < BWTAProxy.getGroundDistance(Tyr.self.getStartLocation(), loc.getTilePosition()))) continue;
                loc = b;
                continue;
            }
            if (loc != null && !(Tyr.self.getStartLocation().getDistance(b.getTilePosition()) < Tyr.self.getStartLocation().getDistance(loc.getTilePosition()))) continue;
            loc = b;
        }
        return loc == null ? null : loc.getPosition();
    }

    public static Position getDefensePos(Position basePosition) {
        ArrayList<Position> minerals = new ArrayList<Position>();
        for (EnemyPosition mineral : EnemyManager.getManager().neutralBuildingMemory) {
            if (!mineral.type.isMineralField() || !(mineral.pos.getDistance(basePosition) <= 270.0)) continue;
            minerals.add(mineral.pos);
        }
        return SpaceManager.getDefensePosPositions(basePosition, minerals);
    }

    public static Position getDefensePos(Position basePosition, ArrayList<Unit> minerals) {
        ArrayList<Position> positions = new ArrayList<Position>();
        for (Unit mineral : minerals) {
            positions.add(mineral.getPosition());
        }
        return SpaceManager.getDefensePosPositions(basePosition, positions);
    }

    public static Position getDefensePosPositions(Position basePosition, ArrayList<Position> minerals) {
        int totalX = 0;
        int totalY = 0;
        for (Position mineral : minerals) {
            totalX += mineral.getX();
            totalY += mineral.getY();
        }
        Position defensePos = minerals.size() != 0 ? new Position(totalX / minerals.size(), totalY / minerals.size()) : new Position(basePosition.getX(), basePosition.getY());
        defensePos = new Position(2 * basePosition.getX() - defensePos.getX(), 2 * basePosition.getY() - defensePos.getY());
        return defensePos;
    }
}

