/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.buildingplacement;

import bwapi.TilePosition;
import bwapi.Unit;
import bwapi.UnitType;
import bwta.Region;
import com.tyr.BWTAProxy;
import com.tyr.DebugMessages;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.buildingplacement.BuildSiteLocator;
import com.tyr.buildingplacement.SpaceManager;
import com.tyr.unitgroups.PatchWorkers;
import java.util.ArrayList;

public class DepotBuildSite
extends BuildSiteLocator {
    ArrayList<TilePosition> potentialDepots = new ArrayList();
    private int x = 0;

    public void onFrame() {
        TilePosition start;
        if (this.x >= Tyr.game.mapWidth()) {
            return;
        }
        if (!BWTAProxy.initialized) {
            return;
        }
        if (Tyr.bot.workForce.mineralWorkers.size() == 0) {
            return;
        }
        Unit worker = null;
        try {
            if (Tyr.bot.workForce.mineralWorkers.get((int)0).units.size() > 0) {
                worker = ((Agent)Tyr.bot.workForce.mineralWorkers.get((int)0).units.get((int)0)).unit;
            }
            for (PatchWorkers patch : Tyr.bot.workForce.mineralWorkers.get((int)0).patchWorkers) {
                if (worker == null) {
                    if (patch.units.size() <= 0) continue;
                    worker = ((Agent)patch.units.get((int)0)).unit;
                    continue;
                }
                break;
            }
        }
        catch (NullPointerException e) {
            return;
        }
        if ((start = Tyr.self.getStartLocation()) == null) {
            DebugMessages.addMessage("Startlocation is null!");
            return;
        }
        Region startRegion = BWTAProxy.getRegion(start);
        if (startRegion == null) {
            DebugMessages.addMessage("Startregion is null!");
            return;
        }
        int y = 0;
        while (y < Tyr.game.mapHeight()) {
            TilePosition pos = new TilePosition(this.x, y);
            Region depotRegion = BWTAProxy.getRegion(pos);
            if (depotRegion != null && depotRegion.equals(startRegion) && Tyr.bot.spaceManager.canBuildHere(worker, pos, UnitType.Terran_Supply_Depot)) {
                this.potentialDepots.add(pos);
            }
            y += 2;
        }
        this.x += 3;
    }

    @Override
    public TilePosition findPlacement(UnitType building, TilePosition preferredTile, Agent worker) {
        if (building != UnitType.Terran_Supply_Depot && building != UnitType.Terran_Armory && building != UnitType.Terran_Academy) {
            return null;
        }
        if (!BWTAProxy.initialized) {
            return null;
        }
        if (this.potentialDepots.size() == 0) {
            return null;
        }
        if (!Tyr.game.isVisible(Tyr.game.self().getStartLocation())) {
            return null;
        }
        int bestDist = 0;
        TilePosition result = null;
        TilePosition mainExit = Tyr.positionToTile(SpaceManager.getMainExit());
        for (TilePosition pos : this.potentialDepots) {
            int newDist;
            if (!SpaceManager.canBuildHere(worker.unit, pos.getX(), pos.getY(), UnitType.Terran_Supply_Depot) || (newDist = Math.abs(pos.getX() - mainExit.getX()) + Math.abs(pos.getY() - mainExit.getY())) <= bestDist) continue;
            bestDist = newDist;
            result = pos;
        }
        if (result != null) {
            this.potentialDepots.remove(result);
        }
        return result;
    }
}

