/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.buildingplacement;

import bwapi.Color;
import bwapi.Game;
import bwapi.Player;
import bwapi.Position;
import bwapi.Unit;
import bwapi.UnitType;
import com.tyr.BWTAProxy;
import com.tyr.Settings;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.agents.BunkerAgent;
import com.tyr.buildingplacement.BuildCommand;
import com.tyr.buildingplacement.SpaceManager;
import com.tyr.unitgroups.TankDefense;
import java.util.ArrayList;

public class DefensiveStructures {
    public Position defendedPosition;
    private Position defensePos;
    public ArrayList<Unit> defences = new ArrayList();
    public boolean tooFar = false;
    public boolean disabled = false;
    public TankDefense tanks;

    public DefensiveStructures(Position defendedPosition, Position defensePos) {
        this.defendedPosition = defendedPosition;
        this.defensePos = defensePos;
        this.tanks = new TankDefense(Tyr.bot.hobos, defensePos);
        if (BWTAProxy.initialized && Tyr.self != null && defensePos != null) {
            this.tooFar = Tyr.tileToPosition(Tyr.self.getStartLocation()).getDistance(defensePos) > 1200.0;
        }
    }

    public void add(Unit unit) {
        this.defences.add(unit);
    }

    public void onFrame(Game game, Player self, Tyr bot) {
        if (this.tanks.units.size() < Settings.getDefensiveTanks()) {
            bot.homeGroup.addTanks(this.tanks, Settings.getDefensiveTanks() - this.tanks.units.size());
        }
        this.tanks.cleanup();
        this.tanks.onFrame(game, self, bot);
        int i = 0;
        while (i < this.defences.size()) {
            if (this.defences.get(i) == null || this.defences.get(i).getHitPoints() <= 0 || !this.defences.get(i).exists() || this.defences.get(i).getRemoveTimer() != 0) {
                this.defences.remove(i);
                --i;
            }
            ++i;
        }
        for (Unit structure : this.defences) {
            game.drawBoxMap(structure.getTilePosition().getX() * 32, structure.getTilePosition().getY() * 32, structure.getTilePosition().getX() * 32 + structure.getType().tileWidth() * 32, structure.getTilePosition().getY() * 32 + structure.getType().tileHeight() * 32, Color.Orange);
        }
    }

    public int getUnitCount(UnitType type) {
        int count = 0;
        for (Unit unit : this.defences) {
            if (unit.getType() != type) continue;
            ++count;
        }
        for (BuildCommand com : Tyr.bot.buildCommands) {
            if (com.building != type || !(com.position.getDistance(Tyr.positionToTile(this.defensePos)) < 128.0)) continue;
            ++count;
        }
        return count;
    }

    public Position getDefensePos() {
        if (BWTAProxy.initialized && this.defensePos == null) {
            this.defensePos = SpaceManager.getMainExit();
            Position start = Tyr.tileToPosition(Tyr.self.getStartLocation());
            this.defensePos = new Position((this.defensePos.getX() + start.getX()) / 2, (this.defensePos.getY() + start.getY()) / 2);
        }
        return this.defensePos;
    }

    public void disable() {
        this.tanks.disable();
        for (Unit unit : this.defences) {
            if (unit.getType() != UnitType.Terran_Bunker) continue;
            Agent bunker = Tyr.bot.agentMap.get(unit.getID());
            ((BunkerAgent)bunker).disabled = true;
        }
        this.disabled = true;
    }
}

