/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.buildingplacement;

import bwapi.Position;
import bwapi.TilePosition;
import bwapi.UnitType;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.agents.None;
import com.tyr.agents.WorkerAgent;

public class BuildCommand {
    public Agent worker;
    public UnitType building;
    public TilePosition position;
    public boolean fixed;
    public boolean removing = false;

    public BuildCommand(Agent worker, UnitType building, TilePosition position) {
        this.worker = worker;
        this.building = building;
        this.position = position;
        WorkerAgent wa = (WorkerAgent)worker;
        wa.blockedTimer = this.getTimer();
    }

    public BuildCommand(Agent worker, UnitType building, TilePosition position, boolean fixed) {
        this.worker = worker;
        this.building = building;
        this.position = position;
        this.fixed = fixed;
        WorkerAgent wa = (WorkerAgent)worker;
        wa.blockedTimer = this.getTimer();
    }

    public int mineralCost() {
        return this.building.mineralPrice();
    }

    public int gasCost() {
        return this.building.gasPrice();
    }

    public void remove() {
        if (this.removing) {
            return;
        }
        this.removing = true;
        Tyr.bot.reservedMinerals -= this.mineralCost();
        Tyr.bot.reservedGas -= this.gasCost();
        if (!this.worker.isDead()) {
            if (((WorkerAgent)this.worker).blockedTimer == (long)Tyr.game.getFrameCount()) {
                ((WorkerAgent)this.worker).isBlocked = true;
            }
            if (((WorkerAgent)this.worker).isBlocked) {
                this.worker.unit.stop();
            }
            ((WorkerAgent)this.worker).blockedTimer = -1L;
            this.worker.order(new None(this.worker));
        }
    }

    public Position getCenter() {
        Position buildPos = Tyr.tileToPosition(this.position);
        return new Position(buildPos.getX() + this.building.tileWidth() * 16 - 16, buildPos.getY() + this.building.tileHeight() * 16 - 16);
    }

    public long getTimer() {
        return Tyr.game.getFrameCount() + 400 + this.worker.unit.getDistance(Tyr.tileToPosition(this.position)) / 4;
    }
}

