/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.buildingplacement;

import bwapi.TilePosition;
import bwapi.Unit;
import bwapi.UnitType;
import bwta.BaseLocation;
import com.tyr.BWTAProxy;
import com.tyr.EnemyManager;
import com.tyr.EnemyPosition;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.buildingplacement.BuildCommand;
import com.tyr.buildingplacement.BuildSiteLocator;

public class BaseBuildSite
extends BuildSiteLocator {
    private boolean gasOnly;

    public BaseBuildSite(boolean gasOnly) {
        this.gasOnly = gasOnly;
    }

    @Override
    public TilePosition findPlacement(UnitType building, TilePosition preferredTile, Agent worker) {
        if (preferredTile == null) {
            preferredTile = Tyr.game.isVisible(Tyr.self.getStartLocation()) ? Tyr.self.getStartLocation() : (Tyr.bot.workForce.mineralWorkers.size() > 0 ? Tyr.bot.workForce.mineralWorkers.get((int)0).resourceDepot.getTilePosition() : worker.unit.getTilePosition());
        }
        return this.getBuildTile(worker.unit, building, preferredTile);
    }

    public TilePosition getBuildTile(Unit builder, UnitType buildingType, TilePosition aroundTile) {
        if (!buildingType.isResourceDepot()) {
            return null;
        }
        BaseLocation loc = null;
        for (BaseLocation b : Tyr.bot.expands) {
            if (this.gasOnly && b.isMineralOnly() || b.isIsland() || !Tyr.game.canBuildHere(b.getTilePosition(), buildingType, builder, false)) continue;
            boolean enemyBase = false;
            for (EnemyPosition p : EnemyManager.getManager().enemyBuildingMemory) {
                boolean bl = enemyBase = b.getPosition().getDistance(p.pos.getX(), p.pos.getY()) < 256.0;
                if (enemyBase) break;
            }
            if (enemyBase) continue;
            boolean unitsInWay = false;
            for (BuildCommand cmd : Tyr.bot.buildCommands) {
                if (!(cmd.position.getDistance(b.getTilePosition()) <= 1.0)) continue;
                unitsInWay = true;
                break;
            }
            if (unitsInWay) continue;
            if (BWTAProxy.initialized) {
                if (loc != null && !(BWTAProxy.getGroundDistance(aroundTile, b.getTilePosition()) < BWTAProxy.getGroundDistance(aroundTile, loc.getTilePosition()))) continue;
                loc = b;
                continue;
            }
            if (loc != null && !(aroundTile.getDistance(b.getTilePosition()) < aroundTile.getDistance(loc.getTilePosition()))) continue;
            loc = b;
        }
        return loc == null ? null : loc.getTilePosition();
    }
}

