/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.agents;

import bwapi.Color;
import bwapi.Game;
import bwapi.Player;
import bwapi.Position;
import bwapi.TechType;
import bwapi.Unit;
import bwapi.UnitType;
import bwapi.WeaponType;
import com.tyr.BWTAProxy;
import com.tyr.EnemyManager;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.unitgroups.MineralWorkers;
import java.util.ArrayList;
import java.util.List;

public class WraithAgent
extends Agent {
    public int current = -1;
    private Position target = null;
    private int state = 0;
    private static final int AttackState = 0;
    private static final int FleeState = 1;
    private int dir = 1;
    private static ArrayList<Position> orderedExpands;
    private Unit killEnemy;

    public WraithAgent(Unit wraith) {
        super(wraith);
    }

    public void onFrame(Game game, Player self, Tyr bot) {
        if (!BWTAProxy.initialized) {
            return;
        }
        if (this.current == -1) {
            this.current = EnemyManager.getManager().getSelfPos();
        }
        if (orderedExpands == null || orderedExpands.size() == 0) {
            orderedExpands = (ArrayList)EnemyManager.getManager().getOrderedExpands().clone();
            if (bot.suspectedEnemy.size() == 1) {
                orderedExpands.add(bot.suspectedEnemy.get(0).getPosition());
            }
        }
        List<Unit> inRange = game.getUnitsInRadius(this.unit.getPosition(), UnitType.Terran_Wraith.sightRange() * 2);
        Unit closestEnemy = null;
        double closestDistance = UnitType.Terran_Wraith.sightRange() + 100;
        for (Unit enemy : inRange) {
            double dist;
            if (enemy.getPlayer() == self || enemy.getType().airWeapon() == WeaponType.None || !((dist = (double)this.unit.getDistance(enemy)) < closestDistance)) continue;
            closestDistance = dist;
            closestEnemy = enemy;
        }
        if (closestEnemy != null && self.hasResearched(TechType.Cloaking_Field) && !this.unit.isCloaked()) {
            this.unit.useTech(TechType.Cloaking_Field);
            closestEnemy = null;
        }
        if (closestEnemy == null || this.unit.isCloaked()) {
            if (this.state != 0) {
                this.state = 0;
                this.dir *= -1;
                this.current += this.dir;
                if (this.current >= orderedExpands.size()) {
                    this.current = 0;
                }
                if (this.current < 0) {
                    this.current += orderedExpands.size();
                }
            }
            if (this.killEnemy != null && this.killEnemy.getHitPoints() > 0 && this.killEnemy.getRemoveTimer() == 0 && this.killEnemy.exists() && this.killEnemy.getPlayer() != Tyr.game.self()) {
                if (this.unit.isIdle()) {
                    this.attack(this.killEnemy);
                }
                game.drawLineMap(this.unit.getX(), this.unit.getY(), this.killEnemy.getX(), this.killEnemy.getY(), Color.Red);
                return;
            }
            this.killEnemy = null;
            for (Unit enemy : EnemyManager.getEnemyUnits()) {
                if (!enemy.getType().isWorker() || this.distanceSquared(enemy) >= 102400) continue;
                this.killEnemy = enemy;
                this.attack(enemy);
                game.drawLineMap(this.unit.getX(), this.unit.getY(), this.killEnemy.getX(), this.killEnemy.getY(), Color.Red);
                return;
            }
            if (this.unit.isIdle() || this.distanceSquared(this.target) <= 10000) {
                Position newTarget;
                boolean myBase;
                block2: do {
                    this.current += this.dir;
                    if (this.current >= orderedExpands.size()) {
                        this.current = 0;
                    }
                    if (this.current < 0) {
                        this.current += orderedExpands.size();
                    }
                    newTarget = orderedExpands.get(this.current);
                    myBase = false;
                    for (MineralWorkers base : bot.workForce.mineralWorkers) {
                        if (!(base.resourceDepot.getPosition().getDistance(newTarget) <= 128.0)) continue;
                        myBase = true;
                        continue block2;
                    }
                } while (myBase);
                this.target = newTarget;
                this.unit.move(this.target);
            }
        } else {
            this.state = 1;
            Position fleeTarget = this.retreatTarget(closestEnemy.getPosition(), 256.0);
            this.unit.move(fleeTarget);
            game.drawLineMap(closestEnemy.getX(), closestEnemy.getY(), fleeTarget.getX(), fleeTarget.getY(), Color.Red);
        }
    }
}

