/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.agents;

import bwapi.Color;
import bwapi.Game;
import bwapi.Player;
import bwapi.TechType;
import bwapi.Unit;
import com.tyr.EnemyManager;
import com.tyr.EnemyPosition;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.agents.Command;

public class FocusTarget
extends Command {
    private EnemyPosition target;

    public FocusTarget(Agent agent, EnemyPosition target) {
        super(agent);
        this.target = target;
    }

    @Override
    public void execute(Game game, Player self, Tyr bot) {
        this.agent.drawCircle(Color.Red);
        Unit enemy = null;
        for (Unit unit : EnemyManager.getEnemyUnits()) {
            if (unit.getType() != this.target.type || Math.abs(unit.getX() - this.target.pos.getX()) > 10 || Math.abs(unit.getY() - this.target.pos.getY()) > 10) continue;
            enemy = unit;
        }
        if (enemy != null && this.agent.unit.isInWeaponRange(enemy)) {
            if (this.agent.unit.getHitPoints() > this.agent.unit.getType().maxHitPoints() - 10 && !this.agent.unit.isStimmed() && self.hasResearched(TechType.Stim_Packs)) {
                this.agent.unit.useTech(TechType.Stim_Packs);
                return;
            }
            Unit agentTarget = this.agent.unit.getTarget();
            if (agentTarget == null || agentTarget.getID() != enemy.getID()) {
                this.agent.unit.attack(enemy);
            }
            return;
        }
        if (this.agent.unit.getGroundWeaponCooldown() > 1 && this.agent.unit.getAirWeaponCooldown() > 1) {
            this.agent.unit.move(this.target.pos);
        } else if (this.agent.unit.isHoldingPosition() || this.agent.unit.isIdle() || this.agent.unit.getGroundWeaponCooldown() == 1 || this.agent.unit.getAirWeaponCooldown() == 1) {
            Tyr.drawCircle(this.agent.unit.getPosition(), Color.Green, 6);
            this.agent.attack(this.target.pos);
        }
    }

    @Override
    public boolean replace(Command command) {
        if (!command.getClass().equals(FocusTarget.class)) {
            return true;
        }
        FocusTarget atkCom = (FocusTarget)command;
        if (atkCom.target.type != this.target.type) {
            return true;
        }
        if (atkCom.target.pos.getX() != this.target.pos.getX()) {
            return true;
        }
        return atkCom.target.pos.getY() != this.target.pos.getY();
    }
}

