/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.agents;

import bwapi.Color;
import bwapi.Game;
import bwapi.Order;
import bwapi.Player;
import bwapi.Position;
import bwapi.TechType;
import bwapi.Unit;
import bwapi.UnitType;
import com.tyr.DebugMessages;
import com.tyr.EnemyManager;
import com.tyr.EnemyPosition;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.agents.Command;
import com.tyr.unitgroups.ScoutGroup;

public class Attack
extends Command {
    private Position target;
    private static int waitFrame;
    private static int waitingAtCannon;
    private static int waitingAtCannonPrev;
    private boolean moveCloser;
    private Unit closeEnemy = null;
    private int siegeFrame = -1000000;

    public Attack(Agent agent, Position target) {
        super(agent);
        this.target = target;
    }

    public Attack(Agent agent, Position target, boolean moveCloser) {
        super(agent);
        this.target = target;
        this.moveCloser = moveCloser;
    }

    @Override
    public void execute(Game game, Player self, Tyr bot) {
        this.agent.drawCircle(Color.Red);
        if (waitFrame != game.getFrameCount()) {
            waitingAtCannonPrev = waitingAtCannon;
            DebugMessages.addMessage("Waiting at cannon: " + waitingAtCannon);
            waitingAtCannon = 0;
            waitFrame = game.getFrameCount();
        }
        boolean inrange = false;
        boolean proceed = bot.scout.opponentStrategy != ScoutGroup.cannons && waitingAtCannonPrev >= 10 || this.agent.unit.getType() == UnitType.Terran_Siege_Tank_Siege_Mode || this.agent.unit.getType() == UnitType.Terran_Siege_Tank_Tank_Mode;
        int dist = UnitType.Terran_Siege_Tank_Siege_Mode.sightRange() + 64;
        int smallDist = UnitType.Terran_Siege_Tank_Siege_Mode.sightRange() - 32;
        if (bot.scout.opponentStrategy != ScoutGroup.cannons) {
            smallDist += 32;
        }
        for (EnemyPosition enemy : EnemyManager.getManager().enemyDefensiveStructures) {
            if (this.agent.unit.getType() == UnitType.Terran_Battlecruiser) break;
            if (enemy.type != UnitType.Protoss_Photon_Cannon || Math.abs(this.agent.unit.getX() - enemy.pos.getX()) > dist || Math.abs(this.agent.unit.getY() - enemy.pos.getY()) > dist || this.agent.distanceSquared(enemy.pos) > dist * dist) continue;
            inrange = this.agent.distanceSquared(enemy.pos) <= smallDist * smallDist;
            ++waitingAtCannon;
            break;
        }
        if (inrange && !this.agent.unit.isHoldingPosition() && !proceed) {
            this.agent.unit.holdPosition();
        } else if (proceed || !inrange) {
            this.attack();
        } else {
            Tyr.drawCircle(this.agent.unit.getPosition(), Color.Blue, 6);
        }
    }

    private void attack() {
        if (!Agent.isRanged(this.agent.unit)) {
            this.orderAttack(this.target);
            return;
        }
        if (this.agent.unit.getType() == UnitType.Terran_Siege_Tank_Tank_Mode) {
            if (!Tyr.self.hasResearched(TechType.Tank_Siege_Mode)) {
                if (!this.agent.unit.isHoldingPosition()) {
                    this.agent.unit.holdPosition();
                }
                this.agent.drawCircle(Color.Green, 12);
                return;
            }
            int radius = UnitType.Terran_Siege_Tank_Siege_Mode.groundWeapon().maxRange();
            int minRadius = UnitType.Terran_Siege_Tank_Siege_Mode.groundWeapon().minRange();
            if (Tyr.self.hasResearched(TechType.Tank_Siege_Mode)) {
                for (Unit unit : EnemyManager.getEnemyUnits()) {
                    if (unit.getType().isFlyer() || unit.isLifted() || unit.isCloaked() || this.agent.distanceSquared(unit) >= minRadius * minRadius || unit.getType() == UnitType.Protoss_Scarab || Agent.isRanged(unit) && this.agent.unit.getType() != UnitType.Zerg_Lurker) continue;
                    this.stutterstep();
                    return;
                }
            }
            for (Unit unit : EnemyManager.getEnemyUnits()) {
                if (unit.getType().isFlyer() || unit.isLifted() || unit.isCloaked() || this.agent.distanceSquared(unit) <= minRadius * minRadius || unit.getType() == UnitType.Protoss_Scarab || !Agent.isRanged(unit) || this.agent.unit.getType() == UnitType.Zerg_Lurker || this.agent.distanceSquared(unit) > radius * radius) continue;
                Tyr.game.drawLineMap(this.agent.unit.getX(), this.agent.unit.getY(), unit.getX(), unit.getY(), Color.Red);
                this.siegeFrame = Tyr.game.getFrameCount();
                if (Tyr.self.hasResearched(TechType.Tank_Siege_Mode)) {
                    this.agent.unit.siege();
                } else if (this.agent.unit.isMoving() || this.agent.unit.isAttacking()) {
                    this.agent.unit.stop();
                }
                this.agent.drawCircle(Color.Red, 6);
                return;
            }
            if (Tyr.self.hasResearched(TechType.Tank_Siege_Mode)) {
                this.stutterstep();
            }
            return;
        }
        if (this.agent.unit.getType() == UnitType.Terran_Siege_Tank_Siege_Mode) {
            int radius = UnitType.Terran_Siege_Tank_Siege_Mode.groundWeapon().maxRange();
            int minRadius = UnitType.Terran_Siege_Tank_Siege_Mode.groundWeapon().minRange();
            for (Unit unit : EnemyManager.getEnemyUnits()) {
                if (unit.getType().isFlyer() || unit.isLifted() || unit.isCloaked() || this.agent.distanceSquared(unit) >= (minRadius - 96) * (minRadius - 96) || unit.getType() == UnitType.Protoss_Scarab || Agent.isRanged(unit) && this.agent.unit.getType() != UnitType.Zerg_Lurker) continue;
                this.agent.drawCircle(Color.White, 6);
                this.agent.unit.unsiege();
                return;
            }
            for (Unit unit : EnemyManager.getEnemyUnits()) {
                if (unit.getType().isFlyer() || unit.isLifted() || unit.isCloaked() || this.agent.distanceSquared(unit) <= minRadius * minRadius || unit.getType() == UnitType.Protoss_Scarab || !Agent.isRanged(unit) || this.agent.unit.getType() == UnitType.Zerg_Lurker || this.agent.distanceSquared(unit) > radius * radius) continue;
                Tyr.game.drawLineMap(this.agent.unit.getX(), this.agent.unit.getY(), unit.getX(), unit.getY(), Color.Red);
                this.agent.drawCircle(Color.Red, 6);
                Unit currentTarget = this.agent.unit.getTarget();
                this.siegeFrame = Tyr.game.getFrameCount();
                if (this.agent.unit.isIdle() || !this.agent.unit.isAttackFrame() && !this.agent.unit.isAttacking() || currentTarget != null && !Agent.isRanged(currentTarget)) {
                    this.agent.unit.attack(unit);
                }
                return;
            }
            if (Tyr.game.getFrameCount() - this.siegeFrame >= 250) {
                this.agent.drawCircle(Color.White, 6);
                this.agent.unit.unsiege();
            } else {
                this.agent.drawCircle(Color.Green, 6);
            }
            return;
        }
        this.stutterstep();
    }

    public void stutterstep() {
        int distSq;
        boolean enemyInRange = false;
        if (this.closeEnemy != null && this.closeEnemy.getHitPoints() > 0 && this.closeEnemy.getRemoveTimer() == 0 && this.closeEnemy.exists() && this.closeEnemy.getPlayer() != Tyr.game.self() && ((distSq = this.agent.distanceSquared(this.closeEnemy)) < 40000 || this.closeEnemy.getType() != UnitType.Zerg_Overlord && distSq < 1000000)) {
            enemyInRange = true;
        }
        if (!enemyInRange) {
            for (Unit unit : EnemyManager.getEnemyUnits()) {
                int distSq2 = this.agent.distanceSquared(unit);
                if (distSq2 >= 40000 && (unit.getType() == UnitType.Zerg_Overlord || distSq2 >= 1000000)) continue;
                enemyInRange = true;
                this.closeEnemy = unit;
                break;
            }
        }
        if (!enemyInRange) {
            for (Unit unit : Tyr.game.neutral().getUnits()) {
                if (this.agent.distanceSquared(unit) >= 40000 || !unit.getType().isBuilding() || unit.getType().isResourceContainer() || unit.getDistance(Tyr.tileToPosition(Tyr.self.getStartLocation())) >= 1536) continue;
                Tyr.drawCircle(unit.getPosition(), Color.Blue);
                Tyr.game.drawLineMap(unit.getX(), unit.getY(), this.agent.unit.getX(), this.agent.unit.getY(), Color.Red);
                this.agent.attack(unit);
                return;
            }
        }
        if (this.agent.distanceSquared(this.target) <= 16384) {
            return;
        }
        if (this.agent.unit.getGroundWeaponCooldown() > 1 && this.agent.unit.getAirWeaponCooldown() > 1 && Agent.isRanged(this.agent.unit)) {
            int distSq3;
            int minRadius = Math.max(32, this.agent.unit.getType().groundWeapon().maxRange() - 64);
            int maxRadius = this.agent.unit.getType().groundWeapon().maxRange();
            int level = 2;
            if (!this.moveCloser) {
                level = 1;
            }
            if (this.closeEnemy != null && this.closeEnemy.getHitPoints() > 0 && this.closeEnemy.getRemoveTimer() == 0 && this.closeEnemy.exists() && this.closeEnemy.getPlayer() != Tyr.game.self()) {
                distSq3 = this.agent.distanceSquared(this.closeEnemy);
                if (!this.closeEnemy.getType().isBuilding() && !Agent.isRanged(this.closeEnemy) && distSq3 <= maxRadius * maxRadius) {
                    level = 0;
                } else if (!this.closeEnemy.getType().isBuilding() && distSq3 <= minRadius * minRadius) {
                    level = 0;
                } else if (distSq3 <= maxRadius) {
                    level = 1;
                }
            }
            if (level > 0) {
                for (Unit unit : EnemyManager.getEnemyUnits()) {
                    distSq3 = this.agent.distanceSquared(unit);
                    if (!unit.getType().isBuilding() && !Agent.isRanged(unit) && distSq3 <= maxRadius * maxRadius) {
                        this.closeEnemy = unit;
                        level = 0;
                        break;
                    }
                    if (!unit.getType().isBuilding() && distSq3 <= minRadius * minRadius) {
                        this.closeEnemy = unit;
                        level = 0;
                        break;
                    }
                    if (distSq3 > maxRadius) continue;
                    this.closeEnemy = unit;
                    level = 1;
                }
            }
            if (level == 0) {
                this.agent.unit.move(Tyr.tileToPosition(Tyr.game.self().getStartLocation()));
                this.agent.drawCircle(Color.Green, 4);
            } else if (level == 1) {
                this.agent.drawCircle(Color.Yellow, 4);
            } else if (level == 2) {
                this.agent.unit.move(this.target);
                this.agent.drawCircle(Color.Red, 4);
            }
        } else if (this.agent.unit.isHoldingPosition() || this.agent.unit.isIdle() || this.agent.unit.getGroundWeaponCooldown() == 1 || this.agent.unit.getAirWeaponCooldown() == 1) {
            Tyr.drawCircle(this.agent.unit.getPosition(), Color.Green, 6);
            this.agent.attack(this.target);
        } else {
            this.orderAttack(this.target);
        }
    }

    public void orderAttack(Position target) {
        Order order = this.agent.unit.getOrder();
        Position orderTarget = this.agent.unit.getOrderTargetPosition();
        double dist = target.getDistance(orderTarget);
        if (!(order != Order.AttackMove && order != Order.Move && !this.agent.unit.isIdle() || this.agent.unit.getTarget() != null || !Agent.isRanged(this.agent.unit) && this.agent.unit.getGroundWeaponCooldown() != 0 || Math.abs(target.getX() - orderTarget.getX()) < 10 && Math.abs(target.getY() - orderTarget.getY()) < 10 && !(dist >= 10.0) && order != Order.Move)) {
            Tyr.drawCircle(this.agent.unit.getPosition(), Color.White, 6);
            this.agent.attack(target);
        }
    }

    @Override
    public boolean replace(Command command) {
        if (!command.getClass().equals(Attack.class)) {
            return true;
        }
        Attack atkCom = (Attack)command;
        if (atkCom.target == null) {
            return true;
        }
        if (this.target == null) {
            return false;
        }
        atkCom.moveCloser = this.moveCloser;
        if (this.target.getX() == atkCom.target.getX() && this.target.getY() == atkCom.target.getY()) {
            return false;
        }
        atkCom.target = this.target;
        this.attack();
        return false;
    }
}

