/*
 * Decompiled with CFR 0.152.
 */
package com.tyr;

import bwapi.Color;
import bwapi.DefaultBWListener;
import bwapi.Game;
import bwapi.Mirror;
import bwapi.Player;
import bwapi.Position;
import bwapi.Race;
import bwapi.TilePosition;
import bwapi.Unit;
import bwapi.UnitType;
import bwta.BaseLocation;
import com.tyr.BWTAProxy;
import com.tyr.DebugMessages;
import com.tyr.EnemyManager;
import com.tyr.PlayerProfile;
import com.tyr.Scanner;
import com.tyr.Settings;
import com.tyr.StopWatch;
import com.tyr.Strategy;
import com.tyr.StrategyDetector;
import com.tyr.agents.Agent;
import com.tyr.agents.BuildDefensive;
import com.tyr.agents.VultureAgent;
import com.tyr.agents.WorkerAgent;
import com.tyr.buildingplacement.BuildCommand;
import com.tyr.buildingplacement.DefensiveStructures;
import com.tyr.buildingplacement.SpaceManager;
import com.tyr.buildingplacement.WallOff;
import com.tyr.builds.BuildOrder;
import com.tyr.builds.DefensiveTerran;
import com.tyr.builds.ProtossTech;
import com.tyr.builds.StandardZerg;
import com.tyr.builds.TeamMech;
import com.tyr.builds.TvPGeneric;
import com.tyr.builds.ZealotPush;
import com.tyr.tasks.TaskManager;
import com.tyr.unitgroups.BuilderGroup;
import com.tyr.unitgroups.Bunkers;
import com.tyr.unitgroups.ComsatNetwork;
import com.tyr.unitgroups.DefendingWorkers;
import com.tyr.unitgroups.OutOfJob;
import com.tyr.unitgroups.ProductionStructures;
import com.tyr.unitgroups.ScoutGroup;
import com.tyr.unitgroups.StayAtHomeGroup;
import com.tyr.unitgroups.UnderConstruction;
import com.tyr.unitgroups.UnitGroup;
import com.tyr.unitgroups.WorkerGroup;
import com.tyr.unitgroups.WraithSwarm;
import java.util.ArrayList;
import java.util.HashMap;

public class Tyr
extends DefaultBWListener {
    private Mirror mirror = new Mirror();
    public static Game game;
    public static Player self;
    public int reservedMinerals;
    public int reservedGas;
    public ArrayList<BaseLocation> expands;
    public ArrayList<BaseLocation> suspectedEnemy;
    public ArrayList<BuildCommand> buildCommands;
    public ArrayList<DefensiveStructures> defensiveStructures;
    public StayAtHomeGroup homeGroup;
    public ComsatNetwork comsatNetwork;
    public WraithSwarm swarm;
    public Bunkers bunkers;
    public ScoutGroup scout;
    public DefendingWorkers militia;
    public WorkerGroup workForce;
    public BuilderGroup builders;
    public ProductionStructures production;
    public UnderConstruction underConstruction;
    public OutOfJob hobos;
    public ArrayList<UnitGroup> groups;
    public SpaceManager spaceManager;
    public Scanner scanner;
    public WallOff wallOff;
    public TaskManager taskManager;
    public BuildOrder build;
    public static Tyr bot;
    private StopWatch stopWatch = new StopWatch();
    public int wins = 0;
    public int losses = 0;
    public boolean restart = false;
    StrategyDetector strategyDetector = new StrategyDetector();
    public HashMap<Integer, Agent> agentMap = new HashMap();
    long initTime;
    long buildTime;
    long unitGroupsTime;
    long taskManagerTime;
    long agentTime;

    public void run() {
        this.mirror.getModule().setEventListener(this);
        this.mirror.startGame();
    }

    @Override
    public void onStart() {
        BWTAProxy.initialized = false;
        this.expands = new ArrayList();
        this.scanner = null;
        this.spaceManager = null;
        this.suspectedEnemy = new ArrayList();
        this.buildCommands = new ArrayList();
        this.defensiveStructures = new ArrayList();
        this.reservedGas = 0;
        this.reservedMinerals = 0;
        this.groups = new ArrayList();
        EnemyManager.getManager().reset();
        game = this.mirror.getGame();
        self = game.self();
        Strategy.initialize();
        if (!this.restart) {
            BWTAProxy.readMap();
            new BWTAProxy().run();
        } else {
            Scanner.restart = true;
        }
        game.setLocalSpeed(10);
        try {
            this.spaceManager = new SpaceManager();
            this.scanner = new Scanner();
            this.wallOff = null;
            this.taskManager = new TaskManager();
            this.build = game.enemies().size() > 1 ? new TeamMech() : (self.getRace() == Race.Terran ? (game.enemy().getRace() == Race.Zerg ? new DefensiveTerran() : (game.enemy().getRace() == Race.Protoss ? new DefensiveTerran() : (game.enemy().getRace() == Race.Terran ? new DefensiveTerran() : new DefensiveTerran()))) : (self.getRace() == Race.Protoss ? new ZealotPush() : new StandardZerg()));
            int requiredArmySize = -1;
            requiredArmySize = self.getRace() == Race.Zerg ? 5 : (self.getRace() == Race.Protoss ? 15 : (game.enemy().getRace() == Race.Zerg ? 15 : (game.enemy().getRace() == Race.Protoss ? 40 : 30)));
            Settings.setRequiredSize(requiredArmySize);
            int maxArmySize = -1;
            maxArmySize = self.getRace() == Race.Zerg ? 5 : (self.getRace() == Race.Protoss ? 30 : (game.enemy().getRace() == Race.Terran ? 60 : (game.enemy().getRace() == Race.Zerg ? 30 : 60)));
            Settings.setMaximumSize(maxArmySize);
            this.hobos = new OutOfJob();
            this.bunkers = new Bunkers(this.hobos);
            this.underConstruction = new UnderConstruction(this.hobos);
            this.production = new ProductionStructures(this.hobos);
            this.builders = new BuilderGroup(this.hobos);
            this.militia = new DefendingWorkers(this.hobos);
            this.workForce = new WorkerGroup(this.hobos);
            this.homeGroup = new StayAtHomeGroup(this.hobos);
            this.comsatNetwork = new ComsatNetwork(this.hobos);
            this.scout = new ScoutGroup(this.hobos);
            this.swarm = new WraithSwarm(this.hobos);
            this.groups.add(this.hobos);
            this.groups.add(this.bunkers);
            this.groups.add(this.underConstruction);
            this.groups.add(this.production);
            this.groups.add(this.builders);
            this.groups.add(this.militia);
            this.groups.add(this.workForce);
            this.groups.add(this.comsatNetwork);
            this.groups.add(this.scout);
            this.groups.add(this.swarm);
            this.groups.add(this.homeGroup);
            ArrayList<String> records = DebugMessages.readFile();
            for (String s : records) {
                if (s.startsWith("win")) {
                    ++this.wins;
                    continue;
                }
                ++this.losses;
            }
            boolean match = false;
            if (game.enemies().size() == 1) {
                ArrayList<PlayerProfile> profiles = PlayerProfile.getProfiles();
                for (PlayerProfile pp : profiles) {
                    if (!pp.match(game, this)) continue;
                    match = true;
                    break;
                }
            }
            if (!match) {
                Strategy.determine().set();
            }
            this.build.initialize(game, self, bot);
            game.sendText("Good luck, have fun!!! :D");
        }
        catch (Exception e) {
            DebugMessages.addMessagePermanent("Error starting up: " + e.toString());
            e.printStackTrace();
            this.quickStartup();
            throw e;
        }
        this.restart = true;
    }

    public void quickStartup() {
        DebugMessages.addMessagePermanent("Error starting, doing quick startup.");
        System.out.println("Error starting, doing quick startup.");
        this.groups = new ArrayList();
        this.spaceManager = new SpaceManager();
        this.scanner = new Scanner();
        this.wallOff = null;
        this.taskManager = new TaskManager();
        this.build = self.getRace() == Race.Terran ? new TvPGeneric() : (self.getRace() == Race.Protoss ? new ProtossTech() : new StandardZerg());
        Settings.setRequiredSize(20);
        Settings.setMaximumSize(40);
        this.hobos = new OutOfJob();
        this.bunkers = new Bunkers(this.hobos);
        this.underConstruction = new UnderConstruction(this.hobos);
        this.production = new ProductionStructures(this.hobos);
        this.builders = new BuilderGroup(this.hobos);
        this.militia = new DefendingWorkers(this.hobos);
        this.workForce = new WorkerGroup(this.hobos);
        this.homeGroup = new StayAtHomeGroup(this.hobos);
        this.comsatNetwork = new ComsatNetwork(this.hobos);
        this.scout = new ScoutGroup(this.hobos);
        this.swarm = new WraithSwarm(this.hobos);
        this.groups.add(this.hobos);
        this.groups.add(this.bunkers);
        this.groups.add(this.underConstruction);
        this.groups.add(this.production);
        this.groups.add(this.builders);
        this.groups.add(this.militia);
        this.groups.add(this.workForce);
        this.groups.add(this.comsatNetwork);
        this.groups.add(this.scout);
        this.groups.add(this.swarm);
        this.groups.add(this.homeGroup);
        this.build.initialize(game, self, bot);
    }

    public int getAvailableMinerals() {
        return self.minerals() - this.reservedMinerals;
    }

    public int getAvailableGas() {
        return self.gas() - this.reservedGas;
    }

    @Override
    public void onFrame() {
        if (game.isReplay()) {
            return;
        }
        this.stopWatch.start();
        if (BWTAProxy.initialized) {
            Tyr.drawCircle(SpaceManager.getMainExit(), Color.Green, 128);
        }
        for (UnitGroup group : this.groups) {
            group.cleanup();
        }
        int i = 0;
        while (i < this.defensiveStructures.size()) {
            if (this.defensiveStructures.get((int)i).disabled) {
                this.defensiveStructures.remove(i);
                --i;
            }
            ++i;
        }
        i = this.hobos.units.size() - 1;
        while (i >= 0) {
            Agent agent = (Agent)this.hobos.units.get(i);
            if (agent.unit.isCompleted() || agent.unit.getType().isBuilding()) {
                int topPrio = -1;
                UnitGroup taker = null;
                for (UnitGroup group : this.groups) {
                    int myPrio = group.takeAgent(agent);
                    if (myPrio <= topPrio) continue;
                    taker = group;
                    topPrio = myPrio;
                }
                if (taker != null) {
                    taker.add(agent);
                    this.hobos.units.remove(i);
                }
            }
            --i;
        }
        EnemyManager.getManager().updateBuildings();
        this.spaceManager.onFrame(game, self, this);
        this.scanner.onFrame(game, self, this);
        this.strategyDetector.onFrame(game, self, bot);
        this.initTime = this.stopWatch.time();
        this.build.onFrame(game, self, this);
        this.buildTime = this.stopWatch.time();
        for (DefensiveStructures structures : this.defensiveStructures) {
            structures.onFrame(game, self, this);
        }
        for (UnitGroup group : this.groups) {
            group.onFrame(game, self, this);
        }
        this.unitGroupsTime = this.stopWatch.time();
        this.taskManager.onFrame(game, self, bot);
        this.taskManagerTime = this.stopWatch.time();
        for (Unit unit : self.getUnits()) {
            Agent agent = this.agentMap.get(unit.getID());
            agent.getCommand().execute(game, self, bot);
            if (agent.unit.getType().isWorker()) {
                ((WorkerAgent)agent).onFrame(game, self, bot);
                continue;
            }
            if (!(agent instanceof VultureAgent)) continue;
            ((VultureAgent)agent).onFrame(game, self, bot);
        }
        this.agentTime = this.stopWatch.time();
        DebugMessages.addMessage("Available Resources: " + this.getAvailableMinerals() + " - " + this.getAvailableGas());
        DebugMessages.addMessage("Workers: " + (this.workForce.units.size() + this.builders.units.size()));
        if (this.suspectedEnemy.size() != 1) {
            DebugMessages.addMessage("Suspected enemy bases: " + this.suspectedEnemy.size());
        }
        DebugMessages.addMessage("Bases: " + this.workForce.mineralWorkers.size());
        DebugMessages.addMessage("Frame count: " + game.getFrameCount());
        if (!BWTAProxy.initialized) {
            DebugMessages.addMessage("Initializing BWTA.");
        }
        if (this.initTime >= 55L) {
            DebugMessages.addMessage("Initialization Time: " + this.initTime);
        }
        if (this.buildTime >= 55L) {
            DebugMessages.addMessage("Build Time: " + this.buildTime);
        }
        if (this.unitGroupsTime >= 55L) {
            DebugMessages.addMessage("Unit Groups Time: " + this.unitGroupsTime);
        }
        if (this.taskManagerTime >= 55L) {
            DebugMessages.addMessage("Task Manager Time: " + this.taskManagerTime);
        }
        if (this.agentTime >= 55L) {
            DebugMessages.addMessage("Agent Time: " + this.agentTime);
        }
        for (Unit u : self.getUnits()) {
            if (!this.agentMap.get((Object)Integer.valueOf((int)u.getID())).mark) continue;
            this.agentMap.get(u.getID()).drawCircle(Color.Red, 4);
        }
        DebugMessages.toScreen();
        if (game.getFrameCount() <= 300) {
            game.drawTextScreen(230, 210, "Good luck, have fun!!! :D");
        }
    }

    @Override
    public void onUnitCreate(Unit unit) {
        if (unit.getPlayer() != self) {
            return;
        }
        Agent agent = Agent.createAgent(unit);
        this.agentMap.put(unit.getID(), agent);
        this.hobos.add(agent);
        if (unit.getType() == UnitType.Terran_Bunker || unit.getType() == UnitType.Terran_Missile_Turret) {
            DefensiveStructures structures = null;
            for (Unit builder : self.getUnits()) {
                Agent builderAgent;
                if (!builder.getType().isWorker() || builder.getBuildUnit() != unit || (builderAgent = this.agentMap.get(builder.getID())).getCommand() == null || !builderAgent.getCommand().getClass().equals(BuildDefensive.class)) continue;
                structures = ((BuildDefensive)builderAgent.getCommand()).defensePos;
                break;
            }
            if (structures != null) {
                structures.add(unit);
            } else {
                System.out.println("No matching BuildDefensive command found.");
            }
        } else if (unit.getType().isResourceDepot()) {
            this.workForce.newBase(unit);
        }
    }

    @Override
    public void onUnitMorph(Unit unit) {
        if (unit.getType() == UnitType.Terran_Refinery || unit.getType() == UnitType.Protoss_Assimilator || unit.getType() == UnitType.Zerg_Extractor) {
            Agent agent = Agent.createAgent(unit);
            this.agentMap.put(unit.getID(), agent);
            this.hobos.add(agent);
        }
    }

    @Override
    public void onEnd(boolean win) {
        DebugMessages.saveMessage(String.valueOf(win ? "win" : "loss") + " " + this.strategyDetector.opponentStrategy + (Strategy.chosenStrategy == null ? "" : " " + Strategy.chosenStrategy.code));
        Strategy.writeFlags();
    }

    public static void drawCircle(Position position, Color color, int r) {
        if (position != null) {
            game.drawCircleMap(position.getX(), position.getY(), r, color);
        }
    }

    public static void drawCircle(Position position, Color color) {
        Tyr.drawCircle(position, color, 10);
    }

    public static Position tileToPosition(TilePosition pos) {
        return new Position(pos.getX() * 32 + 16, pos.getY() * 32 + 16);
    }

    public static TilePosition positionToTile(Position pos) {
        return new TilePosition(pos.getX() / 32, pos.getY() / 32);
    }

    public static void main(String[] args) {
        bot = new Tyr();
        bot.run();
    }
}

