/*
 * Decompiled with CFR 0.152.
 */
package com.tyr;

import bwapi.Game;
import bwapi.Player;
import bwapi.Race;
import bwapi.Unit;
import bwapi.UnitType;
import com.tyr.EnemyManager;
import com.tyr.EnemyPosition;
import com.tyr.Strategy;
import com.tyr.Tyr;
import com.tyr.unitgroups.ScoutGroup;

public class StrategyDetector {
    public int opponentStrategy = ScoutGroup.unknown;

    /*
     * WARNING - void declaration
     */
    public void onFrame(Game game, Player self, Tyr bot) {
        if (!Strategy.flagSet("DETECT")) {
            for (Unit enemy : EnemyManager.getEnemyUnits()) {
                if (enemy.getType() != UnitType.Protoss_Dark_Templar && enemy.getType() != UnitType.Protoss_Arbiter && enemy.getType() != UnitType.Zerg_Lurker && !enemy.isBurrowed() && enemy.getType() != UnitType.Terran_Ghost && enemy.getType() != UnitType.Terran_Wraith) continue;
                Strategy.addFlag("DETECT");
            }
        }
        if (!Strategy.flagSet("FLYERS")) {
            for (Unit enemy : EnemyManager.getEnemyUnits()) {
                if (!enemy.getType().isFlyer() || !enemy.getType().canAttack()) continue;
                Strategy.addFlag("FLYERS");
            }
        }
        if (game.enemy().getRace() == Race.Protoss && !Strategy.flagSet("NZ")) {
            for (Unit enemy : EnemyManager.getEnemyUnits()) {
                if (!enemy.getType().canAttack() || enemy.getType().isWorker() || enemy.getType() == UnitType.Protoss_Zealot) continue;
                Strategy.addFlag("NZ");
                System.out.println("Non Zealot unit detected!");
            }
        }
        if (game.enemy().getRace() == Race.Zerg && !Strategy.flagSet("NZ")) {
            for (Unit enemy : EnemyManager.getEnemyUnits()) {
                if (!enemy.getType().canAttack() || enemy.getType().isWorker() || enemy.getType() == UnitType.Zerg_Zergling) continue;
                Strategy.addFlag("NZ");
            }
        }
        if (this.opponentStrategy != ScoutGroup.unknown) {
            return;
        }
        if (game.enemy().getRace() == Race.Protoss) {
            void var5_16;
            int nexusCount = 0;
            for (EnemyPosition enemyPosition : EnemyManager.getManager().enemyBuildingMemory) {
                if (enemyPosition.type != UnitType.Protoss_Nexus) continue;
                ++nexusCount;
            }
            if (nexusCount >= 2) {
                this.opponentStrategy = ScoutGroup.tech;
                return;
            }
            for (Unit unit : EnemyManager.getEnemyUnits()) {
                if (unit.getType().gasPrice() <= 0 && unit.getType() != UnitType.Protoss_Assimilator && unit.getType() != UnitType.Protoss_Cybernetics_Core) continue;
                this.opponentStrategy = ScoutGroup.tech;
                return;
            }
            boolean bl = false;
            for (EnemyPosition enemy : EnemyManager.getManager().enemyBuildingMemory) {
                if (enemy.type == UnitType.Protoss_Photon_Cannon || enemy.type == UnitType.Protoss_Forge) {
                    this.opponentStrategy = ScoutGroup.cannons;
                    return;
                }
                if (enemy.type != UnitType.Protoss_Gateway) continue;
                ++var5_16;
            }
            if (var5_16 >= 2) {
                this.opponentStrategy = ScoutGroup.zealotPush;
                return;
            }
        }
        if (game.enemy().getRace() == Race.Terran) {
            for (EnemyPosition enemy : EnemyManager.getManager().enemyBuildingMemory) {
                if (enemy.type != UnitType.Terran_Bunker) continue;
                this.opponentStrategy = ScoutGroup.defensive;
                return;
            }
            int tankCount = 0;
            for (Unit unit : EnemyManager.getEnemyUnits()) {
                if (unit.getType() != UnitType.Terran_Siege_Tank_Siege_Mode && unit.getType() != UnitType.Terran_Siege_Tank_Tank_Mode) continue;
                ++tankCount;
            }
            if (tankCount >= 3) {
                this.opponentStrategy = ScoutGroup.defensive;
                return;
            }
        }
    }
}

