/*
 * Decompiled with CFR 0.152.
 */
package com.tyr;

import bwapi.Race;
import com.tyr.DebugMessages;
import com.tyr.Tyr;
import com.tyr.builds.BBS;
import com.tyr.builds.Bio;
import com.tyr.builds.BuildOrder;
import com.tyr.builds.DefensiveTerran;
import com.tyr.builds.TAntiZealot;
import com.tyr.builds.TFastExpand;
import com.tyr.builds.TvPGeneric;
import com.tyr.tasks.Task;
import com.tyr.unitgroups.ScoutGroup;
import java.util.ArrayList;
import java.util.HashMap;

public class Strategy {
    public String code;
    private BuildOrder counter;
    private int opponentStrategy;
    private int scoutTiming;
    private int nscouts;
    public boolean triggerDebug = false;
    public Task[] tasks;
    public static Strategy chosenStrategy;
    private static ArrayList<String> oldFlags;
    private static ArrayList<String> newFlags;
    private static boolean lost;
    private static ArrayList<String> file;

    static {
        oldFlags = new ArrayList();
        newFlags = new ArrayList();
        lost = false;
    }

    public Strategy(String code, BuildOrder counter) {
        this(code, counter, ScoutGroup.unknown);
    }

    public Strategy(String code, BuildOrder counter, int opponentStrategy) {
        this(code, counter, opponentStrategy, -1, 0, new Task[0]);
    }

    public Strategy(String code, BuildOrder counter, int opponentStrategy, Task[] tasks) {
        this(code, counter, opponentStrategy, -1, 0, tasks);
    }

    public Strategy(String code, BuildOrder counter, int opponentStrategy, int scoutTiming, int nscouts, Task[] tasks) {
        this.code = code;
        this.counter = counter;
        this.opponentStrategy = opponentStrategy;
        this.scoutTiming = scoutTiming;
        this.nscouts = nscouts;
        this.tasks = tasks;
    }

    public static Strategy determine() {
        Strategy[] strategies = Strategy.determineStrategies();
        return Strategy.pickStrategy(strategies);
    }

    public static void initialize() {
        file = DebugMessages.readFile();
        Strategy.getFlags();
    }

    public static Strategy pickStrategy(Strategy[] strategies) {
        HashMap losses = new HashMap();
        HashMap<String, Integer> wins = new HashMap<String, Integer>();
        for (String line : file) {
            HashMap<String, Integer> map;
            boolean win = false;
            String[] words = line.split(" ");
            String code = "";
            String[] stringArray = words;
            int n = words.length;
            int n2 = 0;
            while (n2 < n) {
                String word = stringArray[n2];
                if (word.equals("win")) {
                    win = true;
                }
                Strategy[] strategyArray = strategies;
                int n3 = strategies.length;
                int n4 = 0;
                while (n4 < n3) {
                    Strategy strat = strategyArray[n4];
                    if (strat.code.equals(word)) {
                        code = word;
                    }
                    ++n4;
                }
                ++n2;
            }
            HashMap<String, Integer> hashMap = map = win ? wins : losses;
            if (!map.containsKey(code)) {
                map.put(code, 0);
            }
            map.put(code, (Integer)map.get(code) + 1);
        }
        Strategy choice = null;
        int score = Integer.MIN_VALUE;
        Strategy[] strategyArray = strategies;
        int n = strategies.length;
        int n5 = 0;
        while (n5 < n) {
            Strategy strat = strategyArray[n5];
            int newScore = 0;
            if (losses.containsKey(strat.code)) {
                newScore -= ((Integer)losses.get(strat.code)).intValue();
            }
            if (wins.containsKey(strat.code)) {
                newScore += (Integer)wins.get(strat.code) / 4;
            }
            System.out.println("score with " + strat.code + ": " + newScore);
            if (newScore > score) {
                score = newScore;
                choice = strat;
            }
            ++n5;
        }
        return choice;
    }

    private static Strategy[] determineStrategies() {
        if (!Strategy.flagSet("NZ") && lost) {
            if (Tyr.game.enemy().getRace() == Race.Protoss) {
                System.out.println("Countering zealots.");
                return new Strategy[]{new Strategy("ANTIZ", new TvPGeneric(), ScoutGroup.zealotPush), new Strategy("VPUSH", new TAntiZealot(true), ScoutGroup.zealotPush)};
            }
            if (Tyr.game.enemy().getRace() == Race.Zerg) {
                return new Strategy[]{new Strategy("ANTIZ", new Bio(Bio.DEFENSIVE))};
            }
        }
        if (Tyr.game.enemy().getRace() == Race.Protoss) {
            return new Strategy[]{new Strategy("TvP", new TvPGeneric()), new Strategy("MPUSH", new TAntiZealot(true, false, true, true)), new Strategy("FE", new TFastExpand(new TvPGeneric())), new Strategy("BBS", new BBS())};
        }
        if (Tyr.game.enemy().getRace() == Race.Terran) {
            return new Strategy[]{new Strategy("TvP", new TvPGeneric()), new Strategy("MPUSH", new TAntiZealot(true, false, true, true)), new Strategy("FE", new TFastExpand(new TvPGeneric())), new Strategy("BBS", new BBS())};
        }
        if (Tyr.game.enemy().getRace() == Race.Zerg) {
            return new Strategy[]{new Strategy("BIODEF", new Bio(Bio.DEFENSIVE)), new Strategy("BIOFE", new Bio(Bio.GREEDY)), new Strategy("BBS", new BBS())};
        }
        return new Strategy[]{new Strategy("DEF", new DefensiveTerran())};
    }

    public static void getFlags() {
        for (String line : file) {
            String[] words;
            if (line.startsWith("flag:")) {
                System.out.println("flag read: " + line.substring(5));
                oldFlags.add(line.substring(5));
                continue;
            }
            String[] stringArray = words = line.split(" ");
            int n = words.length;
            int n2 = 0;
            while (n2 < n) {
                String word = stringArray[n2];
                if (word.equals("loss")) {
                    lost = true;
                }
                ++n2;
            }
        }
    }

    public static boolean flagSet(String flag) {
        return oldFlags.contains(flag) || newFlags.contains(flag);
    }

    public static void addFlag(String flag) {
        if (!Strategy.flagSet(flag)) {
            System.out.println("flag set: " + flag);
            newFlags.add(flag);
        }
    }

    public static void writeFlags() {
        for (String flag : newFlags) {
            System.out.println("storing flag: " + flag);
            DebugMessages.saveMessage("flag:" + flag);
            oldFlags.add(flag);
        }
        newFlags = new ArrayList();
    }

    public void set() {
        chosenStrategy = this;
        Tyr.bot.build = this.counter;
        Tyr.bot.scout.opponentStrategy = this.opponentStrategy;
        if (this.nscouts != 0) {
            Tyr.bot.scout.nscouts = this.nscouts;
            Tyr.bot.scout.workerScoutTiming = this.scoutTiming;
        }
        Task[] taskArray = this.tasks;
        int n = this.tasks.length;
        int n2 = 0;
        while (n2 < n) {
            Task task = taskArray[n2];
            Tyr.bot.taskManager.potentialTasks.add(task);
            ++n2;
        }
    }
}

