/*
 * Decompiled with CFR 0.152.
 */
package com.tyr;

import bwapi.Game;
import bwapi.Player;
import bwapi.Race;
import bwapi.UnitType;
import com.tyr.Settings;
import com.tyr.Strategy;
import com.tyr.Tyr;
import com.tyr.builds.AntiIron;
import com.tyr.builds.AntiKill;
import com.tyr.builds.AntiMoo;
import com.tyr.builds.AntiMutaMech;
import com.tyr.builds.AntiWorkerRush;
import com.tyr.builds.BBS;
import com.tyr.builds.Bio;
import com.tyr.builds.BuildOrder;
import com.tyr.builds.DefensiveMech;
import com.tyr.builds.DefensiveTerran;
import com.tyr.builds.Mech;
import com.tyr.builds.OneBaseMech;
import com.tyr.builds.OneBaseTank;
import com.tyr.builds.TAntiZealot;
import com.tyr.builds.TFastExpand;
import com.tyr.builds.TankContain;
import com.tyr.builds.TvP;
import com.tyr.builds.TvPGeneric;
import com.tyr.builds.TwoBaseMech;
import com.tyr.tasks.PokeTask;
import com.tyr.tasks.SalesmenMarinesTask;
import com.tyr.tasks.SiegeNaturalTask;
import com.tyr.tasks.Task;
import com.tyr.unitgroups.ScoutGroup;
import java.util.ArrayList;

public class PlayerProfile {
    private Race race;
    private String[][] names;
    private Strategy[] strategies;
    private BuildOrder counter;
    private int opponentStrategy;
    private int scoutTiming;
    private int nscouts;
    public boolean triggerDebug = false;
    public Task[] tasks;

    public PlayerProfile(Race race, BuildOrder counter, String name) {
        this(race, counter, (String[][])new String[][]{{name}});
    }

    public PlayerProfile(Race race, BuildOrder counter, String[][] names) {
        this(race, counter, names, ScoutGroup.unknown);
    }

    public PlayerProfile(Race race, Strategy[] strategies, String name) {
        this(race, strategies, (String[][])new String[][]{{name}});
    }

    public PlayerProfile(Race race, Strategy[] strategies, String[][] names) {
        this.race = race;
        this.strategies = strategies;
        this.names = names;
    }

    public PlayerProfile(Race race, BuildOrder counter, String[][] names, int opponentStrategy) {
        this(race, counter, names, opponentStrategy, -1, 0, new Task[0]);
    }

    public PlayerProfile(Race race, BuildOrder counter, String[][] names, int opponentStrategy, Task[] tasks) {
        this(race, counter, names, opponentStrategy, -1, 0, tasks);
    }

    public PlayerProfile(Race race, BuildOrder counter, String[][] names, int opponentStrategy, int scoutTiming, int nscouts, Task[] tasks) {
        this.race = race;
        this.names = names;
        this.counter = counter;
        int i = 0;
        while (i < names.length) {
            int j = 0;
            while (j < names[i].length) {
                names[i][j] = names[i][j].toLowerCase();
                ++j;
            }
            ++i;
        }
        this.opponentStrategy = opponentStrategy;
        this.scoutTiming = scoutTiming;
        this.nscouts = nscouts;
        this.tasks = tasks;
    }

    public boolean match(Game game, Tyr bot) {
        Player enemy = game.enemy();
        if (enemy.getRace() != this.race) {
            return false;
        }
        String nameLower = enemy.getName().toLowerCase();
        String[][] stringArray = this.names;
        int n = this.names.length;
        int n2 = 0;
        while (n2 < n) {
            String[] name = stringArray[n2];
            boolean matches = true;
            Object[] objectArray = name;
            int n3 = name.length;
            int n4 = 0;
            while (n4 < n3) {
                String namePart = objectArray[n4];
                if (!nameLower.contains(namePart)) {
                    matches = false;
                    break;
                }
                ++n4;
            }
            if (this.triggerDebug) {
                matches = true;
            }
            if (matches) {
                if (this.strategies != null) {
                    Strategy.pickStrategy(this.strategies).set();
                    return true;
                }
                bot.build = this.counter;
                bot.scout.opponentStrategy = this.opponentStrategy;
                if (this.nscouts != 0) {
                    bot.scout.nscouts = this.nscouts;
                    bot.scout.workerScoutTiming = this.scoutTiming;
                }
                objectArray = this.tasks;
                n3 = this.tasks.length;
                n4 = 0;
                while (n4 < n3) {
                    Object task = objectArray[n4];
                    Tyr.bot.taskManager.potentialTasks.add((Task)task);
                    ++n4;
                }
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static ArrayList<PlayerProfile> getProfiles() {
        ArrayList<PlayerProfile> result = new ArrayList<PlayerProfile>();
        result.add(new PlayerProfile(Race.Terran, (BuildOrder)new TFastExpand(new DefensiveMech()), (String[][])new String[][]{{"Igor", "Lacik"}}));
        result.add(new PlayerProfile(Race.Terran, (BuildOrder)new TFastExpand(new Mech(true)), (String[][])new String[][]{{"Marek", "Kadek"}}));
        result.add(new PlayerProfile(Race.Terran, new TFastExpand(new DefensiveMech(true)), new String[][]{{"Henri", "Kumpulainen"}}, ScoutGroup.unknown, new Task[]{new SalesmenMarinesTask()}));
        result.add(new PlayerProfile(Race.Terran, (BuildOrder)new TFastExpand(new Mech(true)), (String[][])new String[][]{{"Rafal", "Poniatowski"}}));
        if (Settings.getDebug() || Settings.getTournament()) {
            result.add(new PlayerProfile(Race.Terran, new Strategy[]{new Strategy("BBS", new BBS()), new Strategy("MPUSH", new TAntiZealot(true, false, true, true))}, (String[][])new String[][]{{"tscmoo"}}));
        } else {
            result.add(new PlayerProfile(Race.Terran, new AntiMoo(), new String[][]{{"tscmoo"}}, ScoutGroup.unknown));
        }
        result.add(new PlayerProfile(Race.Terran, (BuildOrder)new BBS(), (String[][])new String[][]{{"ICE"}}));
        result.add(new PlayerProfile(Race.Terran, new Strategy[]{new Strategy("BBS", new BBS()), new Strategy("TvP", new TvPGeneric())}, (String[][])new String[][]{{"leta"}, {"Martin", "Rooijackers"}}));
        result.add(new PlayerProfile(Race.Terran, new Strategy[]{new Strategy("BBS", new BBS()), new Strategy("VPUSH", new TAntiZealot(true, false, true, true))}, (String[][])new String[][]{{"Krasi"}}));
        result.add(new PlayerProfile(Race.Terran, new DefensiveMech(true, false, false), new String[][]{{"TerranUAB"}}, ScoutGroup.unknown));
        result.add(new PlayerProfile(Race.Terran, new DefensiveMech(), new String[][]{{"Oritaka"}}, ScoutGroup.unknown));
        result.add(new PlayerProfile(Race.Terran, new DefensiveMech(), new String[][]{{"Yarmouk"}}, ScoutGroup.unknown));
        result.add(new PlayerProfile(Race.Terran, new TFastExpand(new DefensiveMech(1, false, false, true)), new String[][]{{"Radim", "Bobek"}}, ScoutGroup.unknown));
        result.add(new PlayerProfile(Race.Terran, new AntiWorkerRush(), new String[][]{{"Stone"}}, ScoutGroup.unknown));
        if (Settings.getDebug() || Settings.getTournament()) {
            result.add(new PlayerProfile(Race.Terran, new Strategy[]{new Strategy("DROP", new AntiIron()), new Strategy("MPUSH", new TAntiZealot(true, false, true, true))}, (String[][])new String[][]{{"Iron"}, {"Igor", "Dimitrijevic"}}));
        } else {
            result.add(new PlayerProfile(Race.Terran, new BBS(), new String[][]{{"Iron"}, {"Igor", "Dimitrijevic"}}, ScoutGroup.unknown));
        }
        result.add(new PlayerProfile(Race.Terran, (BuildOrder)new BBS(), (String[][])new String[][]{{"Soeren", "Klett"}, {"Soren", "Klett"}, {"S\u00f6ren", "Klett"}, {"W.O.P.R."}, {"WOPR"}}));
        result.add(new PlayerProfile(Race.Protoss, (BuildOrder)new TwoBaseMech(), (String[][])new String[][]{{"Aiur"}, {"Florian", "Richoux"}}));
        result.add(new PlayerProfile(Race.Protoss, (BuildOrder)new DefensiveTerran(), (String[][])new String[][]{{"humanTest"}}));
        result.add(new PlayerProfile(Race.Protoss, (BuildOrder)new TwoBaseMech(), (String[][])new String[][]{{"Vladimir", "Jurenka"}}));
        result.add(new PlayerProfile(Race.Protoss, (BuildOrder)new TwoBaseMech(), (String[][])new String[][]{{"Roman", "Danielis"}}));
        result.add(new PlayerProfile(Race.Protoss, (BuildOrder)new TFastExpand(new DefensiveMech(true)), (String[][])new String[][]{{"Skynet"}, {"Andrew", "Smith"}}));
        result.add(new PlayerProfile(Race.Protoss, new Strategy[]{new Strategy("MPUSH", new TAntiZealot(true, false, true, true)), new Strategy("FE", new TFastExpand(new TvPGeneric()))}, (String[][])new String[][]{{"Tomas", "Cere"}}));
        result.add(new PlayerProfile(Race.Protoss, (BuildOrder)new OneBaseMech(), (String[][])new String[][]{{"Xelnaga"}}));
        result.add(new PlayerProfile(Race.Protoss, (BuildOrder)new DefensiveMech(), (String[][])new String[][]{{"Susanoo"}}));
        if (Settings.getDebug() || Settings.getTournament()) {
            result.add(new PlayerProfile(Race.Protoss, new Strategy[]{new Strategy("TC", new TankContain()), new Strategy("MPUSH", new TAntiZealot(true, false, true, true))}, (String[][])new String[][]{{"tscmoo"}}));
        } else {
            result.add(new PlayerProfile(Race.Protoss, new AntiMoo(), new String[][]{{"tscmoo"}}, ScoutGroup.unknown));
        }
        result.add(new PlayerProfile(Race.Protoss, (BuildOrder)new DefensiveTerran(), (String[][])new String[][]{{"Tomas", "Vajda"}, {"Thomas", "Vajda"}, {"XIMP"}}));
        result.add(new PlayerProfile(Race.Protoss, new TvP(), new String[][]{{"Jakub", "Trancik"}}, ScoutGroup.cannons));
        if (Settings.getTournament() || Settings.getDebug()) {
            result.add(new PlayerProfile(Race.Zerg, new Strategy[]{new Strategy("BIO", new TFastExpand(new Bio(Bio.GREEDY, 201, true, false, 4)), ScoutGroup.unknown, new Task[]{new SalesmenMarinesTask(UnitType.Terran_Marine, 25, 8, true, 0), new PokeTask()}), new Strategy("MECH", new AntiMutaMech())}, (String[][])new String[][]{{"tscmoo"}}));
        }
        result.add(new PlayerProfile(Race.Zerg, new AntiKill(false), new String[][]{{"Marian", "Devecka"}, {"Killer"}}, ScoutGroup.unknown));
        result.add(new PlayerProfile(Race.Zerg, new Bio(Bio.GREEDY), new String[][]{{"Zia"}}, ScoutGroup.unknown));
        result.add(new PlayerProfile(Race.Zerg, new Bio(Bio.DEFENSIVE, 25, true, false, 0), new String[][]{{"Overkill"}, {"Sijia", "Xu"}}, ScoutGroup.unknown));
        result.add(new PlayerProfile(Race.Zerg, new TFastExpand(new Bio(Bio.DEFENSIVE, 205, 205)), new String[][]{{"Garm"}, {"Aurelien", "Lermant"}}, ScoutGroup.unknown, new Task[]{new SalesmenMarinesTask(UnitType.Terran_Marine)}));
        result.add(new PlayerProfile(Race.Zerg, new Bio(Bio.GREEDY), new String[][]{{"Cimex"}}, ScoutGroup.unknown));
        result.add(new PlayerProfile(Race.Unknown, new OneBaseTank(), new String[][]{{"UAlberta"}, {"Dave", "Churchill"}, {"David", "Churchill"}}, ScoutGroup.unknown, new Task[]{new SiegeNaturalTask()}));
        if (Settings.getTournament() || Settings.getDebug()) {
            result.add(new PlayerProfile(Race.Unknown, (BuildOrder)new TAntiZealot(true, false, true, true), (String[][])new String[][]{{"Travis", "Shelton"}}));
        } else {
            result.add(new PlayerProfile(Race.Unknown, (BuildOrder)new DefensiveTerran(), (String[][])new String[][]{{"Travis", "Shelton"}}));
        }
        result.add(new PlayerProfile(Race.Unknown, (BuildOrder)new AntiKill(true), (String[][])new String[][]{{"Opprimo"}}));
        return result;
    }

    protected static void debug(ArrayList<PlayerProfile> result) {
        if (Settings.getDebug()) {
            result.get((int)(result.size() - 1)).triggerDebug = true;
        }
    }
}

