/*
 * Decompiled with CFR 0.152.
 */
package com.tyr;

import bwapi.Color;
import bwapi.Player;
import bwapi.Position;
import bwapi.Unit;
import bwapi.UnitType;
import bwapi.WeaponType;
import bwta.BaseLocation;
import com.tyr.BWTAProxy;
import com.tyr.EnemyPosition;
import com.tyr.Settings;
import com.tyr.Tyr;
import com.tyr.buildingplacement.DefensiveStructures;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class EnemyManager {
    private static EnemyManager manager;
    private ArrayList<Position> orderedExpands;
    private int selfPos = -1;
    private Unit invader;
    private Unit flyingInvader;
    private int invaderCount;
    private int invaderUpdatedFrame;
    public HashSet<EnemyPosition> enemyBuildingMemory = new HashSet();
    public HashSet<EnemyPosition> neutralBuildingMemory = new HashSet();
    public ArrayList<EnemyPosition> enemyDefensiveStructures;
    private static int enemyUnitsUpdatedFrame;
    private static ArrayList<Unit> enemyUnits;
    private boolean isInvaderWorker;

    static {
        enemyUnitsUpdatedFrame = -1;
        enemyUnits = new ArrayList();
    }

    public static EnemyManager getManager() {
        if (manager == null) {
            manager = new EnemyManager();
        }
        return manager;
    }

    public ArrayList<Position> getOrderedExpands() {
        if (this.orderedExpands == null) {
            this.initializeOrderedExpands();
        }
        return this.orderedExpands;
    }

    public int getSelfPos() {
        if (this.orderedExpands == null) {
            this.initializeOrderedExpands();
        }
        return this.selfPos;
    }

    private void initializeOrderedExpands() {
        if (!BWTAProxy.initialized) {
            return;
        }
        Tyr bot = Tyr.bot;
        if (bot.suspectedEnemy.size() != 1) {
            return;
        }
        this.orderedExpands = new ArrayList();
        ArrayList<Position> positions = new ArrayList<Position>();
        HashMap<Position, Double> projection = new HashMap<Position, Double>();
        for (BaseLocation b : bot.expands) {
            if (b.getPosition().getDistance(Tyr.tileToPosition(Tyr.self.getStartLocation())) <= 100.0) continue;
            positions.add(b.getPosition());
            projection.put(b.getPosition(), this.projectToBorder(b.getPosition()));
        }
        double selfProjection = this.projectToBorder(Tyr.tileToPosition(Tyr.self.getStartLocation()));
        double enemyProjection = this.projectToBorder(bot.suspectedEnemy.get(0).getPosition());
        positions.add(bot.suspectedEnemy.get(0).getPosition());
        projection.put(bot.suspectedEnemy.get(0).getPosition(), enemyProjection);
        positions.add(Tyr.tileToPosition(Tyr.self.getStartLocation()));
        projection.put(Tyr.tileToPosition(Tyr.self.getStartLocation()), selfProjection);
        boolean changes = true;
        while (changes) {
            changes = false;
            int i = 0;
            while (i < positions.size() - 1) {
                double p1 = (Double)projection.get(positions.get(i));
                double p2 = (Double)projection.get(positions.get(i + 1));
                if ((!(p1 > selfProjection) || !(p2 < selfProjection)) && (p2 > selfProjection && p1 < selfProjection || (Double)projection.get(positions.get(i)) > (Double)projection.get(positions.get(i + 1)))) {
                    Position temp = (Position)positions.get(i);
                    positions.set(i, (Position)positions.get(i + 1));
                    positions.set(i + 1, temp);
                    changes = true;
                }
                ++i;
            }
        }
        int pos = 0;
        while (pos < positions.size() && (Double)projection.get(positions.get(pos)) != enemyProjection) {
            ++pos;
        }
        int enemyPos = pos++;
        while (pos < positions.size()) {
            this.orderedExpands.add((Position)positions.get(pos));
            ++pos;
        }
        pos = 0;
        while (pos < enemyPos) {
            this.orderedExpands.add((Position)positions.get(pos));
            ++pos;
        }
        pos = 0;
        while (pos < this.orderedExpands.size()) {
            if (this.orderedExpands.get(pos).getDistance(Tyr.tileToPosition(Tyr.self.getStartLocation())) <= 100.0) {
                this.selfPos = pos;
                break;
            }
            ++pos;
        }
    }

    private double projectToBorder(Position p) {
        int width = Tyr.game.mapWidth() * 32;
        int height = Tyr.game.mapHeight() * 32;
        int xd1 = p.getX();
        int xd2 = width - p.getX();
        int yd1 = p.getY();
        int yd2 = height - p.getY();
        if (Math.min(xd1, xd2) < Math.min(yd1, yd2)) {
            if (xd1 < xd2) {
                return 0.5 + (double)yd1 / 4.0 / (double)height;
            }
            return (double)yd2 / 4.0 / (double)height;
        }
        if (yd1 < yd2) {
            return 0.25 + (double)xd2 / 4.0 / (double)width;
        }
        return 0.75 + (double)xd1 / 4.0 / (double)width;
    }

    public Unit getInvader() {
        this.updateInvader();
        return this.invader;
    }

    public Unit getFlyingInvader() {
        this.updateInvader();
        return this.flyingInvader;
    }

    public int getInvaderCount() {
        this.updateInvader();
        return this.invaderCount;
    }

    public boolean isInvaderWorker() {
        this.updateInvader();
        return this.isInvaderWorker;
    }

    private void updateInvader() {
        int frame = Tyr.game.getFrameCount();
        if (this.invaderUpdatedFrame == frame) {
            return;
        }
        this.invaderUpdatedFrame = frame;
        this.isInvaderWorker = true;
        this.invaderCount = 0;
        this.invader = null;
        this.flyingInvader = null;
        Position start = Tyr.tileToPosition(Tyr.self.getStartLocation());
        Tyr.drawCircle(start, Color.Cyan, Settings.getLargeInvasionDist());
        Tyr.drawCircle(start, Color.Cyan, Settings.getDefendExpandDist());
        for (Unit u : EnemyManager.getEnemyUnits()) {
            if (u.getType() == UnitType.Protoss_Observer || u.isCloaked() && !u.isDetected()) continue;
            double uDist = u.getDistance(start.getX(), start.getY());
            if (!Settings.getDefendStart() || !(uDist <= (double)Settings.getLargeInvasionDist())) continue;
            if (!u.getType().isWorker()) {
                this.isInvaderWorker = false;
            }
            if (u.getType().isFlyer()) {
                if (this.flyingInvader == null || uDist < this.flyingInvader.getDistance(start.getX(), start.getY())) {
                    this.flyingInvader = u;
                }
            } else if (this.invader == null) {
                this.invader = u;
            } else if (this.invader.getType().isWorker() && !u.getType().isWorker()) {
                this.invader = u;
            } else if (uDist < this.invader.getDistance(start.getX(), start.getY())) {
                this.invader = u;
            }
            ++this.invaderCount;
        }
        if (this.invaderCount == 0) {
            ArrayList<Position> needsDefending = new ArrayList<Position>();
            for (DefensiveStructures structures : Tyr.bot.defensiveStructures) {
                double distance;
                if (structures.disabled || !Settings.getDefendStart() && structures.defendedPosition.getDistance(Tyr.tileToPosition(Tyr.self.getStartLocation())) <= 100.0 || !((distance = structures.defendedPosition.getDistance(start)) < (double)Settings.getDefendExpandDist()) || !(distance > (double)(Settings.getLargeInvasionDist() - Settings.getSmallInvasionDist()))) continue;
                needsDefending.add(structures.defendedPosition);
                Tyr.drawCircle(structures.defendedPosition, Color.Cyan, Settings.getSmallInvasionDist());
            }
            for (Unit u : EnemyManager.getEnemyUnits()) {
                if (u.getType() == UnitType.Protoss_Observer || u.isCloaked() && !u.isDetected()) continue;
                for (Position defendedPos : needsDefending) {
                    double uDist = u.getDistance(defendedPos.getX(), defendedPos.getY());
                    if (!(uDist <= (double)Settings.getSmallInvasionDist())) continue;
                    double mainDist = u.getDistance(start);
                    if (u.getType().isFlyer()) {
                        if (this.flyingInvader == null || mainDist < (double)this.flyingInvader.getDistance(start)) {
                            this.flyingInvader = u;
                        }
                    } else if (this.invader == null || mainDist < (double)this.invader.getDistance(start)) {
                        this.invader = u;
                    }
                    ++this.invaderCount;
                }
            }
        }
        if (this.invader != null) {
            Tyr.drawCircle(this.invader.getPosition(), Color.Red);
        }
        if (this.flyingInvader != null) {
            Tyr.drawCircle(this.flyingInvader.getPosition(), Color.Blue);
        }
    }

    public void updateBuildings() {
        EnemyPosition enemyPos;
        ArrayList<EnemyPosition> removePositions = new ArrayList<EnemyPosition>();
        for (EnemyPosition p : this.enemyBuildingMemory) {
            if (Tyr.game.isVisible(p.pos.getX() / 32, p.pos.getY() / 32)) {
                removePositions.add(p);
                continue;
            }
            Tyr.drawCircle(p.pos, Color.Orange);
        }
        for (EnemyPosition p : removePositions) {
            this.enemyBuildingMemory.remove(p);
        }
        this.enemyDefensiveStructures = new ArrayList();
        for (Unit u : EnemyManager.getEnemyUnits()) {
            if (!u.getType().isBuilding() || u.isLifted() || this.enemyBuildingMemory.contains(enemyPos = new EnemyPosition(u.getType(), u.getPosition(), u.isCompleted()))) continue;
            this.enemyBuildingMemory.add(enemyPos);
            if (enemyPos.type != UnitType.Protoss_Photon_Cannon && enemyPos.type != UnitType.Zerg_Sunken_Colony) continue;
            this.enemyDefensiveStructures.add(enemyPos);
            Tyr.drawCircle(enemyPos.pos, Color.Red, WeaponType.Phase_Disruptor_Cannon.maxRange());
        }
        for (EnemyPosition enemyPos2 : this.enemyBuildingMemory) {
            Tyr.drawCircle(enemyPos2.pos, Color.Red);
        }
        removePositions = new ArrayList();
        for (EnemyPosition p : this.neutralBuildingMemory) {
            if (Tyr.game.isVisible(p.pos.getX() / 32, p.pos.getY() / 32)) {
                removePositions.add(p);
                continue;
            }
            Tyr.drawCircle(p.pos, Color.Teal);
        }
        for (EnemyPosition p : removePositions) {
            this.neutralBuildingMemory.remove(p);
        }
        for (Unit u : Tyr.game.getNeutralUnits()) {
            if (u.getType().canMove() || this.neutralBuildingMemory.contains(enemyPos = new EnemyPosition(u.getType(), u.getPosition(), u.isCompleted()))) continue;
            this.neutralBuildingMemory.add(enemyPos);
        }
        for (EnemyPosition enemyPos2 : this.neutralBuildingMemory) {
            Tyr.drawCircle(enemyPos2.pos, Color.Teal);
        }
    }

    public static ArrayList<Unit> getEnemyUnits() {
        int frame = Tyr.game.getFrameCount();
        if (frame > enemyUnitsUpdatedFrame) {
            enemyUnitsUpdatedFrame = frame;
            enemyUnits = new ArrayList();
            for (Player enemy : Tyr.game.enemies()) {
                for (Unit unit : enemy.getUnits()) {
                    if (unit.getType() == UnitType.Unknown) continue;
                    enemyUnits.add(unit);
                }
            }
        }
        return enemyUnits;
    }

    public void reset() {
        this.orderedExpands = null;
        this.selfPos = -1;
        this.enemyBuildingMemory = new HashSet();
        this.enemyDefensiveStructures = new ArrayList();
        this.invaderUpdatedFrame = 0;
    }
}

