/*
 * Decompiled with CFR 0.152.
 */
package bwapi;

import bwapi.Force;
import bwapi.Player;
import bwapi.PlayerType;
import bwapi.Race;
import bwapi.TechType;
import bwapi.TilePosition;
import bwapi.Unit;
import bwapi.UnitType;
import bwapi.UpgradeType;
import bwapi.WeaponType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PlayerImpl {
    private static Map<Long, PlayerImpl> instances = new HashMap<Long, PlayerImpl>();
    private long pointer;

    public void clear() {
        this.clear_native(this.pointer);
    }

    public int getID() {
        return this.getID_native(this.pointer);
    }

    public String getName() {
        return this.getName_native(this.pointer);
    }

    public List<Unit> getUnits() {
        return this.getUnits_native(this.pointer);
    }

    public Race getRace() {
        return this.getRace_native(this.pointer);
    }

    public PlayerType getType() {
        return this.getType_native(this.pointer);
    }

    public Force getForce() {
        return this.getForce_native(this.pointer);
    }

    public boolean isAlly(Player player) {
        return this.isAlly_native(this.pointer, player);
    }

    public boolean isEnemy(Player player) {
        return this.isEnemy_native(this.pointer, player);
    }

    public boolean isNeutral() {
        return this.isNeutral_native(this.pointer);
    }

    public TilePosition getStartLocation() {
        return this.getStartLocation_native(this.pointer);
    }

    public boolean isVictorious() {
        return this.isVictorious_native(this.pointer);
    }

    public boolean isDefeated() {
        return this.isDefeated_native(this.pointer);
    }

    public boolean leftGame() {
        return this.leftGame_native(this.pointer);
    }

    public int minerals() {
        return this.minerals_native(this.pointer);
    }

    public int gas() {
        return this.gas_native(this.pointer);
    }

    public int gatheredMinerals() {
        return this.gatheredMinerals_native(this.pointer);
    }

    public int gatheredGas() {
        return this.gatheredGas_native(this.pointer);
    }

    public int repairedMinerals() {
        return this.repairedMinerals_native(this.pointer);
    }

    public int repairedGas() {
        return this.repairedGas_native(this.pointer);
    }

    public int refundedMinerals() {
        return this.refundedMinerals_native(this.pointer);
    }

    public int refundedGas() {
        return this.refundedGas_native(this.pointer);
    }

    public int spentMinerals() {
        return this.spentMinerals_native(this.pointer);
    }

    public int spentGas() {
        return this.spentGas_native(this.pointer);
    }

    public int supplyTotal() {
        return this.supplyTotal_native(this.pointer);
    }

    public int supplyUsed() {
        return this.supplyUsed_native(this.pointer);
    }

    public int supplyTotal(Race race) {
        return this.supplyTotal_native(this.pointer, race);
    }

    public int supplyUsed(Race race) {
        return this.supplyUsed_native(this.pointer, race);
    }

    public int allUnitCount(UnitType unitType) {
        return this.allUnitCount_native(this.pointer, unitType);
    }

    public int visibleUnitCount(UnitType unitType) {
        return this.visibleUnitCount_native(this.pointer, unitType);
    }

    public int completedUnitCount(UnitType unitType) {
        return this.completedUnitCount_native(this.pointer, unitType);
    }

    public int incompleteUnitCount(UnitType unitType) {
        return this.incompleteUnitCount_native(this.pointer, unitType);
    }

    public int deadUnitCount(UnitType unitType) {
        return this.deadUnitCount_native(this.pointer, unitType);
    }

    public int killedUnitCount(UnitType unitType) {
        return this.killedUnitCount_native(this.pointer, unitType);
    }

    public boolean hasResearched(TechType techType) {
        return this.hasResearched_native(this.pointer, techType);
    }

    public boolean isResearching(TechType techType) {
        return this.isResearching_native(this.pointer, techType);
    }

    public boolean isUpgrading(UpgradeType upgradeType) {
        return this.isUpgrading_native(this.pointer, upgradeType);
    }

    public int getTextColor() {
        return this.getTextColor_native(this.pointer);
    }

    public int maxEnergy(UnitType unitType) {
        return this.maxEnergy_native(this.pointer, unitType);
    }

    public double topSpeed(UnitType unitType) {
        return this.topSpeed_native(this.pointer, unitType);
    }

    public int groundWeaponMaxRange(UnitType unitType) {
        return this.groundWeaponMaxRange_native(this.pointer, unitType);
    }

    public int airWeaponMaxRange(UnitType unitType) {
        return this.airWeaponMaxRange_native(this.pointer, unitType);
    }

    public int weaponMaxRange(WeaponType weaponType) {
        return this.weaponMaxRange_native(this.pointer, weaponType);
    }

    public int sightRange(UnitType unitType) {
        return this.sightRange_native(this.pointer, unitType);
    }

    public int groundWeaponDamageCooldown(UnitType unitType) {
        return this.groundWeaponDamageCooldown_native(this.pointer, unitType);
    }

    public int armor(UnitType unitType) {
        return this.armor_native(this.pointer, unitType);
    }

    public int getUnitScore() {
        return this.getUnitScore_native(this.pointer);
    }

    public int getKillScore() {
        return this.getKillScore_native(this.pointer);
    }

    public int getBuildingScore() {
        return this.getBuildingScore_native(this.pointer);
    }

    public int getRazingScore() {
        return this.getRazingScore_native(this.pointer);
    }

    public int getCustomScore() {
        return this.getCustomScore_native(this.pointer);
    }

    public boolean isObserver() {
        return this.isObserver_native(this.pointer);
    }

    public boolean isResearchAvailable(TechType techType) {
        return this.isResearchAvailable_native(this.pointer, techType);
    }

    public boolean isUnitAvailable(UnitType unitType) {
        return this.isUnitAvailable_native(this.pointer, unitType);
    }

    private PlayerImpl(long l) {
        this.pointer = l;
    }

    private static PlayerImpl get(long l) {
        PlayerImpl playerImpl = instances.get(l);
        if (playerImpl == null) {
            playerImpl = new PlayerImpl(l);
            instances.put(l, playerImpl);
        }
        return playerImpl;
    }

    private native void clear_native(long var1);

    private native int getID_native(long var1);

    private native String getName_native(long var1);

    private native List<Unit> getUnits_native(long var1);

    private native Race getRace_native(long var1);

    private native PlayerType getType_native(long var1);

    private native Force getForce_native(long var1);

    private native boolean isAlly_native(long var1, Player var3);

    private native boolean isEnemy_native(long var1, Player var3);

    private native boolean isNeutral_native(long var1);

    private native TilePosition getStartLocation_native(long var1);

    private native boolean isVictorious_native(long var1);

    private native boolean isDefeated_native(long var1);

    private native boolean leftGame_native(long var1);

    private native int minerals_native(long var1);

    private native int gas_native(long var1);

    private native int gatheredMinerals_native(long var1);

    private native int gatheredGas_native(long var1);

    private native int repairedMinerals_native(long var1);

    private native int repairedGas_native(long var1);

    private native int refundedMinerals_native(long var1);

    private native int refundedGas_native(long var1);

    private native int spentMinerals_native(long var1);

    private native int spentGas_native(long var1);

    private native int supplyTotal_native(long var1);

    private native int supplyUsed_native(long var1);

    private native int supplyTotal_native(long var1, Race var3);

    private native int supplyUsed_native(long var1, Race var3);

    private native int allUnitCount_native(long var1, UnitType var3);

    private native int visibleUnitCount_native(long var1, UnitType var3);

    private native int completedUnitCount_native(long var1, UnitType var3);

    private native int incompleteUnitCount_native(long var1, UnitType var3);

    private native int deadUnitCount_native(long var1, UnitType var3);

    private native int killedUnitCount_native(long var1, UnitType var3);

    private native boolean hasResearched_native(long var1, TechType var3);

    private native boolean isResearching_native(long var1, TechType var3);

    private native boolean isUpgrading_native(long var1, UpgradeType var3);

    private native int getTextColor_native(long var1);

    private native int maxEnergy_native(long var1, UnitType var3);

    private native double topSpeed_native(long var1, UnitType var3);

    private native int groundWeaponMaxRange_native(long var1, UnitType var3);

    private native int airWeaponMaxRange_native(long var1, UnitType var3);

    private native int weaponMaxRange_native(long var1, WeaponType var3);

    private native int sightRange_native(long var1, UnitType var3);

    private native int groundWeaponDamageCooldown_native(long var1, UnitType var3);

    private native int armor_native(long var1, UnitType var3);

    private native int getUnitScore_native(long var1);

    private native int getKillScore_native(long var1);

    private native int getBuildingScore_native(long var1);

    private native int getRazingScore_native(long var1);

    private native int getCustomScore_native(long var1);

    private native boolean isObserver_native(long var1);

    private native boolean isResearchAvailable_native(long var1, TechType var3);

    private native boolean isUnitAvailable_native(long var1, UnitType var3);
}

