/*
 * Decompiled with CFR 0.152.
 */
package bwta;

import bwapi.Position;
import bwapi.PositionedObject;
import bwapi.TilePosition;
import bwta.Region;
import java.util.HashMap;
import java.util.Map;

public class BaseLocation
extends PositionedObject {
    private static Map<Long, BaseLocation> instances = new HashMap<Long, BaseLocation>();
    private long pointer;

    @Override
    public Position getPosition() {
        return this.getPosition_native(this.pointer);
    }

    public TilePosition getTilePosition() {
        return this.getTilePosition_native(this.pointer);
    }

    public Region getRegion() {
        return this.getRegion_native(this.pointer);
    }

    public int minerals() {
        return this.minerals_native(this.pointer);
    }

    public int gas() {
        return this.gas_native(this.pointer);
    }

    public double getGroundDistance(BaseLocation baseLocation) {
        return this.getGroundDistance_native(this.pointer, baseLocation);
    }

    public double getAirDistance(BaseLocation baseLocation) {
        return this.getAirDistance_native(this.pointer, baseLocation);
    }

    public boolean isIsland() {
        return this.isIsland_native(this.pointer);
    }

    public boolean isMineralOnly() {
        return this.isMineralOnly_native(this.pointer);
    }

    public boolean isStartLocation() {
        return this.isStartLocation_native(this.pointer);
    }

    private BaseLocation(long l) {
        this.pointer = l;
    }

    private static BaseLocation get(long l) {
        if (l == 0L) {
            return null;
        }
        BaseLocation baseLocation = instances.get(l);
        if (baseLocation == null) {
            baseLocation = new BaseLocation(l);
            instances.put(l, baseLocation);
        }
        return baseLocation;
    }

    private native Position getPosition_native(long var1);

    private native TilePosition getTilePosition_native(long var1);

    private native Region getRegion_native(long var1);

    private native int minerals_native(long var1);

    private native int gas_native(long var1);

    private native double getGroundDistance_native(long var1, BaseLocation var3);

    private native double getAirDistance_native(long var1, BaseLocation var3);

    private native boolean isIsland_native(long var1);

    private native boolean isMineralOnly_native(long var1);

    private native boolean isStartLocation_native(long var1);
}

