/*
 * Decompiled with CFR 0.152.
 */
import bwapi.Color;
import bwapi.Game;
import bwapi.Player;
import bwapi.Position;
import bwapi.Unit;
import bwapi.UnitType;
import bwapi.WeaponType;
import bwta.BaseLocation;
import java.util.List;

public class WraithAgent
extends Agent {
    int current = -1;
    BaseLocation target = null;
    int state = 0;
    public static final int AttackState = 0;
    public static final int FleeState = 1;

    public WraithAgent(Unit wraith) {
        super(wraith);
    }

    public void onFrame(Game game, Player self, Tyr bot) {
        List<Unit> inRange = game.getUnitsInRadius(this.unit.getPosition(), UnitType.Terran_Wraith.sightRange());
        Unit closestEnemy = null;
        double closestDistance = UnitType.Terran_Wraith.sightRange() + 100;
        for (Unit enemy : inRange) {
            double dist;
            if (enemy.getPlayer() == self || enemy.getType().airWeapon() == WeaponType.None || !((dist = (double)this.unit.getDistance(enemy)) < closestDistance)) continue;
            closestDistance = dist;
            closestEnemy = enemy;
        }
        if (closestEnemy == null) {
            if (this.state != 0) {
                this.state = 0;
                ++this.current;
                if (this.current >= bot.suspectedEnemy.size() + bot.expands.size()) {
                    this.current = 0;
                }
            }
            if (this.unit.isIdle()) {
                BaseLocation newTarget;
                boolean myBase;
                block1: do {
                    ++this.current;
                    if (this.current >= bot.suspectedEnemy.size() + bot.expands.size()) {
                        this.current = 0;
                    }
                    newTarget = this.current < bot.suspectedEnemy.size() ? bot.suspectedEnemy.get(this.current) : bot.expands.get(this.current - bot.suspectedEnemy.size());
                    myBase = false;
                    for (MineralWorkers base : bot.workForce.mineralWorkers) {
                        if (!(base.resourceDepot.getPosition().getDistance(newTarget.getPosition()) <= 128.0)) continue;
                        myBase = true;
                        continue block1;
                    }
                } while (myBase);
                this.target = newTarget;
                this.unit.attack(this.target.getPosition());
            }
        } else {
            this.state = 1;
            Position fleeTarget = this.retreatTarget(closestEnemy.getPosition(), 96.0);
            this.unit.move(fleeTarget);
            game.drawLineMap(closestEnemy.getX(), closestEnemy.getY(), fleeTarget.getX(), fleeTarget.getY(), Color.Red);
        }
    }
}

