/*
 * Decompiled with CFR 0.152.
 */
import bwapi.Color;
import bwapi.Game;
import bwapi.Player;
import bwapi.Position;
import bwapi.Unit;
import java.util.ArrayList;

public class WorkerGroup
extends UnitGroup {
    ArrayList<MineralWorkers> mineralWorkers = new ArrayList();
    OutOfJob outOfJob = new OutOfJob();

    public WorkerGroup(OutOfJob rejects) {
        super(rejects);
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        if (this.mineralWorkers.size() > 0) {
            ArrayList<MineralWorkers> minedOut = new ArrayList<MineralWorkers>();
            for (MineralWorkers mw : this.mineralWorkers) {
                if (mw.minerals.size() != 0) continue;
                minedOut.add(mw);
            }
            for (MineralWorkers mw : minedOut) {
                this.mineralWorkers.remove(mw);
                while (mw.units.size() != 0) {
                    this.outOfJob.add((Agent)mw.units.get(mw.units.size() - 1));
                    mw.remove(mw.units.size() - 1);
                }
            }
            int total = 0;
            for (MineralWorkers mw : this.mineralWorkers) {
                if (!mw.resourceDepot.isCompleted()) continue;
                ++total;
            }
            int average = 0;
            if (total != 0) {
                average = this.units.size() / total;
            }
            for (MineralWorkers mw : this.mineralWorkers) {
                while (mw.units.size() > average + 1) {
                    this.outOfJob.add((Agent)mw.units.get(mw.units.size() - 1));
                    mw.remove(mw.units.size() - 1);
                }
            }
            int filled = 0;
            while (this.outOfJob.units.size() > 0) {
                Agent worker = this.outOfJob.pop();
                boolean done = false;
                while (filled < this.mineralWorkers.size()) {
                    if (this.mineralWorkers.get((int)filled).resourceDepot.isCompleted() && this.mineralWorkers.get((int)filled).units.size() < average + 1) {
                        this.mineralWorkers.get(filled).add(worker);
                        done = true;
                        break;
                    }
                    ++filled;
                }
                if (!done) break;
            }
            for (MineralWorkers mw : this.mineralWorkers) {
                mw.onFrame(game, self, bot);
            }
        }
        for (Agent agent : this.outOfJob.units) {
            agent.drawCircle(Color.Brown);
        }
    }

    @Override
    public Agent pop() {
        Agent result = null;
        for (MineralWorkers mw : this.mineralWorkers) {
            result = mw.pop();
            if (result == null) continue;
            this.units.remove(result);
            return result;
        }
        return null;
    }

    @Override
    public void cleanup() {
        super.cleanup();
        for (MineralWorkers base : this.mineralWorkers) {
            base.cleanup();
        }
    }

    public Agent pop(Position pos) {
        if (pos == null) {
            System.out.println("Error, pos is null.");
            return this.pop();
        }
        Agent result = null;
        UnitGroup mwResult = null;
        double distance = Double.MAX_VALUE;
        for (MineralWorkers mw : this.mineralWorkers) {
            Agent newWorker = mw.pop(pos);
            if (newWorker == null) continue;
            newWorker.drawCircle(Color.Green, 6);
            double newDist = newWorker.distanceSquared(pos);
            if (!(newDist < distance)) continue;
            result = newWorker;
            mwResult = mw;
            distance = newDist;
        }
        if (result != null) {
            this.units.remove(result);
            mwResult.remove(result);
        }
        return result;
    }

    @Override
    public void add(Agent agent) {
        super.add(agent);
        this.outOfJob.add(agent);
    }

    public void newBase(Unit base) {
        this.mineralWorkers.add(new MineralWorkers(this.outOfJob, base));
    }
}

