/*
 * Decompiled with CFR 0.152.
 */
import bwapi.Color;
import bwapi.Game;
import bwapi.Player;
import bwapi.TilePosition;
import bwapi.Unit;
import bwapi.UnitType;
import bwta.Region;
import java.util.ArrayList;

public class WallOff {
    public boolean placementFound = false;
    ArrayList<BuildCommand> buildPlan = new ArrayList();
    ArrayList<BuildCommand> underConstruction = new ArrayList();
    ArrayList<Unit> wall = new ArrayList();
    TilePosition center;
    int[][] cliffs;
    boolean[][] buildable;
    boolean[][] cliff1;
    boolean[][] cliff2;
    int[][] wallPlacements;
    int[][] dims;
    boolean checked = false;
    boolean firstBuilding = false;
    public static int r = 7;

    public WallOff(TilePosition center, Region defendedRegion, Game game) {
        this.center = center;
        this.cliffs = new int[2 * r + 1][2 * r + 1];
        this.buildable = new boolean[2 * r + 1][2 * r + 1];
        int x = center.getX() - r;
        while (x <= center.getX() + r) {
            int y = center.getY() - r;
            while (y <= center.getY() + r) {
                TilePosition pos = new TilePosition(x, y);
                if (game.isBuildable(pos)) {
                    this.buildable[x - center.getX() + WallOff.r][y - center.getY() + WallOff.r] = true;
                } else {
                    boolean walkable = true;
                    int dx = 0;
                    while (dx < 4) {
                        int dy = 0;
                        while (dy < 4) {
                            if (!game.isWalkable(x * 4 + dx, y * 4 + dy)) {
                                walkable = false;
                                break;
                            }
                            ++dy;
                        }
                        ++dx;
                    }
                    if (!walkable) {
                        this.cliffs[x - center.getX() + WallOff.r][y - center.getY() + WallOff.r] = 1;
                    }
                }
                ++y;
            }
            ++x;
        }
        ArrayList<Integer> cliffSizes = new ArrayList<Integer>();
        int n = 2;
        int x2 = center.getX() - r;
        while (x2 <= center.getX() + r) {
            int y = center.getY() - r;
            while (y <= center.getY() + r) {
                if (this.cliffs[x2 - center.getX() + r][y - center.getY() + r] == 1) {
                    cliffSizes.add(this.bfs(x2, y, n));
                    ++n;
                }
                ++y;
            }
            ++x2;
        }
        int c1 = 0;
        while (c1 < cliffSizes.size()) {
            if ((Integer)cliffSizes.get(c1) >= 6) break;
            ++c1;
        }
        int c2 = c1 + 1;
        while (c2 < cliffSizes.size()) {
            if ((Integer)cliffSizes.get(c2) >= 6) break;
            ++c2;
        }
        if (c2 >= cliffSizes.size()) {
            return;
        }
        this.cliff1 = new boolean[2 * r + 1][2 * r + 1];
        this.cliff2 = new boolean[2 * r + 1][2 * r + 1];
        int x3 = 0;
        while (x3 < 2 * r + 1) {
            int y = 0;
            while (y < 2 * r + 1) {
                if (this.cliffs[x3][y] == c1 + 2) {
                    this.cliff1[x3][y] = true;
                }
                if (this.cliffs[x3][y] == c2 + 2) {
                    this.cliff2[x3][y] = true;
                }
                ++y;
            }
            ++x3;
        }
        this.getWall();
    }

    private void getWall() {
        this.dims = new int[][]{{4, 3}, {3, 2}};
        this.wallPlacements = this.getWall(this.dims);
        if (this.wallPlacements == null) {
            this.dims = new int[][]{{3, 2}, {4, 3}};
            this.wallPlacements = this.getWall(this.dims);
        }
        if (this.wallPlacements == null) {
            this.dims = new int[][]{{4, 3}, {3, 2}, {3, 2}};
            this.wallPlacements = this.getWall(this.dims);
        }
        if (this.wallPlacements == null) {
            this.dims = new int[][]{{3, 2}, {4, 3}, {3, 2}};
            this.wallPlacements = this.getWall(this.dims);
        }
        if (this.wallPlacements == null) {
            this.dims = new int[][]{{3, 2}, {3, 2}, {4, 3}};
            this.wallPlacements = this.getWall(this.dims);
        }
        if (this.wallPlacements != null) {
            this.placementFound = true;
            int i = 0;
            while (i < this.wallPlacements.length) {
                this.buildPlan.add(new BuildCommand(null, this.dims[i][0] == 4 ? UnitType.Terran_Barracks : UnitType.Terran_Supply_Depot, new TilePosition(this.center.getX() - r + this.wallPlacements[i][0], this.center.getY() - r + this.wallPlacements[i][1]), true));
                ++i;
            }
        } else {
            System.out.println("No wall placements.");
            this.placementFound = false;
        }
        System.out.println("buildPlan.size = " + this.buildPlan.size());
    }

    public BuildCommand getCommand(UnitType building) {
        if (this.firstBuilding && !this.checked) {
            return null;
        }
        this.firstBuilding = true;
        BuildCommand result = null;
        for (BuildCommand com : this.buildPlan) {
            if (com.building != building) continue;
            result = com;
            break;
        }
        if (result != null) {
            this.buildPlan.remove(result);
            this.underConstruction.add(result);
        }
        return result;
    }

    public int[][] getWall(int[][] dims) {
        boolean[][][] buildingPlacements = new boolean[dims.length][][];
        buildingPlacements[0] = this.getSurroundingPlacements(this.cliff1, 1, 1, dims[0][0], dims[0][1]);
        boolean[][] lastBuilding = this.getSurroundingPlacements(this.cliff2, 1, 1, dims[dims.length - 1][0], dims[dims.length - 1][1]);
        int i = 0;
        while (i < dims.length - 1) {
            buildingPlacements[i + 1] = this.getSurroundingPlacements(buildingPlacements[i], dims[i][0], dims[i][1], dims[i + 1][0], dims[i + 1][1]);
            ++i;
        }
        int[][] result = new int[dims.length][2];
        boolean[][] closingPlacements = lastBuilding;
        int i2 = dims.length - 1;
        while (i2 >= 0) {
            int x = 0;
            int y = 0;
            boolean found = false;
            x = 0;
            while (x < 2 * r + 1) {
                y = 0;
                while (y < 2 * r + 1) {
                    if (buildingPlacements[i2][x][y] && closingPlacements[x][y]) {
                        found = true;
                        break;
                    }
                    ++y;
                }
                if (found) break;
                ++x;
            }
            if (!found) {
                return null;
            }
            result[i2][0] = x;
            result[i2][1] = y;
            if (i2 > 0) {
                closingPlacements = new boolean[2 * r + 1][2 * r + 1];
                closingPlacements[x][y] = true;
                closingPlacements = this.getSurroundingPlacements(closingPlacements, dims[i2][0], dims[i2][1], dims[i2 - 1][0], dims[i2 - 1][1]);
            }
            --i2;
        }
        return result;
    }

    public int bfs(int x, int y, int n) {
        if (Math.abs(x - this.center.getX()) > r || Math.abs(y - this.center.getY()) > r) {
            return 0;
        }
        if (this.cliffs[x - this.center.getX() + r][y - this.center.getY() + r] != 1) {
            return 0;
        }
        this.cliffs[x - this.center.getX() + WallOff.r][y - this.center.getY() + WallOff.r] = n;
        int total = 1;
        total += this.bfs(x - 1, y, n);
        total += this.bfs(x + 1, y, n);
        total += this.bfs(x, y - 1, n);
        return total += this.bfs(x, y + 1, n);
    }

    public void onFrame(Game game, Player self, Tyr bot) {
        ArrayList<Unit> deadWall = new ArrayList<Unit>();
        for (Unit unit : this.wall) {
            if (unit.getHitPoints() > 0 && unit.exists()) continue;
            deadWall.add(unit);
        }
        for (Unit unit : deadWall) {
            this.wall.remove(unit);
        }
        ArrayList<BuildCommand> finishedCommands = new ArrayList<BuildCommand>();
        ArrayList<BuildCommand> removeCommands = new ArrayList<BuildCommand>();
        ArrayList<BuildCommand> addCommands = new ArrayList<BuildCommand>();
        boolean goCheck = false;
        BuildCommand replacedCommand = null;
        for (BuildCommand com : this.underConstruction) {
            if (com.worker == null || !com.worker.unit.isIdle() || this.checked) continue;
            this.checked = true;
            goCheck = true;
            replacedCommand = com;
            break;
        }
        if (goCheck) {
            for (Unit unit : game.getNeutralUnits()) {
                int dx = 0;
                while (dx < unit.getType().tileWidth()) {
                    int x = unit.getTilePosition().getX() + dx;
                    if ((x = x - this.center.getX() + r) >= 0 && x < 2 * r + 1) {
                        int dy = 0;
                        while (dy < unit.getType().tileHeight()) {
                            int y = unit.getTilePosition().getY() + dy;
                            if ((y = y - this.center.getY() + r) >= 0 && y < 2 * r + 1) {
                                this.buildable[x][y] = false;
                            }
                            ++dy;
                        }
                    }
                    ++dx;
                }
            }
            this.buildPlan = new ArrayList();
            this.getWall();
            BuildCommand newCom = this.getCommand(replacedCommand.building);
            newCom.worker = replacedCommand.worker;
            replacedCommand.worker.unit.build(newCom.position, newCom.building);
            removeCommands.add(replacedCommand);
            addCommands.add(newCom);
        }
        for (BuildCommand com : this.underConstruction) {
            if (com.worker == null) continue;
            com.worker.drawCircle(Color.Yellow);
            game.drawTextMap(com.worker.unit.getPosition().getX(), com.worker.unit.getPosition().getY(), com.worker.unit.getOrder().toString());
            if (com.worker.unit.isConstructing() && com.worker.unit.getBuildUnit() != null && !this.wall.contains(com.worker.unit.getBuildUnit())) {
                bot.reservedMinerals -= com.building.mineralPrice();
                bot.reservedGas -= com.building.gasPrice();
                this.wall.add(com.worker.unit.getBuildUnit());
                bot.hobos.add(com.worker);
                removeCommands.add(com);
                continue;
            }
            if (!com.worker.unit.isIdle() || !this.checked) continue;
            boolean done = false;
            for (Unit building : this.wall) {
                if (building == null) {
                    System.out.println("building is null!");
                } else if (building.getTilePosition() == null) {
                    System.out.println("building.getTilePosition() is null!");
                } else if (com == null) {
                    System.out.println("com is null!");
                } else if (com.position == null) {
                    System.out.println("com.position is null!");
                }
                if (building.getTilePosition().getX() != com.position.getX() || building.getTilePosition().getY() != com.position.getY()) continue;
                done = true;
            }
            if (!done) {
                com.worker.unit.build(com.position, com.building);
                continue;
            }
            finishedCommands.add(com);
        }
        for (BuildCommand com : finishedCommands) {
            bot.hobos.add(com.worker);
            com.worker = null;
            removeCommands.add(com);
        }
        for (BuildCommand com : removeCommands) {
            this.underConstruction.remove(com);
        }
        for (BuildCommand com : addCommands) {
            this.underConstruction.add(com);
        }
        int i = 0;
        while (i < this.buildPlan.size()) {
            int x = this.buildPlan.get((int)i).position.getX() * 32;
            int y = this.buildPlan.get((int)i).position.getY() * 32;
            game.drawBoxMap(x, y, x + this.buildPlan.get((int)i).building.tileWidth() * 32, y + this.buildPlan.get((int)i).building.tileHeight() * 32, Color.Blue);
            game.drawTextMap(x, y, this.buildPlan.get((int)i).building.toString());
            ++i;
        }
    }

    public boolean[][] getSurroundingPlacements(boolean[][] firstBuilding, int w1, int h1, int w2, int h2) {
        boolean[][] result = new boolean[2 * r + 1][2 * r + 1];
        int x = 0;
        while (x < 2 * r + 1) {
            int y = 0;
            while (y < 2 * r + 1) {
                if (firstBuilding[x][y]) {
                    int dx = -w2 + 1;
                    while (dx < w1) {
                        if (x + dx >= 0 && x + dx + w2 <= 2 * r + 1) {
                            if (y - h2 > 0 && this.buildingClear(x + dx, y - h2, w2, h2)) {
                                result[x + dx][y - h2] = true;
                            }
                            if (y + h1 + h2 <= 2 * r + 1 && this.buildingClear(x + dx, y + h1, w2, h2)) {
                                result[x + dx][y + h1] = true;
                            }
                        }
                        ++dx;
                    }
                    int dy = -h2 + 1;
                    while (dy < h1) {
                        if (y + dy >= 0 && y + dy + h2 <= 2 * r + 1) {
                            if (x - w2 > 0 && this.buildingClear(x - w2, y + dy, w2, h2)) {
                                result[x - w2][y + dy] = true;
                            }
                            if (x + w1 + w2 <= 2 * r + 1 && this.buildingClear(x + w1, y + dy, w2, h2)) {
                                result[x + w1][y + dy] = true;
                            }
                        }
                        ++dy;
                    }
                }
                ++y;
            }
            ++x;
        }
        return result;
    }

    private boolean buildingClear(int x, int y, int w, int h) {
        if (x + w > 2 * r + 1) {
            return false;
        }
        if (y + h > 2 * r + 1) {
            return false;
        }
        int dx = 0;
        while (dx < w) {
            int dy = 0;
            while (dy < h) {
                if (!this.buildable[x + dx][y + dy]) {
                    return false;
                }
                ++dy;
            }
            ++dx;
        }
        return true;
    }
}

