/*
 * Decompiled with CFR 0.152.
 */
import bwapi.Color;
import bwapi.DefaultBWListener;
import bwapi.Game;
import bwapi.Mirror;
import bwapi.Player;
import bwapi.Position;
import bwapi.Race;
import bwapi.TilePosition;
import bwapi.Unit;
import bwapi.UnitType;
import bwapi.WeaponType;
import bwta.BWTA;
import bwta.BaseLocation;
import bwta.Chokepoint;
import bwta.Region;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class Tyr
extends DefaultBWListener {
    private Mirror mirror = new Mirror();
    public static Game game;
    public Player self;
    public int reservedMinerals;
    public int reservedGas;
    public HashSet<EnemyPosition> enemyBuildingMemory = new HashSet();
    public ArrayList<EnemyPosition> enemyDefensiveStructures;
    public ArrayList<EnemyPosition> neutralStructures;
    public ArrayList<BaseLocation> expands = new ArrayList();
    public ArrayList<BaseLocation> suspectedEnemy = new ArrayList();
    public ArrayList<BuildCommand> buildCommands = new ArrayList();
    public ArrayList<DefensiveStructures> defensiveStructures = new ArrayList();
    private boolean defenseMode = false;
    public int defenseTime = 0;
    public int invasionDist = 1024;
    public Unit invader;
    public int invaderCount = 0;
    public boolean areWeBeingInvaded;
    public ComsatNetwork comsatNetwork;
    public WraithSwarm swarm;
    public Army army;
    public Bunkers bunkers;
    public ScoutGroup scout;
    public DefendingWorkers militia;
    public WorkerGroup workForce;
    public BuilderGroup builders;
    public ProductionStructures production;
    public UnderConstruction underConstruction;
    public OutOfJob hobos;
    public ArrayList<UnitGroup> groups = new ArrayList();
    public int workersPerGas = 1;
    public int defensiveTanks = 0;
    public SpaceManager spaceManager;
    public Scanner scanner;
    public WallOff wallOff;
    public HashMap<UnitType, Integer> unitCounts = new HashMap();
    public int ccCount = 0;
    public int geyserCount = 0;
    public int supplyConstructing = 0;
    public BuildOrder build;
    public int maximumWorkers = 45;
    public static Tyr bot;
    private StopWatch stopWatch = new StopWatch();
    public int wins = 0;
    public int losses = 0;
    StrategyDetector strategyDetector = new StrategyDetector();
    public HashMap<Integer, Agent> agentMap = new HashMap();
    long initTime;
    long buildTime;
    long unitGroupsTime;
    long agentTime;
    private Position mainExit = null;

    public void run() {
        this.mirror.getModule().setEventListener(this);
        this.mirror.startGame();
    }

    @Override
    public void onUnitCreate(Unit unit) {
        Agent agent = Agent.createAgent(unit);
        this.agentMap.put(unit.getID(), agent);
        this.hobos.add(agent);
        if (unit.getType() == UnitType.Terran_Bunker || unit.getType() == UnitType.Terran_Missile_Turret) {
            DefensiveStructures structures = null;
            for (Unit builder : this.self.getUnits()) {
                if (!builder.getType().isWorker() || builder.getBuildUnit() != unit) continue;
                Agent builderAgent = this.agentMap.get(builder.getID());
                if (builderAgent.command == null || !builderAgent.command.getClass().equals(BuildDefensive.class)) continue;
                structures = ((BuildDefensive)builderAgent.command).defensePos;
                break;
            }
            if (structures != null) {
                structures.add(unit);
            } else {
                System.out.println("No matching BuildDefensive command found.");
            }
        } else if (unit.getType().isResourceDepot()) {
            this.workForce.newBase(unit);
        }
    }

    @Override
    public void onStart() {
        game = this.mirror.getGame();
        this.self = game.self();
        Thread t = new Thread(new BWTAInitializer(this, this.self));
        t.start();
        try {
            this.spaceManager = new SpaceManager(game);
            this.scanner = new Scanner(game);
            this.wallOff = null;
            this.build = this.self.getRace() == Race.Terran ? (game.enemy().getRace() == Race.Zerg ? new TvZ() : (game.enemy().getRace() == Race.Protoss ? new Mech() : new Mech())) : (this.self.getRace() == Race.Protoss ? new ProtossTech() : new StandardZerg());
            this.hobos = new OutOfJob();
            this.bunkers = new Bunkers(this.hobos);
            this.underConstruction = new UnderConstruction(this.hobos);
            this.production = new ProductionStructures(this.hobos);
            this.builders = new BuilderGroup(this.hobos);
            this.militia = new DefendingWorkers(this.hobos);
            this.workForce = new WorkerGroup(this.hobos);
            int requiredArmySize = -1;
            requiredArmySize = this.self.getRace() == Race.Zerg ? 5 : (this.self.getRace() == Race.Protoss ? 15 : (game.enemy().getRace() == Race.Zerg ? 15 : (game.enemy().getRace() == Race.Protoss ? 40 : 30)));
            int maxArmySize = -1;
            maxArmySize = this.self.getRace() == Race.Zerg ? 5 : (this.self.getRace() == Race.Protoss ? 30 : (game.enemy().getRace() == Race.Terran ? 60 : (game.enemy().getRace() == Race.Zerg ? 30 : 60)));
            this.army = new Army(this.hobos, requiredArmySize, maxArmySize);
            this.comsatNetwork = new ComsatNetwork(this.hobos);
            this.scout = new ScoutGroup(this.hobos);
            this.swarm = new WraithSwarm(this.hobos);
            this.groups.add(this.hobos);
            this.groups.add(this.bunkers);
            this.groups.add(this.underConstruction);
            this.groups.add(this.production);
            this.groups.add(this.builders);
            this.groups.add(this.militia);
            this.groups.add(this.workForce);
            this.groups.add(this.army);
            this.groups.add(this.comsatNetwork);
            this.groups.add(this.scout);
            this.groups.add(this.swarm);
            ArrayList<String> records = DebugMessages.readFile();
            for (String s : records) {
                if (s.startsWith("win")) {
                    ++this.wins;
                    continue;
                }
                ++this.losses;
            }
            ArrayList<PlayerProfile> profiles = PlayerProfile.getProfiles();
            for (PlayerProfile pp : profiles) {
                if (!pp.match(game, this)) {
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            DebugMessages.addMessagePermanent("Error starting up: " + e.toString());
            e.printStackTrace();
            this.quickStartup();
            throw e;
        }
    }

    public void quickStartup() {
        DebugMessages.addMessagePermanent("Error starting, doing quick startup.");
        System.out.println("Error starting, doing quick startup.");
        this.groups = new ArrayList();
        this.spaceManager = new SpaceManager(game);
        this.scanner = new Scanner(game);
        this.wallOff = null;
        this.build = this.self.getRace() == Race.Terran ? new TvP() : (this.self.getRace() == Race.Protoss ? new ProtossTech() : new StandardZerg());
        this.hobos = new OutOfJob();
        this.bunkers = new Bunkers(this.hobos);
        this.underConstruction = new UnderConstruction(this.hobos);
        this.production = new ProductionStructures(this.hobos);
        this.builders = new BuilderGroup(this.hobos);
        this.militia = new DefendingWorkers(this.hobos);
        this.workForce = new WorkerGroup(this.hobos);
        int requiredArmySize = 20;
        int maxArmySize = 40;
        this.army = new Army(this.hobos, requiredArmySize, maxArmySize);
        this.comsatNetwork = new ComsatNetwork(this.hobos);
        this.scout = new ScoutGroup(this.hobos);
        this.swarm = new WraithSwarm(this.hobos);
        this.groups.add(this.hobos);
        this.groups.add(this.bunkers);
        this.groups.add(this.underConstruction);
        this.groups.add(this.production);
        this.groups.add(this.builders);
        this.groups.add(this.militia);
        this.groups.add(this.workForce);
        this.groups.add(this.army);
        this.groups.add(this.comsatNetwork);
        this.groups.add(this.scout);
        this.groups.add(this.swarm);
    }

    public int getAvailableMinerals() {
        return this.self.minerals() - this.reservedMinerals;
    }

    public int getAvailableGas() {
        return this.self.gas() - this.reservedGas;
    }

    @Override
    public void onFrame() {
        Agent agent2;
        if (game.isReplay()) {
            return;
        }
        game.setTextSize(4);
        this.stopWatch.start();
        if (this.neutralStructures == null) {
            this.neutralStructures = new ArrayList();
            for (Unit unit : game.getNeutralUnits()) {
                this.neutralStructures.add(new EnemyPosition(unit.getType(), unit.getPosition()));
            }
        }
        if (BWTAInitializer.initialized) {
            this.drawCircle(this.getMainExit(), Color.Green, 128);
        }
        this.unitCounts = new HashMap();
        this.ccCount = 0;
        this.supplyConstructing = 0;
        List<Unit> myUnits = this.self.getUnits();
        this.geyserCount = 0;
        if (bot == null) {
            System.out.println("bot is null.");
        } else if (Tyr.bot.workForce == null) {
            System.out.println("bot.workForce is null.");
        } else if (Tyr.bot.workForce.mineralWorkers == null) {
            System.out.println("bot.workForce.mineralWorkers is null.");
        }
        for (MineralWorkers base : Tyr.bot.workForce.mineralWorkers) {
            if (base.gasWorkers == null || base.gasWorkers.geyser.getType() != UnitType.Resource_Vespene_Geyser) continue;
            boolean alreadyBuilt = false;
            for (BuildCommand command : Tyr.bot.buildCommands) {
                if (command.position.getX() != base.gasWorkers.geyser.getX() || command.position.getY() != base.gasWorkers.geyser.getY()) continue;
                alreadyBuilt = true;
                break;
            }
            if (alreadyBuilt) continue;
            ++this.geyserCount;
        }
        if (myUnits == null) {
            DebugMessages.addMessage("Whoops, getUnits is null!");
        } else {
            for (Unit myUnit : myUnits) {
                if (!this.unitCounts.containsKey(myUnit.getType())) {
                    this.unitCounts.put(myUnit.getType(), 1);
                } else {
                    this.unitCounts.put(myUnit.getType(), this.unitCounts.get(myUnit.getType()) + 1);
                }
                if (myUnit.getType().isResourceDepot()) {
                    ++this.ccCount;
                }
                if (myUnit.isBeingConstructed() && !myUnit.getType().isResourceDepot()) {
                    this.supplyConstructing += myUnit.getType().supplyProvided();
                }
                if (!myUnit.isMorphing() || myUnit.getBuildType() != UnitType.Zerg_Overlord) continue;
                this.supplyConstructing += UnitType.Zerg_Overlord.supplyProvided();
            }
        }
        for (BuildCommand command : this.buildCommands) {
            if (!this.unitCounts.containsKey(command.building)) {
                this.unitCounts.put(command.building, 1);
            } else {
                this.unitCounts.put(command.building, this.unitCounts.get(command.building) + 1);
            }
            if (command.building.isResourceDepot()) {
                ++this.ccCount;
            }
            if (command.building.isResourceDepot()) continue;
            this.supplyConstructing += command.building.supplyProvided();
        }
        if (this.wallOff != null) {
            for (BuildCommand command : this.wallOff.underConstruction) {
                if (!this.unitCounts.containsKey(command.building)) {
                    this.unitCounts.put(command.building, 1);
                } else {
                    this.unitCounts.put(command.building, this.unitCounts.get(command.building) + 1);
                }
                if (command.building.isResourceDepot()) {
                    ++this.ccCount;
                }
                if (command.building.isResourceDepot()) continue;
                this.supplyConstructing += command.building.supplyProvided();
            }
        }
        for (UnitGroup group : this.groups) {
            group.cleanup();
        }
        int i = 0;
        while (i < this.defensiveStructures.size()) {
            if (this.defensiveStructures.get((int)i).disabled) {
                this.defensiveStructures.remove(i);
                --i;
            }
            ++i;
        }
        ArrayList<Agent> reEmployed = new ArrayList<Agent>();
        for (Agent agent2 : this.hobos.units) {
            if (agent2.unit.getType() == UnitType.Terran_Comsat_Station) {
                this.comsatNetwork.add(agent2);
                reEmployed.add(agent2);
                continue;
            }
            if (agent2.unit.getType() == UnitType.Terran_Wraith) {
                this.swarm.add(agent2);
                reEmployed.add(agent2);
                continue;
            }
            if (agent2.unit.getType() == UnitType.Terran_Dropship) {
                DropHarass dh = new DropHarass(this.hobos);
                dh.setDropship(agent2);
                reEmployed.add(agent2);
                this.army.dropHarass.add(dh);
                continue;
            }
            if (agent2.unit.getType().canAttack() && !agent2.unit.getType().isWorker() && !agent2.unit.getType().isBuilding() && agent2.unit.isCompleted()) {
                this.army.add(agent2);
                reEmployed.add(agent2);
                continue;
            }
            if (agent2.unit.getType().isWorker() && agent2.unit.isCompleted()) {
                this.workForce.add(agent2);
                reEmployed.add(agent2);
                continue;
            }
            if ((agent2.unit.getType().canProduce() || agent2.unit.getType() == UnitType.Terran_Engineering_Bay || agent2.unit.getType() == UnitType.Terran_Machine_Shop || agent2.unit.getType() == UnitType.Terran_Science_Facility || agent2.unit.getType() == UnitType.Terran_Physics_Lab || agent2.unit.getType() == UnitType.Terran_Armory) && agent2.unit.isCompleted()) {
                this.production.add(agent2);
                reEmployed.add(agent2);
                continue;
            }
            if (agent2.unit.getType().isBuilding() && !agent2.unit.isCompleted()) {
                this.underConstruction.add(agent2);
                reEmployed.add(agent2);
                continue;
            }
            if (agent2.unit.getType() != UnitType.Terran_Bunker || !agent2.unit.isCompleted()) continue;
            this.bunkers.add(agent2);
            reEmployed.add(agent2);
        }
        for (Agent agent2 : reEmployed) {
            this.hobos.remove(agent2);
        }
        if (this.scout.units.size() < this.scout.scoutCount && this.army.units.size() > 4 && this.bunkers.bunkersAreManned() && (this.self.getRace() != Race.Zerg || this.army.units.size() >= 12) && (agent2 = this.army.pop()) != null) {
            agent2.order(new None(agent2));
            this.scout.add(agent2);
        }
        this.invader = null;
        this.areWeBeingInvaded = false;
        ArrayList<EnemyPosition> removePositions = new ArrayList<EnemyPosition>();
        for (EnemyPosition p : this.enemyBuildingMemory) {
            if (!game.isVisible(p.pos.getX() / 32, p.pos.getY() / 32)) continue;
            removePositions.add(p);
        }
        for (EnemyPosition p : removePositions) {
            this.enemyBuildingMemory.remove(p);
        }
        this.invaderCount = 0;
        for (Unit u : game.enemy().getUnits()) {
            EnemyPosition enemyPos;
            if (u.getType() == UnitType.Protoss_Observer) continue;
            double uDist = u.distanceTo(this.self.getStartLocation().getX() * 32, this.self.getStartLocation().getY() * 32);
            if (uDist <= (double)this.invasionDist) {
                if (this.invader == null || uDist < this.invader.distanceTo(this.self.getStartLocation().getX() * 32, this.self.getStartLocation().getY() * 32)) {
                    this.invader = u;
                }
                ++this.invaderCount;
            }
            if (!u.getType().isBuilding() || u.isLifted() || this.enemyBuildingMemory.contains(enemyPos = new EnemyPosition(u.getType(), u.getPosition()))) continue;
            this.enemyBuildingMemory.add(enemyPos);
        }
        this.enemyDefensiveStructures = new ArrayList();
        for (EnemyPosition p : this.enemyBuildingMemory) {
            this.drawCircle(p.pos, Color.Red);
            if (p.type != UnitType.Protoss_Photon_Cannon) continue;
            this.enemyDefensiveStructures.add(p);
            this.drawCircle(p.pos, Color.Red, WeaponType.Phase_Disruptor_Cannon.maxRange());
        }
        boolean bl = this.areWeBeingInvaded = this.invader != null && !this.defenseMode;
        if (this.areWeBeingInvaded) {
            this.defenseTime = -1;
        }
        this.defenseMode = this.invader != null;
        ++this.defenseTime;
        if (this.defenseTime >= 200) {
            this.defenseTime = 0;
            if (this.defenseMode) {
                this.areWeBeingInvaded = true;
            }
        }
        if (this.invader != null) {
            this.drawCircle(this.invader.getPosition(), Color.Red);
        }
        this.spaceManager.onFrame(game, this.self, this);
        this.scanner.onFrame(game, this.self, this);
        this.strategyDetector.onFrame(game, this.self, bot);
        this.initTime = this.stopWatch.time();
        this.build.onFrame(game, this.self, this);
        for (DefensiveStructures structures : this.defensiveStructures) {
            structures.onFrame(game, this.self, this);
        }
        this.buildTime = this.stopWatch.time();
        for (UnitGroup group : this.groups) {
            group.onFrame(game, this.self, this);
        }
        this.unitGroupsTime = this.stopWatch.time();
        for (Unit unit : this.self.getUnits()) {
            Agent agent3 = this.agentMap.get(unit.getID());
            agent3.command.execute(game, this.self, bot);
            if (!agent3.unit.getType().isWorker()) continue;
            ((WorkerAgent)agent3).onFrame(game, this.self, bot);
        }
        this.agentTime = this.stopWatch.time();
        game.setTextSize(6);
        DebugMessages.addMessage("Reserved Minerals: " + this.reservedMinerals);
        DebugMessages.addMessage("Army: " + this.army.units.size());
        DebugMessages.addMessage("Workers: " + (this.workForce.units.size() + this.builders.units.size()));
        if (this.suspectedEnemy.size() != 1) {
            DebugMessages.addMessage("Suspected enemy bases: " + this.suspectedEnemy.size());
        }
        DebugMessages.addMessage("Bases: " + this.workForce.mineralWorkers.size());
        DebugMessages.addMessage("Frame count: " + game.getFrameCount());
        if (!BWTAInitializer.initialized) {
            DebugMessages.addMessage("Initializing BWTA.");
        }
        DebugMessages.addMessage("Initialization Time: " + this.initTime);
        DebugMessages.addMessage("Build Time: " + this.buildTime);
        DebugMessages.addMessage("Unit Groups Time: " + this.unitGroupsTime);
        DebugMessages.addMessage("Agent Time: " + this.agentTime);
        DebugMessages.toScreen(game);
        if (game.getFrameCount() <= 300) {
            game.drawTextScreen(230, 210, "Good luck, have fun!!! :D");
        }
    }

    @Override
    public void onEnd(boolean win) {
        DebugMessages.saveMessage(String.valueOf(win ? "win" : "loss") + " " + this.strategyDetector.opponentStrategy);
    }

    public void drawCircle(Position position, Color color, int r) {
        game.drawCircleMap(position.getX(), position.getY(), r, color);
    }

    public void drawCircle(Position position, Color color) {
        this.drawCircle(position, color, 10);
    }

    public int count(UnitType type) {
        Integer result = this.unitCounts.get(type);
        if (result == null) {
            return 0;
        }
        return result;
    }

    public Position getMainExit() {
        double distance;
        if (!BWTAInitializer.initialized) {
            return null;
        }
        if (this.mainExit != null) {
            return this.mainExit;
        }
        int baseCount = BWTA.getStartLocations().size();
        Region current = BWTA.getRegion(this.self.getStartLocation());
        if (current == null) {
            return null;
        }
        Position target = null;
        double bestDistance = -1.0;
        List<Chokepoint> chokepoints = current.getChokepoints();
        if (chokepoints == null) {
            return null;
        }
        if (chokepoints.size() == 1) {
            this.mainExit = chokepoints.get(0).getCenter();
            return this.mainExit;
        }
        for (Chokepoint choke : chokepoints) {
            distance = this.getClosestNeutralDistance(choke.getCenter());
            if (distance != -1.0 && distance < 128.0 && baseCount > 2) continue;
            distance = Math.min(choke.getX(), choke.getY());
            distance = Math.min(distance, (double)(game.mapWidth() * 32 - choke.getX()));
            if ((distance = Math.min(distance, (double)(game.mapHeight() * 32 - choke.getY()))) >= 1024.0 || target != null && !(distance > bestDistance)) continue;
            target = choke.getCenter();
            bestDistance = distance;
        }
        if (target == null) {
            for (Chokepoint choke : chokepoints) {
                distance = Math.min(choke.getX(), choke.getY());
                distance = Math.min(distance, (double)(game.mapWidth() * 32 - choke.getX()));
                distance = Math.min(distance, (double)(game.mapHeight() * 32 - choke.getY()));
                if (target != null && !(distance > bestDistance)) continue;
                target = choke.getCenter();
                bestDistance = distance;
            }
        }
        this.mainExit = target;
        return this.mainExit;
    }

    double getClosestNeutralDistance(Position pos) {
        double result = -1.0;
        for (EnemyPosition neutral : this.neutralStructures) {
            if (neutral.type == UnitType.Resource_Mineral_Field || neutral.type == UnitType.Resource_Mineral_Field_Type_2 || neutral.type == UnitType.Resource_Mineral_Field_Type_3 || neutral.type == UnitType.Resource_Vespene_Geyser) continue;
            double distance = pos.getDistance(neutral.pos);
            result = result == -1.0 ? distance : Math.min(result, distance);
        }
        return result;
    }

    public TilePosition addDefensePos(Unit builder, UnitType building, DefensiveStructures defenses) {
        for (Unit structure : defenses.defenses) {
            int x1;
            TilePosition pos = structure.getTilePosition();
            int dx = 1 - building.tileWidth();
            while (dx < building.tileWidth()) {
                x1 = pos.getX() + dx;
                int y1 = pos.getY() - building.tileHeight();
                int y2 = pos.getY() + structure.getType().tileHeight();
                if (this.canBuildHere(builder, x1, y1, building)) {
                    return new TilePosition(x1, y1);
                }
                if (this.canBuildHere(builder, x1, y2, building)) {
                    return new TilePosition(x1, y2);
                }
                ++dx;
            }
            int dy = 1 - building.tileHeight();
            while (dy < building.tileHeight()) {
                x1 = pos.getX() - building.tileWidth();
                int x2 = pos.getX() + structure.getType().tileWidth();
                int y1 = pos.getY() + dy;
                if (this.canBuildHere(builder, x1, y1, building)) {
                    return new TilePosition(x1, y1);
                }
                if (this.canBuildHere(builder, x2, y1, building)) {
                    return new TilePosition(x2, y1);
                }
                ++dy;
            }
        }
        return null;
    }

    public TilePosition getDefensePos(DefensiveStructures structures) {
        Position center = structures.getDefensePos();
        if (center == null) {
            return null;
        }
        double dist = center.getDistance(structures.defendedPosition);
        center = new Position((int)((double)center.getX() + (double)((structures.defendedPosition.getX() - center.getX()) * 100) / dist), (int)((double)center.getY() + (double)((structures.defendedPosition.getY() - center.getY()) * 100) / dist));
        return new TilePosition(center.getX() / 32, center.getY() / 32);
    }

    public static Unit findClosestMineral(Position p) {
        Unit closestMineral = null;
        for (Unit neutralUnit : game.neutral().getUnits()) {
            if (!neutralUnit.getType().isMineralField() || closestMineral != null && neutralUnit.getDistance(p) >= closestMineral.getDistance(p)) continue;
            closestMineral = neutralUnit;
        }
        return closestMineral;
    }

    public boolean buildDefensive(UnitType building, DefensiveStructures defensePos) {
        Agent worker;
        Position pos = defensePos.getDefensePos();
        if (pos == null) {
            pos = Tyr.tileToPostion(this.self.getStartLocation());
        }
        if ((worker = this.workForce.pop(pos)) == null) {
            return false;
        }
        TilePosition target = Tyr.positionToTile(defensePos.getDefensePos());
        if (target == null) {
            this.workForce.add(worker);
            return false;
        }
        TilePosition newDefensePos = this.addDefensePos(worker.unit, building, defensePos);
        if (newDefensePos != null) {
            BuildCommand com = new BuildCommand(worker, building, newDefensePos);
            this.buildCommands.add(com);
            this.spaceManager.reserveSpace(com);
            this.reservedMinerals += building.mineralPrice();
            this.reservedGas += building.gasPrice();
            worker.command = new BuildDefensive(worker, defensePos);
            return true;
        }
        TilePosition buildTile = this.getBuildTile(worker.unit, building, target);
        if (buildTile == null) {
            this.workForce.add(worker);
            return false;
        }
        worker.unit.move(new Position(buildTile.getX() * 32, buildTile.getY() * 32));
        BuildCommand com = new BuildCommand(worker, building, buildTile);
        this.buildCommands.add(com);
        this.spaceManager.reserveSpace(com);
        this.reservedMinerals += building.mineralPrice();
        this.reservedGas += building.gasPrice();
        worker.command = new BuildDefensive(worker, defensePos);
        return true;
    }

    public boolean build(UnitType building) {
        return this.build(building, null);
    }

    public boolean build(UnitType building, Position desiredPosition) {
        TilePosition buildTile;
        TilePosition target;
        Agent worker = this.workForce.pop(desiredPosition == null ? Tyr.tileToPostion(this.self.getStartLocation()) : desiredPosition);
        if (worker == null) {
            return false;
        }
        BuildCommand com = null;
        if (this.wallOff != null) {
            com = this.wallOff.getCommand(building);
        }
        if (com != null) {
            com.worker = worker;
            worker.unit.move(new Position(com.position.getX() * 32, com.position.getY() * 32));
            this.spaceManager.reserveSpace(com);
            this.reservedMinerals += building.mineralPrice();
            this.reservedGas += building.gasPrice();
            return true;
        }
        if ((desiredPosition == null && building == UnitType.Terran_Supply_Depot || building == UnitType.Terran_Armory || building == UnitType.Terran_Academy) && (target = this.spaceManager.findDepotPlacement(worker.unit)) != null) {
            worker.unit.move(new Position(target.getX() * 32, target.getY() * 32));
            com = new BuildCommand(worker, building, target);
            this.buildCommands.add(com);
            this.spaceManager.reserveSpace(com);
            this.reservedMinerals += building.mineralPrice();
            this.reservedGas += building.gasPrice();
            return true;
        }
        target = desiredPosition == null ? (game.isVisible(this.self.getStartLocation()) ? this.self.getStartLocation() : (this.workForce.mineralWorkers.size() > 0 ? this.workForce.mineralWorkers.get((int)0).resourceDepot.getTilePosition() : worker.unit.getTilePosition())) : Tyr.positionToTile(desiredPosition);
        if (!game.isVisible(target)) {
            buildTile = target;
            System.out.println("Build position not yet visible: " + target.getX() + ", " + target.getY());
        } else {
            buildTile = this.getBuildTile(worker.unit, building, target);
        }
        if (buildTile == null) {
            this.workForce.add(worker);
            return false;
        }
        this.builders.add(worker);
        if (building.isResourceDepot()) {
            List<Unit> inRange = game.getUnitsInRadius(Tyr.tileToPostion(buildTile), 270);
            boolean success = false;
            for (Unit mineral : inRange) {
                if (!mineral.getType().isMineralField()) continue;
                worker.unit.gather(mineral);
                success = true;
                break;
            }
            if (!success) {
                worker.unit.move(Tyr.tileToPostion(buildTile));
            }
        }
        worker.unit.move(new Position(buildTile.getX() * 32, buildTile.getY() * 32));
        com = new BuildCommand(worker, building, buildTile);
        this.buildCommands.add(com);
        this.spaceManager.reserveSpace(com);
        this.reservedMinerals += building.mineralPrice();
        this.reservedGas += building.gasPrice();
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public TilePosition getBuildTile(Unit builder, UnitType buildingType, TilePosition aroundTile) {
        ret = null;
        maxDist = 3;
        stopDist = 40;
        if (buildingType.isRefinery()) {
            for (Unit n : Tyr.game.neutral().getUnits()) {
                if (n.getType() != UnitType.Resource_Vespene_Geyser) continue;
                hasBase = false;
                for (MineralWorkers base : this.workForce.mineralWorkers) {
                    if (!(base.resourceDepot.distanceTo(n) <= 270.0)) continue;
                    hasBase = true;
                    break;
                }
                if (!hasBase) continue;
                return n.getTilePosition();
            }
        }
        if (buildingType.isResourceDepot()) {
            loc = null;
            for (BaseLocation b : this.expands) {
                if (!Tyr.game.canBuildHere(builder, b.getTilePosition(), buildingType, false)) continue;
                enemyBase = false;
                for (EnemyPosition p : this.enemyBuildingMemory) {
                    v0 = enemyBase = b.getPosition().distanceTo(p.pos.getX(), p.pos.getY()) < 256.0;
                    if (enemyBase) break;
                }
                if (enemyBase) continue;
                unitsInWay = false;
                for (BuildCommand cmd : this.buildCommands) {
                    if (!(cmd.position.getDistance(b.getTilePosition()) <= 1.0)) continue;
                    unitsInWay = true;
                    break;
                }
                if (unitsInWay || loc != null && !(BWTA.getGroundDistance(aroundTile, b.getTilePosition()) < BWTA.getGroundDistance(aroundTile, loc.getTilePosition()))) continue;
                loc = b;
            }
            return loc == null ? null : loc.getTilePosition();
        }
        if (Tyr.game.isVisible(aroundTile)) ** GOTO lbl46
        return aroundTile;
lbl-1000:
        // 1 sources

        {
            i = aroundTile.getX() - maxDist;
            while (i <= aroundTile.getX() + maxDist) {
                j = aroundTile.getY() - maxDist;
                while (j <= aroundTile.getY() + maxDist) {
                    if (this.canBuildHere(builder, i, j, buildingType)) {
                        return new TilePosition(i, j);
                    }
                    ++j;
                }
                ++i;
            }
            maxDist += 2;
lbl46:
            // 2 sources

            ** while (maxDist < stopDist && ret == null)
        }
lbl47:
        // 1 sources

        return ret;
    }

    public boolean canBuildHere(Unit builder, int i, int j, UnitType building) {
        if (!this.spaceManager.canBuildHere(builder, new TilePosition(i, j), building) || building.canBuildAddon() && !this.spaceManager.canBuildHere(builder, new TilePosition(i + 2, j), building)) {
            return false;
        }
        if (building.requiresCreep()) {
            boolean creepMissing = false;
            int k = i;
            while (k <= i + building.tileWidth()) {
                int l = j;
                while (l <= j + building.tileHeight()) {
                    if (!game.hasCreep(k, l)) {
                        creepMissing = true;
                        break;
                    }
                    ++l;
                }
                ++k;
            }
            if (creepMissing) {
                return false;
            }
        }
        TilePosition tilePosition = new TilePosition(i, j);
        if (bot.getMainExit().getDistance(Tyr.tileToPostion(tilePosition)) <= 64.0) {
            return false;
        }
        for (Unit u : game.getAllUnits()) {
            if (u.getID() == builder.getID() || (building == UnitType.Terran_Bunker || building == UnitType.Terran_Missile_Turret) && (u.getType() == UnitType.Terran_Bunker || u.getType() == UnitType.Terran_Missile_Turret) || building == UnitType.Terran_Supply_Depot && (u.getType() == UnitType.Terran_Supply_Depot || u.getType() == UnitType.Terran_Armory || u.getType() == UnitType.Terran_Academy) || u.getTilePosition().getX() - i >= building.tileWidth() + 1 || i - u.getTilePosition().getX() >= u.getType().tileWidth() + 1 || u.getTilePosition().getY() - j >= building.tileHeight() + 1 || j - u.getTilePosition().getY() >= u.getType().tileHeight() + 1) continue;
            return false;
        }
        return true;
    }

    public static Position tileToPostion(TilePosition pos) {
        return new Position(pos.getX() * 32 + 16, pos.getY() * 32 + 16);
    }

    public static TilePosition positionToTile(Position pos) {
        return new TilePosition(pos.getX() / 32, pos.getY() / 32);
    }

    public static void main(String[] args) {
        bot = new Tyr();
        bot.run();
    }
}

