/*
 * Decompiled with CFR 0.152.
 */
import bwapi.Color;
import bwapi.Game;
import bwapi.Player;
import bwapi.Position;
import bwapi.Unit;
import bwapi.UnitType;
import bwta.BWTA;
import bwta.BaseLocation;
import bwta.Region;
import java.util.Iterator;

public class TankForce
extends UnitGroup {
    public OutOfJob outOfJob = new OutOfJob();
    public Position rallyPoint = null;
    Position target = null;

    public TankForce(OutOfJob rejects) {
        super(rejects);
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        if (BWTAInitializer.initialized) {
            this.acquireTarget(bot);
            if (this.target == null) {
                this.target = bot.army.rallyPoint != null ? bot.army.rallyPoint : bot.getMainExit();
            }
            for (Agent agent : this.units) {
                agent.drawCircle(Color.Yellow);
                if (agent.unit.isIdle() || bot.defenseTime == 0) {
                    agent.unit.attack(this.target);
                }
                boolean targetExists = false;
                int radius = UnitType.Terran_Siege_Tank_Siege_Mode.groundWeapon().maxRange();
                for (Unit unit : Tyr.game.enemy().getUnits()) {
                    if (unit.getType().isFlyer() || unit.isLifted() || agent.distanceSquared(unit) > radius * radius) continue;
                    targetExists = true;
                    break;
                }
                if (agent.unit.getType() == UnitType.Terran_Siege_Tank_Tank_Mode) {
                    if (!targetExists) continue;
                    agent.unit.siege();
                    continue;
                }
                if (agent.unit.getType() != UnitType.Terran_Siege_Tank_Siege_Mode || targetExists) continue;
                agent.unit.unsiege();
            }
        }
    }

    public void acquireTarget(Tyr bot) {
        Region end = null;
        this.target = null;
        Iterator<Object> iterator = bot.enemyBuildingMemory.iterator();
        while (iterator.hasNext()) {
            EnemyPosition p = iterator.next();
            this.target = p.pos;
            end = BWTA.getRegion(p.pos);
        }
        if (end == null && (iterator = bot.suspectedEnemy.iterator()).hasNext()) {
            BaseLocation b = (BaseLocation)iterator.next();
            this.target = b.getPosition();
            end = b.getRegion();
        }
    }

    @Override
    public void add(Agent agent) {
        super.add(agent);
        this.outOfJob.add(agent);
    }
}

