/*
 * Decompiled with CFR 0.152.
 */
import bwapi.Game;
import bwapi.Player;
import bwapi.Position;
import bwapi.TilePosition;

public class TankDefense
extends UnitGroup {
    public OutOfJob outOfJob = new OutOfJob();
    public Position rallyPoint = null;
    Position target = null;
    public int defensiveTanks = 2;

    public TankDefense(OutOfJob rejects, Position target) {
        super(rejects);
        this.target = target;
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        if (this.target == null && bot.defensiveStructures.get((int)0).defenses.size() > 0) {
            this.target = bot.defensiveStructures.get((int)0).defenses.get(0).getPosition();
        } else if (this.target == null) {
            this.target = bot.army.rallyPoint;
        } else if (this.target == null) {
            this.target = bot.getMainExit();
        }
        for (Agent agent : this.units) {
            if (agent.command.getClass() == DefensiveTank.class) continue;
            agent.order(new DefensiveTank(agent, this.getPosition(game, self, bot, Tyr.positionToTile(this.target))));
        }
    }

    private Position getPosition(Game game, Player self, Tyr bot, TilePosition aroundTile) {
        if (!BWTAInitializer.initialized) {
            return Tyr.tileToPostion(aroundTile);
        }
        int dist = 0;
        while (dist < 10) {
            int i = -dist;
            while (i <= dist) {
                if (this.checkTile(game, self, bot, new TilePosition(aroundTile.getX() + i, aroundTile.getY() - dist))) {
                    return Tyr.tileToPostion(new TilePosition(aroundTile.getX() + i, aroundTile.getY() - dist));
                }
                if (this.checkTile(game, self, bot, new TilePosition(aroundTile.getX() - dist, aroundTile.getY() + i))) {
                    return Tyr.tileToPostion(new TilePosition(aroundTile.getX() - dist, aroundTile.getY() + i));
                }
                if (this.checkTile(game, self, bot, new TilePosition(aroundTile.getX() + i, aroundTile.getY() + dist))) {
                    return Tyr.tileToPostion(new TilePosition(aroundTile.getX() + i, aroundTile.getY() + dist));
                }
                if (this.checkTile(game, self, bot, new TilePosition(aroundTile.getX() + dist, aroundTile.getY() + i))) {
                    return Tyr.tileToPostion(new TilePosition(aroundTile.getX() + dist, aroundTile.getY() + i));
                }
                ++i;
            }
            ++dist;
        }
        return Tyr.tileToPostion(aroundTile);
    }

    private boolean checkTile(Game game, Player self, Tyr bot, TilePosition pos) {
        for (DefensiveStructures structures : bot.defensiveStructures) {
            for (Agent tank : structures.tanks.units) {
                if (tank.command.getClass() != DefensiveTank.class) continue;
                DefensiveTank defensive = (DefensiveTank)tank.command;
                TilePosition defendedTile = Tyr.positionToTile(defensive.target);
                if (Math.abs(defendedTile.getX() - pos.getX()) > 1 || Math.abs(defendedTile.getY() - pos.getY()) > 1) continue;
                return false;
            }
        }
        int dx = -1;
        while (dx <= 1) {
            int dy = -1;
            while (dy <= 1) {
                if (pos.getX() + dx < 0 || pos.getY() + dy < 0 || pos.getX() + dx >= game.mapWidth() || pos.getY() + dy >= game.mapHeight() || bot.spaceManager.map[pos.getX() + dx][pos.getY() + dy] != 1) {
                    return false;
                }
                ++dy;
            }
            ++dx;
        }
        return true;
    }

    @Override
    public void add(Agent agent) {
        super.add(agent);
        this.outOfJob.add(agent);
    }

    public void disable() {
        this.defensiveTanks = 0;
        while (this.units.size() > 0) {
            Agent agent = (Agent)this.units.get(this.units.size() - 1);
            this.units.remove(this.units.size() - 1);
            this.rejects.add(agent);
        }
    }
}

