/*
 * Decompiled with CFR 0.152.
 */
import bwapi.Game;
import bwapi.Player;
import bwapi.TilePosition;
import bwapi.Unit;
import bwapi.UnitType;
import bwta.BWTA;
import bwta.BaseLocation;
import bwta.Region;
import java.util.ArrayList;

public class SpaceManager {
    public int[][] map;
    public int width;
    public int height;
    Game game;
    ArrayList<TilePosition> potentialDepots = new ArrayList();
    static final boolean debug = false;
    private int x = 0;

    public SpaceManager(Game game) {
        this.width = game.mapWidth();
        this.height = game.mapHeight();
        this.game = game;
        this.map = new int[this.width][this.height];
        int x = 0;
        while (x < this.width) {
            int y = 0;
            while (y < this.height) {
                if (game.isBuildable(x, y)) {
                    this.map[x][y] = 1;
                }
                ++y;
            }
            ++x;
        }
    }

    public void onFrame(Game game, Player self, Tyr bot) {
        int x = 0;
        while (x < this.width) {
            int y = 0;
            while (y < this.height) {
                if (this.map[x][y] != 0 && this.map[x][y] != 3) {
                    this.map[x][y] = 1;
                }
                ++y;
            }
            ++x;
        }
        for (Unit neutralUnit : game.getNeutralUnits()) {
            this.reserveSpace(neutralUnit);
        }
        for (Unit myUnit : self.getUnits()) {
            if (!myUnit.getType().isBuilding() || myUnit.isLifted()) continue;
            this.reserveSpace(myUnit);
        }
        for (BuildCommand com : bot.buildCommands) {
            this.reserveSpace(com);
        }
        if (bot.wallOff != null && bot.wallOff.placementFound) {
            for (BuildCommand com : bot.wallOff.buildPlan) {
                this.reserveSpace(com);
            }
            for (BuildCommand com : bot.wallOff.underConstruction) {
                this.reserveSpace(com);
            }
        }
        this.findDepots(game, self, bot);
    }

    private void findDepots(Game game, Player self, Tyr bot) {
        Unit worker;
        if (!BWTAInitializer.initialized) {
            return;
        }
        if (bot.workForce.mineralWorkers.size() == 0 || bot.workForce.mineralWorkers.get((int)0).units.size() == 0) {
            return;
        }
        if (this.x >= game.mapWidth()) {
            return;
        }
        try {
            worker = ((Agent)bot.workForce.mineralWorkers.get((int)0).units.get((int)0)).unit;
        }
        catch (NullPointerException e) {
            return;
        }
        TilePosition start = self.getStartLocation();
        if (start == null) {
            DebugMessages.addMessage("Startlocation is null!");
            return;
        }
        Region startRegion = BWTA.getRegion(start);
        if (startRegion == null) {
            DebugMessages.addMessage("Startregion is null!");
            return;
        }
        int y = 0;
        while (y < game.mapHeight()) {
            TilePosition pos = new TilePosition(this.x, y);
            Region depotRegion = BWTA.getRegion(pos);
            if (depotRegion != null && depotRegion.equals(startRegion) && this.canBuildHere(worker, pos, UnitType.Terran_Supply_Depot)) {
                this.potentialDepots.add(pos);
            }
            y += 2;
        }
        this.x += 3;
    }

    public TilePosition findDepotPlacement(Unit builder) {
        if (!BWTAInitializer.initialized) {
            return null;
        }
        if (this.potentialDepots.size() == 0) {
            return null;
        }
        if (!this.game.isVisible(this.game.self().getStartLocation())) {
            return null;
        }
        int bestDist = 0;
        TilePosition result = null;
        TilePosition mainExit = Tyr.positionToTile(Tyr.bot.getMainExit());
        for (TilePosition pos : this.potentialDepots) {
            int newDist;
            if (!Tyr.bot.canBuildHere(builder, pos.getX(), pos.getY(), UnitType.Terran_Supply_Depot) || (newDist = Math.abs(pos.getX() - mainExit.getX()) + Math.abs(pos.getY() - mainExit.getY())) <= bestDist) continue;
            bestDist = newDist;
            result = pos;
        }
        if (result != null) {
            this.potentialDepots.remove(result);
        }
        return result;
    }

    public void reserveSpace(Unit unit) {
        this.reserveSpace(unit.getTilePosition(), unit.getType());
    }

    public void reserveSpace(BuildCommand com) {
        this.reserveSpace(com.position, com.building);
    }

    public void reserveSpace(TilePosition pos, UnitType building) {
        int dy;
        int dx;
        if (building.canBuildAddon()) {
            dx = 0;
            while (dx < 2) {
                dy = 0;
                while (dy < 2) {
                    this.map[pos.getX() + building.tileWidth() + dx][pos.getY() + building.tileHeight() - 2 + dy] = 2;
                    ++dy;
                }
                ++dx;
            }
        }
        dx = 0;
        while (dx < building.tileWidth()) {
            dy = 0;
            while (dy < building.tileHeight()) {
                this.map[pos.getX() + dx][pos.getY() + dy] = building.isNeutral() ? 3 : 2;
                ++dy;
            }
            ++dx;
        }
    }

    public boolean canBuildHere(Unit builder, TilePosition pos, UnitType building) {
        int dy;
        if (pos.getX() < 0 || pos.getY() < 0 || pos.getX() + building.tileWidth() >= this.width || pos.getY() + building.tileHeight() >= this.height) {
            return false;
        }
        int dx = 0;
        while (dx < building.tileWidth()) {
            dy = 0;
            while (dy < building.tileHeight()) {
                if (this.map[pos.getX() + dx][pos.getY() + dy] != 1) {
                    return false;
                }
                ++dy;
            }
            ++dx;
        }
        if (building.canBuildAddon()) {
            if (pos.getX() + building.tileWidth() + 2 >= this.width) {
                return false;
            }
            dx = 0;
            while (dx < 2) {
                dy = 0;
                while (dy < 2) {
                    if (this.map[pos.getX() + building.tileWidth() + dx][pos.getY() + building.tileHeight() - 2 + dy] != 1) {
                        return false;
                    }
                    ++dy;
                }
                ++dx;
            }
        }
        if (!building.isResourceDepot()) {
            for (BaseLocation loc : Tyr.bot.expands) {
                TilePosition locpos = loc.getTilePosition();
                if (pos.getX() + building.tileWidth() <= locpos.getX() - 1 || pos.getX() > locpos.getX() + UnitType.Terran_Command_Center.tileWidth() + 3 || pos.getY() + building.tileHeight() <= locpos.getY() - 1 || pos.getY() > locpos.getY() + UnitType.Terran_Command_Center.tileHeight() + 1) continue;
                return false;
            }
        }
        return this.game.canBuildHere(builder, pos, building, false);
    }
}

