/*
 * Decompiled with CFR 0.152.
 */
import bwapi.Game;
import bwapi.Player;
import bwapi.TilePosition;
import bwapi.UnitType;
import java.util.ArrayList;

public class Scanner {
    private int[][] state;
    private int scans = 0;
    private int row = 0;
    private int unseen = 0;
    final int rowsPerStep = 2;
    public static final int Initializing = 0;
    public static final int Scanning = 1;
    public static final int Eliminating = 2;
    public int action = 0;
    private int width;
    private int height;
    private ArrayList<Agent> groundUnits = new ArrayList();
    private ArrayList<Agent> airUnits = new ArrayList();

    public Scanner(Game game) {
        this.state = new int[game.mapWidth()][];
        this.width = game.mapWidth();
        this.height = game.mapHeight();
    }

    public void onFrame(Game game, Player self, Tyr bot) {
        if (!BWTAInitializer.initialized) {
            return;
        }
        int i = 0;
        while (i < 2) {
            if (this.action == 0) {
                this.initialize(game, self, bot);
            } else if (this.action == 1) {
                this.scan(game, self, bot);
            } else if (this.action == 2) {
                this.eliminate(game, self, bot);
            }
            if (this.incrementRow()) {
                if (this.unseen == 0) {
                    ++this.scans;
                }
                this.unseen = 0;
            }
            ++i;
        }
    }

    private boolean incrementRow() {
        ++this.row;
        if (this.row >= this.width) {
            this.row = 0;
        }
        return this.row == 0;
    }

    private void initialize(Game game, Player self, Tyr bot) {
        this.state[this.row] = new int[this.height];
        if (this.row >= this.width - 1) {
            this.action = 1;
        }
    }

    private void scan(Game game, Player self, Tyr bot) {
        int y = 0;
        while (y < this.height) {
            if (this.state[this.row][y] != this.scans) {
                if (game.isVisible(new TilePosition(this.row, y))) {
                    this.state[this.row][y] = this.scans;
                } else {
                    ++this.unseen;
                }
            }
            ++y;
        }
    }

    private void eliminate(Game game, Player self, Tyr bot) {
        this.scan(game, self, bot);
        if (bot.invader != null || bot.enemyBuildingMemory.size() > 0) {
            return;
        }
        int groundPos = this.nextGroundPos(-1);
        int airPos = this.nextAirPos(-1);
        int y = 0;
        while (y < this.height) {
            if (this.state[this.row][y] != this.scans) {
                boolean walkable = false;
                int dx = 0;
                while (!walkable && dx < 4) {
                    int dy = 0;
                    while (!walkable && dy < 4) {
                        if (game.isWalkable(this.row * 4 + dx, y * 4 + dy)) {
                            walkable = true;
                            break;
                        }
                        ++dy;
                    }
                    ++dx;
                }
                if (walkable) {
                    if (groundPos < this.groundUnits.size()) {
                        Agent agent = this.groundUnits.get(groundPos);
                        agent.order(new None(agent));
                        agent.unit.attack(Tyr.tileToPostion(new TilePosition(this.row, Math.min(y + 2, game.mapHeight()))));
                        groundPos = this.nextGroundPos(groundPos);
                        y += 5;
                    }
                } else if (airPos < this.airUnits.size()) {
                    Agent agent = this.airUnits.get(airPos);
                    agent.order(new None(agent));
                    agent.unit.attack(Tyr.tileToPostion(new TilePosition(this.row, Math.min(y + 2, game.mapHeight()))));
                    airPos = this.nextAirPos(airPos);
                    y += 5;
                }
            }
            ++y;
        }
    }

    private int nextGroundPos(int i) {
        ++i;
        while (i < this.groundUnits.size() && !this.groundUnits.get((int)i).unit.isIdle()) {
            ++i;
        }
        return i;
    }

    private int nextAirPos(int i) {
        ++i;
        while (i < this.airUnits.size() && !this.airUnits.get((int)i).unit.isIdle()) {
            ++i;
        }
        return i;
    }

    public void startElimination() {
        this.action = 2;
        if (Tyr.bot.count(UnitType.Terran_Factory) == 0) {
            Tyr.bot.build(UnitType.Terran_Factory);
        }
        if (Tyr.bot.count(UnitType.Terran_Refinery) == 0) {
            Tyr.bot.build(UnitType.Terran_Refinery);
        }
        if (Tyr.bot.count(UnitType.Terran_Starport) == 0) {
            Tyr.bot.build(UnitType.Terran_Starport);
        }
    }

    public void addAir(Agent agent) {
        this.airUnits.add(agent);
        agent.command = new None(agent);
    }

    public void addGround(Agent agent) {
        this.groundUnits.add(agent);
        agent.command = new None(agent);
    }
}

