/*
 * Decompiled with CFR 0.152.
 */
import bwapi.Game;
import bwapi.Player;
import bwapi.Race;
import java.util.ArrayList;

public class PlayerProfile {
    private Race race;
    private String[][] names;
    private BuildOrder counter;
    private int opponentStrategy;
    private int scoutTiming;
    private int nscouts;
    public boolean triggerDebug = false;

    public PlayerProfile(Race race, BuildOrder counter, String name) {
        this(race, counter, new String[][]{{name}});
    }

    public PlayerProfile(Race race, BuildOrder counter, String[][] names) {
        this(race, counter, names, ScoutGroup.unknown);
    }

    public PlayerProfile(Race race, BuildOrder counter, String[][] names, int opponentStrategy) {
        this(race, counter, names, opponentStrategy, -1, 0);
    }

    public PlayerProfile(Race race, BuildOrder counter, String[][] names, int opponentStrategy, int scoutTiming, int nscouts) {
        this.race = race;
        this.names = names;
        this.counter = counter;
        int i = 0;
        while (i < names.length) {
            int j = 0;
            while (j < names[i].length) {
                names[i][j] = names[i][j].toLowerCase();
                ++j;
            }
            ++i;
        }
        this.opponentStrategy = opponentStrategy;
        this.scoutTiming = scoutTiming;
        this.nscouts = nscouts;
    }

    public boolean match(Game game, Tyr bot) {
        Player enemy = game.enemy();
        if (enemy.getRace() != this.race) {
            return false;
        }
        String nameLower = enemy.getName().toLowerCase();
        String[][] stringArray = this.names;
        int n = this.names.length;
        int n2 = 0;
        while (n2 < n) {
            String[] name = stringArray[n2];
            boolean matches = true;
            String[] stringArray2 = name;
            int n3 = name.length;
            int n4 = 0;
            while (n4 < n3) {
                String namePart = stringArray2[n4];
                if (!nameLower.contains(namePart)) {
                    matches = false;
                    break;
                }
                ++n4;
            }
            if (this.triggerDebug) {
                matches = true;
            }
            if (matches) {
                bot.build = this.counter;
                bot.scout.opponentStrategy = this.opponentStrategy;
                if (this.nscouts != 0) {
                    bot.scout.nscouts = this.nscouts;
                    bot.scout.workerScoutTiming = this.scoutTiming;
                }
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static ArrayList<PlayerProfile> getProfiles() {
        ArrayList<PlayerProfile> result = new ArrayList<PlayerProfile>();
        result.add(new PlayerProfile(Race.Protoss, new TvP(), new String[][]{{"Tomas", "Vajda"}, {"Thomas", "Vajda"}, {"XIMP"}}, ScoutGroup.cannons));
        result.add(new PlayerProfile(Race.Protoss, new TvP(), new String[][]{{"Jakub", "Trancik"}}, ScoutGroup.cannons));
        result.add(new PlayerProfile(Race.Protoss, (BuildOrder)new TwoBaseMech(), new String[][]{{"Aiur"}, {"Florian", "Richoux"}}));
        result.add(new PlayerProfile(Race.Protoss, new TvP(), new String[][]{{"Black", "White"}}, ScoutGroup.zealotPush));
        result.add(new PlayerProfile(Race.Protoss, (BuildOrder)new Mech(), new String[][]{{"Odin"}}));
        result.add(new PlayerProfile(Race.Protoss, new TvP(), new String[][]{{"Soeren", "Klett"}, {"Soren", "Klett"}, {"S\u00f6ren", "Klett"}}, ScoutGroup.zealotPush));
        result.add(new PlayerProfile(Race.Protoss, new TvP(), new String[][]{{"Dave", "Churchill"}, {"ualbertabot"}}, ScoutGroup.zealotPush));
        result.add(new PlayerProfile(Race.Protoss, new DefensiveBC(), new String[][]{{"Ian", "DaCosta"}}, ScoutGroup.unknown));
        result.add(new PlayerProfile(Race.Protoss, new TvP(), new String[][]{{"Carsten", "Nielsen"}}, ScoutGroup.zealotPush));
        result.add(new PlayerProfile(Race.Terran, (BuildOrder)new DefensiveBC(), new String[][]{{"Marek", "Kadek"}}));
        result.add(new PlayerProfile(Race.Terran, (BuildOrder)new GreedyBC(), new String[][]{{"Matej", "Istenik"}}));
        result.add(new PlayerProfile(Race.Terran, (BuildOrder)new GreedyBC(), new String[][]{{"Igor", "Lacik"}}));
        result.add(new PlayerProfile(Race.Terran, (BuildOrder)new GreedyBC(), new String[][]{{"Rafal", "Poniatowski"}}));
        result.add(new PlayerProfile(Race.Terran, new Mech(), new String[][]{{"tscmoo"}}, ScoutGroup.unknown));
        result.add(new PlayerProfile(Race.Terran, (BuildOrder)new BBS(), new String[][]{{"ICE"}}));
        result.add(new PlayerProfile(Race.Terran, new GreedyBC(), new String[][]{{"Krasimir", "Krystev"}, {"Krasibot"}, {"Krasi0bot"}}, ScoutGroup.unknown));
        result.add(new PlayerProfile(Race.Terran, new DefensiveBC(), new String[][]{{"Martin", "Rooijackers"}, {"LetaBot"}}, ScoutGroup.unknown));
        result.add(new PlayerProfile(Race.Zerg, new DefensiveBC(), new String[][]{{"tscmooz"}}, ScoutGroup.unknown));
        return result;
    }
}

