/*
 * Decompiled with CFR 0.152.
 */
import bwapi.Color;
import bwapi.Game;
import bwapi.Player;
import bwapi.Position;
import bwapi.Unit;
import bwapi.UnitType;
import java.util.ArrayList;

public class MineralWorkers
extends UnitGroup {
    Unit resourceDepot;
    ArrayList<Unit> minerals = new ArrayList();
    GasWorkers gasWorkers;
    int currentMineral = -1;
    public Position defensePos;
    DefensiveStructures defenses = null;

    public MineralWorkers(OutOfJob rejects, Unit resourceDepot) {
        super(rejects);
        this.resourceDepot = resourceDepot;
        for (Unit neutralUnit : Tyr.game.neutral().getUnits()) {
            if (neutralUnit.getType().isMineralField() && neutralUnit.getDistance(resourceDepot) <= 270) {
                this.minerals.add(neutralUnit);
                continue;
            }
            if (neutralUnit.getType() != UnitType.Resource_Vespene_Geyser || neutralUnit.getDistance(resourceDepot) > 270) continue;
            this.gasWorkers = new GasWorkers(rejects, neutralUnit);
        }
        if (resourceDepot == null || resourceDepot.getDistance(Tyr.tileToPostion(Tyr.game.self().getStartLocation())) < 64) {
            this.defensePos = null;
        } else {
            int totalX = 0;
            int totalY = 0;
            for (Unit mineral : this.minerals) {
                totalX += mineral.getPosition().getX();
                totalY += mineral.getPosition().getY();
            }
            this.defensePos = this.minerals.size() != 0 ? new Position(totalX / this.minerals.size(), totalY / this.minerals.size()) : new Position(resourceDepot.getPosition().getX(), resourceDepot.getPosition().getY());
            this.defensePos = new Position(2 * resourceDepot.getPosition().getX() - this.defensePos.getX(), 2 * resourceDepot.getPosition().getY() - this.defensePos.getY());
        }
        boolean exists = false;
        for (DefensiveStructures structures : Tyr.bot.defensiveStructures) {
            if (resourceDepot.getDistance(structures.defendedPosition) >= 64) continue;
            exists = true;
            this.defenses = structures;
            break;
        }
        if (!exists) {
            this.defenses = new DefensiveStructures(resourceDepot.getPosition(), this.defensePos);
            Tyr.bot.defensiveStructures.add(this.defenses);
        }
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        for (Unit neutralUnit : Tyr.game.neutral().getUnits()) {
            if (neutralUnit.getType().isMineralField() && neutralUnit.getDistance(this.resourceDepot) <= 270) {
                if (this.minerals.contains(neutralUnit)) continue;
                this.minerals.add(neutralUnit);
                continue;
            }
            if (this.gasWorkers != null || neutralUnit.getType() != UnitType.Resource_Vespene_Geyser || neutralUnit.getDistance(this.resourceDepot) > 270) continue;
            this.gasWorkers = new GasWorkers(this.rejects, neutralUnit);
        }
        if (this.defensePos != null) {
            bot.drawCircle(this.defensePos, Color.Green, 64);
        }
        int i = this.minerals.size() - 1;
        while (i >= 0) {
            if (!this.minerals.get(i).exists()) {
                this.minerals.remove(i);
            } else {
                bot.drawCircle(this.minerals.get(i).getPosition(), Color.Teal, 16);
            }
            --i;
        }
        if (this.minerals.size() == 0) {
            if (this.defenses != null && this.defenses.defendedPosition.getDistance(Tyr.tileToPostion(self.getStartLocation())) >= 200.0) {
                this.defenses.disable();
                this.defenses = null;
            }
            return;
        }
        for (Agent worker : this.units) {
            worker.drawCircle(Color.Cyan);
            if (!worker.unit.isIdle() && !worker.unit.isGatheringGas()) continue;
            worker.unit.gather(this.minerals.get(this.incrementMineralNode()), false);
        }
        if (this.gasWorkers != null && this.gasWorkers.geyser.getResources() == 0 && this.gasWorkers.geyser.getType().isRefinery()) {
            for (Agent unit : this.gasWorkers.units) {
                this.add(unit);
            }
            this.gasWorkers = null;
        } else if (this.gasWorkers != null) {
            while (this.gasWorkers.geyser.isCompleted() && this.gasWorkers.units.size() < bot.workersPerGas && this.gasWorkers.geyser.getType().isRefinery()) {
                Agent gasWorker = this.pop(this.gasWorkers.geyser.getPosition());
                if (gasWorker == null) break;
                this.remove(gasWorker);
                this.gasWorkers.add(gasWorker);
            }
            this.gasWorkers.onFrame(game, self, bot);
        }
    }

    private int incrementMineralNode() {
        ++this.currentMineral;
        this.currentMineral %= this.minerals.size();
        return this.currentMineral;
    }

    @Override
    public Agent pop() {
        int i = this.units.size() - 1;
        while (i >= 0) {
            if (!((WorkerAgent)this.units.get((int)i)).isReset && !((Agent)this.units.get((int)i)).unit.isConstructing() && ((Agent)this.units.get(i)).distanceSquared(this.resourceDepot.getPosition()) <= 0x144000) {
                Agent result = (Agent)this.units.get(i);
                this.remove(i);
                return result;
            }
            --i;
        }
        return null;
    }

    public Agent pop(Position pos) {
        Agent result = null;
        double distance = Double.MAX_VALUE;
        for (Agent worker : this.units) {
            int newDist;
            if (((WorkerAgent)worker).isReset || worker.unit.isConstructing() || !((double)(newDist = worker.distanceSquared(pos)) < distance)) continue;
            distance = newDist;
            result = worker;
        }
        return result;
    }

    @Override
    public void add(Agent agent) {
        if (agent == null) {
            return;
        }
        if (agent.unit == null) {
            return;
        }
        super.add(agent);
        if (agent.unit.isConstructing()) {
            return;
        }
        if (this.minerals.size() != 0) {
            agent.unit.gather(this.minerals.get(this.incrementMineralNode()), false);
        }
    }

    @Override
    public void cleanup() {
        super.cleanup();
        int i = this.minerals.size() - 1;
        while (i >= 0) {
            if (!this.minerals.get(i).exists() || this.minerals.get(i).getResources() <= 0) {
                this.minerals.remove(i);
            }
            --i;
        }
        if (this.minerals.size() == 0) {
            for (Agent unit : this.units) {
                this.rejects.add(unit);
            }
            this.units = new ArrayList();
        }
        if (this.gasWorkers != null) {
            this.gasWorkers.cleanup();
        }
    }
}

