/*
 * Decompiled with CFR 0.152.
 */
import bwapi.Color;
import bwapi.Game;
import bwapi.Order;
import bwapi.Player;
import bwapi.Position;
import bwapi.Unit;
import bwapi.UnitType;
import bwta.BaseLocation;
import java.util.ArrayList;
import java.util.HashMap;

public class DropHarass
extends UnitGroup {
    private Agent dropship;
    int mode = 0;
    private static final int gather = 0;
    private static final int load = 1;
    private static final int moveOut = 2;
    private static final int drop = 3;
    private ArrayList<Position> targets = null;
    private int targetPos = -1;
    private Position target = null;
    private static ArrayList<Position> leftTargets;
    private static ArrayList<Position> rightTargets;
    private static boolean goLeft;
    private static boolean debug;

    static {
        goLeft = true;
        debug = false;
    }

    public DropHarass(OutOfJob rejects) {
        super(rejects);
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        if (leftTargets == null) {
            this.createTargetOrder(bot);
        }
        if (debug && leftTargets != null) {
            int i = 1;
            while (i < leftTargets.size()) {
                game.drawLineMap(leftTargets.get(i - 1).getX(), leftTargets.get(i - 1).getY(), leftTargets.get(i).getX(), leftTargets.get(i).getY(), Color.Red);
                game.drawTextMap(leftTargets.get(i - 1).getX(), leftTargets.get(i - 1).getY(), String.valueOf(i - 1));
                ++i;
            }
            i = 1;
            while (i < rightTargets.size()) {
                game.drawLineMap(rightTargets.get(i - 1).getX(), rightTargets.get(i - 1).getY(), rightTargets.get(i).getX(), rightTargets.get(i).getY(), Color.Blue);
                game.drawTextMap(rightTargets.get(i - 1).getX(), rightTargets.get(i - 1).getY(), String.valueOf(i - 1));
                ++i;
            }
        }
        for (Agent agent : this.units) {
            agent.drawCircle(Color.Orange);
        }
        if (this.mode == 0) {
            if (this.dropship == null) {
                while (this.units.size() > 0) {
                    this.rejects.add((Agent)this.units.get(this.units.size() - 1));
                    this.units.remove(this.units.size() - 1);
                }
            }
            if (this.dropship != null) {
                this.dropship.drawCircle(Color.Orange, 16);
            }
            int total = 0;
            for (Agent agent : this.units) {
                total += this.getSpace(agent.unit.getType());
            }
            if (total >= 8) {
                this.mode = 1;
            } else if (this.hasDropship()) {
                for (Agent agent : bot.army.units) {
                    if (agent.unit.getType() == UnitType.Terran_Vulture) {
                        this.units.add(agent);
                        total += this.getSpace(agent.unit.getType());
                        bot.army.remove(agent);
                    }
                    if (total >= 8) break;
                }
            }
        }
        if (this.mode != 0 && this.units.size() == 0) {
            this.mode = 0;
            this.targetPos = -1;
            this.targets = null;
            if (this.dropship != null) {
                this.dropship.unit.move(Tyr.tileToPostion(self.getStartLocation()));
            }
        }
        if (this.mode == 1) {
            if (this.dropship == null) {
                this.mode = 0;
                return;
            }
            this.dropship.drawCircle(Color.White, 16);
            boolean done = true;
            for (Agent agent : this.units) {
                if (agent.unit.getType() == UnitType.Terran_Siege_Tank_Siege_Mode) {
                    done = false;
                    agent.order(new None(agent));
                    agent.unit.unsiege();
                    continue;
                }
                if (agent.unit.isLoaded()) continue;
                done = false;
                this.dropship.unit.load(agent.unit);
                if (agent.unit.getTargetPosition() != null && !(agent.unit.getTargetPosition().getDistance(this.dropship.unit.getPosition()) >= 100.0)) continue;
                agent.unit.move(this.dropship.unit.getPosition());
            }
            if (done) {
                this.mode = 2;
                this.acquireTarget(bot);
            }
        }
        if (this.mode == 2) {
            if (this.dropship == null) {
                this.mode = 0;
                return;
            }
            this.dropship.drawCircle(Color.Yellow, 16);
            if (this.target == null) {
                this.acquireTarget(bot);
            }
            if (this.target != null) {
                bot.drawCircle(this.target, Color.White, 300);
                int rangeSq = UnitType.Terran_Siege_Tank_Siege_Mode.groundWeapon().maxRange() * UnitType.Terran_Siege_Tank_Siege_Mode.groundWeapon().maxRange();
                boolean enemyLeft = false;
                boolean inRange = this.dropship.distanceSquared(this.target) <= 90000;
                for (Unit enemy : Tyr.game.enemy().getUnits()) {
                    if (enemy.getDistance(this.target) > 300) continue;
                    enemyLeft = true;
                    if (!inRange && this.dropship.distanceSquared(enemy) > rangeSq) continue;
                    this.mode = 3;
                    this.dropship.unit.stop();
                    break;
                }
                if (inRange && !enemyLeft) {
                    this.acquireTarget(bot);
                } else if (!inRange && this.mode == 2) {
                    this.dropship.unit.move(this.target);
                }
            }
        }
        if (this.mode == 3) {
            if (this.dropship != null) {
                this.dropship.drawCircle(Color.Red, 16);
            }
            if (this.target == null) {
                this.mode = 1;
                return;
            }
            boolean enemyLeft = false;
            for (Unit enemy : Tyr.game.enemy().getUnits()) {
                if (enemy.getDistance(this.target) > 300) continue;
                enemyLeft = true;
                break;
            }
            if (!enemyLeft) {
                this.mode = 1;
                return;
            }
            if (this.dropship != null) {
                boolean isCarrying = false;
                for (Agent agent : this.units) {
                    if (!agent.unit.isLoaded()) continue;
                    this.dropship.drawCircle(Color.Green, 6);
                    this.dropship.unit.unload(agent.unit);
                    isCarrying = true;
                    break;
                }
                if (isCarrying && bot.spaceManager.map[this.dropship.unit.getTilePosition().getX()][this.dropship.unit.getTilePosition().getY()] != 1) {
                    this.dropship.unit.move(this.target);
                }
                if (!(isCarrying && bot.spaceManager.map[this.dropship.unit.getTilePosition().getX()][this.dropship.unit.getTilePosition().getY()] != 1 || this.dropship.unit.getOrder() != Order.Move)) {
                    this.dropship.unit.stop();
                }
            }
            for (Agent agent : this.units) {
                if (agent.unit.getType() == UnitType.Terran_Siege_Tank_Tank_Mode) {
                    agent.unit.siege();
                    continue;
                }
                if (agent.unit.getType() == UnitType.Terran_Siege_Tank_Siege_Mode) continue;
                agent.unit.attack(this.target);
            }
        }
    }

    private int getSpace(UnitType type) {
        if (type == UnitType.Terran_Siege_Tank_Siege_Mode || type == UnitType.Terran_Siege_Tank_Tank_Mode) {
            return 4;
        }
        if (type == UnitType.Terran_Vulture) {
            return 2;
        }
        if (type == UnitType.Terran_Marine || type == UnitType.Terran_SCV || type == UnitType.Terran_Medic) {
            return 1;
        }
        System.out.println("Required space in dropship unknown for UnitType: " + type);
        DebugMessages.addMessage("Required space in dropship unknown for UnitType: " + type);
        return 8;
    }

    @Override
    public void cleanup() {
        super.cleanup();
        if (this.dropship != null && this.dropship.isDead()) {
            this.dropship = null;
        }
    }

    public boolean hasDropship() {
        return this.dropship != null;
    }

    public void setDropship(Agent dropship) {
        this.dropship = dropship;
    }

    public boolean acquireTarget(Tyr bot) {
        if (this.targets == null || this.targets.size() == 0 || this.targetPos >= this.targets.size()) {
            this.acquireTargets(bot);
        }
        if (this.targets == null || this.targets.size() == 0) {
            return false;
        }
        if (!this.nextTarget()) {
            return false;
        }
        do {
            if (this.target == null && !this.nextTarget()) {
                return false;
            }
            if (!Tyr.game.isVisible(Tyr.positionToTile(this.target))) {
                return true;
            }
            for (Unit enemy : Tyr.game.enemy().getUnits()) {
                if (enemy.getDistance(this.target) > 300) continue;
                return true;
            }
        } while (this.nextTarget());
        return false;
    }

    public boolean nextTarget() {
        ++this.targetPos;
        if (this.targetPos >= this.targets.size()) {
            return false;
        }
        this.target = this.targets.get(this.targetPos);
        return true;
    }

    public boolean acquireTargets(Tyr bot) {
        if (leftTargets == null) {
            this.createTargetOrder(bot);
        }
        if (leftTargets == null) {
            return false;
        }
        this.targetPos = -1;
        goLeft = !goLeft;
        this.targets = goLeft ? leftTargets : rightTargets;
        return true;
    }

    private void createTargetOrder(Tyr bot) {
        if (bot.suspectedEnemy.size() != 1) {
            return;
        }
        ArrayList<Position> positions = new ArrayList<Position>();
        HashMap<Position, Double> projection = new HashMap<Position, Double>();
        for (BaseLocation b : bot.expands) {
            if (b.getPosition().getDistance(Tyr.tileToPostion(bot.self.getStartLocation())) <= 100.0) continue;
            positions.add(b.getPosition());
            projection.put(b.getPosition(), this.projectToBorder(b.getPosition()));
        }
        double selfProjection = this.projectToBorder(Tyr.tileToPostion(bot.self.getStartLocation()));
        double enemyProjection = this.projectToBorder(bot.suspectedEnemy.get(0).getPosition());
        boolean changes = true;
        while (changes) {
            changes = false;
            int i = 0;
            while (i < positions.size() - 1) {
                double p1 = (Double)projection.get(positions.get(i));
                double p2 = (Double)projection.get(positions.get(i + 1));
                if ((!(p1 > selfProjection) || !(p2 < selfProjection)) && (p2 > selfProjection && p1 < selfProjection || (Double)projection.get(positions.get(i)) > (Double)projection.get(positions.get(i + 1)))) {
                    Position temp = (Position)positions.get(i);
                    positions.set(i, (Position)positions.get(i + 1));
                    positions.set(i + 1, temp);
                    changes = true;
                }
                ++i;
            }
        }
        rightTargets = new ArrayList();
        int i = positions.size() - 1;
        while (i >= 0 && (selfProjection >= enemyProjection && (Double)projection.get(positions.get(i)) > enemyProjection && (Double)projection.get(positions.get(i)) < selfProjection || selfProjection < enemyProjection && ((Double)projection.get(positions.get(i)) > enemyProjection || (Double)projection.get(positions.get(i)) < selfProjection))) {
            rightTargets.add((Position)positions.get(i));
            positions.remove(i);
            --i;
        }
        leftTargets = positions;
        leftTargets.add(bot.suspectedEnemy.get(0).getPosition());
        rightTargets.add(bot.suspectedEnemy.get(0).getPosition());
    }

    private double projectToBorder(Position p) {
        int width = Tyr.game.mapWidth() * 32;
        int height = Tyr.game.mapHeight() * 32;
        int xd1 = p.getX();
        int xd2 = width - p.getX();
        int yd1 = p.getY();
        int yd2 = height - p.getY();
        if (Math.min(xd1, xd2) < Math.min(yd1, yd2)) {
            if (xd1 < xd2) {
                return 0.5 + (double)yd1 / 4.0 / (double)height;
            }
            return (double)yd2 / 4.0 / (double)height;
        }
        if (yd1 < yd2) {
            return 0.25 + (double)xd2 / 4.0 / (double)width;
        }
        return 0.75 + (double)xd1 / 4.0 / (double)width;
    }
}

