/*
 * Decompiled with CFR 0.152.
 */
import bwapi.Color;
import bwapi.Game;
import bwapi.Player;
import bwapi.Position;
import bwapi.Unit;
import bwapi.UnitType;
import java.util.ArrayList;

public class DefensiveStructures {
    Position defendedPosition;
    private Position defensePos;
    ArrayList<Unit> defenses = new ArrayList();
    public boolean tooFar = false;
    public boolean disabled = false;
    TankDefense tanks;

    public DefensiveStructures(Position defendedPosition, Position defensePos) {
        this.defendedPosition = defendedPosition;
        this.defensePos = defensePos;
        this.tanks = new TankDefense(Tyr.bot.hobos, defensePos);
        if (BWTAInitializer.initialized && Tyr.bot.self != null) {
            this.tooFar = Tyr.tileToPostion(Tyr.bot.self.getStartLocation()).getDistance(defensePos) > 1200.0;
        }
    }

    public void add(Unit unit) {
        this.defenses.add(unit);
    }

    public void onFrame(Game game, Player self, Tyr bot) {
        if (this.tanks.units.size() < bot.defensiveTanks) {
            for (Squad s : bot.army.squads) {
                s.addTanks(this.tanks, bot.defensiveTanks - this.tanks.units.size());
            }
        }
        this.tanks.cleanup();
        this.tanks.onFrame(game, self, bot);
        int i = 0;
        while (i < this.defenses.size()) {
            if (this.defenses.get(i) == null || this.defenses.get(i).getHitPoints() <= 0 || !this.defenses.get(i).exists() || this.defenses.get(i).getRemoveTimer() != 0) {
                this.defenses.remove(i);
                --i;
            }
            ++i;
        }
        for (Unit structure : this.defenses) {
            game.drawBoxMap(structure.getTilePosition().getX() * 32, structure.getTilePosition().getY() * 32, structure.getTilePosition().getX() * 32 + structure.getType().tileWidth() * 32, structure.getTilePosition().getY() * 32 + structure.getType().tileHeight() * 32, Color.Orange);
        }
    }

    public int getUnitCount(UnitType type) {
        int count = 0;
        for (Unit unit : this.defenses) {
            if (unit.getType() != type) continue;
            ++count;
        }
        for (BuildCommand com : Tyr.bot.buildCommands) {
            if (com.building != type || !(com.position.getDistance(Tyr.positionToTile(this.defensePos)) < 128.0)) continue;
            ++count;
        }
        return count;
    }

    public Position getDefensePos() {
        if (this.defensePos == null) {
            this.defensePos = Tyr.bot.getMainExit();
            Position start = Tyr.tileToPostion(Tyr.bot.self.getStartLocation());
            this.defensePos = new Position((this.defensePos.getX() + start.getX()) / 2, (this.defensePos.getY() + start.getY()) / 2);
        }
        return this.defensePos;
    }

    public void disable() {
        this.tanks.disable();
        for (Unit unit : this.defenses) {
            if (unit.getType() != UnitType.Terran_Bunker) continue;
            Agent bunker = Tyr.bot.agentMap.get(unit.getID());
            ((BunkerAgent)bunker).disabled = true;
        }
        this.disabled = true;
    }
}

