/*
 * Decompiled with CFR 0.152.
 */
import bwapi.TilePosition;
import bwapi.UnitType;

public class BuildCommand {
    public Agent worker;
    public UnitType building;
    public TilePosition position;
    public boolean fixed;
    public boolean removing = false;

    public BuildCommand(Agent worker, UnitType building, TilePosition position) {
        this.worker = worker;
        this.building = building;
        this.position = position;
        WorkerAgent wa = (WorkerAgent)worker;
        wa.resetTimer = this.getTimer();
    }

    public BuildCommand(Agent worker, UnitType building, TilePosition position, boolean fixed) {
        this.worker = worker;
        this.building = building;
        this.position = position;
        this.fixed = fixed;
        WorkerAgent wa = (WorkerAgent)worker;
        wa.resetTimer = this.getTimer();
    }

    public int mineralCost() {
        return this.building.mineralPrice();
    }

    public int gasCost() {
        return this.building.gasPrice();
    }

    public void remove(Tyr bot) {
        if (this.removing) {
            return;
        }
        this.removing = true;
        bot.reservedMinerals -= this.mineralCost();
        bot.reservedGas -= this.gasCost();
        if (!this.worker.isDead()) {
            if (((WorkerAgent)this.worker).resetTimer == (long)Tyr.game.getFrameCount()) {
                ((WorkerAgent)this.worker).isReset = true;
            }
            if (((WorkerAgent)this.worker).isReset) {
                this.worker.unit.stop();
            }
            ((WorkerAgent)this.worker).resetTimer = -1L;
            this.worker.order(new None(this.worker));
        }
    }

    public long getTimer() {
        return Tyr.game.getFrameCount() + 400 + this.worker.unit.getDistance(Tyr.tileToPostion(this.position)) / 4;
    }
}

