/*
 * Decompiled with CFR 0.152.
 */
import bwapi.Color;
import bwapi.Game;
import bwapi.Order;
import bwapi.Player;
import bwapi.Position;
import bwapi.TechType;
import bwapi.Unit;
import bwapi.UnitType;
import java.util.List;

public class BCAttack
extends Command {
    private Position target;
    private static final boolean stutterstep = false;

    public BCAttack(Agent agent, Position target) {
        super(agent);
        this.target = target;
    }

    @Override
    public void execute(Game game, Player self, Tyr bot) {
        this.agent.drawCircle(Color.Red);
        this.attack();
    }

    private void attack() {
        if (this.agent.distanceSquared(this.target) <= 16384) {
            return;
        }
        Unit yamatoTarget = this.agent.getYamatoTarget();
        if (yamatoTarget != null) {
            this.agent.unit.useTech(TechType.Yamato_Gun, yamatoTarget);
            return;
        }
        Order order = this.agent.unit.getOrder();
        Position orderTarget = this.agent.unit.getOrderTargetPosition();
        Unit closest = this.getClosest();
        double distSq = UnitType.Terran_Battlecruiser.groundWeapon().maxRange() - 64;
        distSq *= distSq;
        if (this.agent.unit.isHoldingPosition() || this.agent.unit.isIdle()) {
            this.agent.unit.attack(this.target);
        } else {
            double dist = this.target.getDistance(orderTarget);
            if (order == Order.AttackMove && orderTarget != null && this.agent.unit.getTarget() == null && (Math.abs(this.target.getX() - orderTarget.getX()) >= 10 || Math.abs(this.target.getY() - orderTarget.getY()) >= 10 || dist >= 10.0)) {
                this.agent.unit.attack(this.target);
            }
        }
    }

    private Unit getClosest() {
        Game game = Tyr.game;
        List<Unit> inRange = game.getUnitsInRadius(this.agent.unit.getPosition(), UnitType.Terran_Battlecruiser.groundWeapon().maxRange());
        Unit result = null;
        double distSq = game.mapHeight() * 32 + game.mapWidth() * 32;
        distSq *= distSq;
        for (Unit unit : inRange) {
            double newDist;
            if (!unit.getPlayer().isEnemy(game.self()) || !((newDist = (double)this.agent.distanceSquared(unit)) < distSq)) continue;
            result = unit;
            distSq = newDist;
        }
        return result;
    }

    @Override
    public boolean replace(Command command) {
        if (!command.getClass().equals(BCAttack.class)) {
            return true;
        }
        return ((BCAttack)command).target.getX() != this.target.getX() || ((BCAttack)command).target.getY() != this.target.getY();
    }
}

